/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.dht.db;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.dht.DHTEvent;
import com.limegroup.gnutella.dht.DHTEventListener;
import com.limegroup.gnutella.dht.DHTManager;
import com.limegroup.gnutella.dht.db.PushProxiesValue;
import com.limegroup.gnutella.dht.db.PushProxiesValueFactory;
import com.limegroup.gnutella.dht.db.PushProxiesValueImpl;
import com.limegroup.gnutella.dht.util.KUIDUtils;
import com.limegroup.gnutella.settings.DHTSettings;
import java.util.Collection;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.IpPort;
import org.limewire.io.IpPortSet;
import org.limewire.mojito.KUID;
import org.limewire.mojito.concurrent.DHTFuture;
import org.limewire.mojito.concurrent.DHTFutureListener;
import org.limewire.mojito.result.StoreResult;

@Singleton
public class PushProxiesPublisher
implements DHTEventListener {
    private static final Log LOG = LogFactory.getLog(PushProxiesPublisher.class);
    private volatile PushProxiesValue lastSeenValue;
    private volatile PushProxiesValue lastPublishedValue;
    private final PushProxiesValueFactory pushProxiesValueFactory;
    private final ScheduledExecutorService backgroundExecutor;
    private volatile ScheduledFuture publishingFuture;
    private final DHTManager dhtManager;

    @Inject
    public PushProxiesPublisher(PushProxiesValueFactory pushProxiesValueFactory, @Named(value="backgroundExecutor") ScheduledExecutorService scheduledExecutorService, DHTManager dHTManager) {
        this.pushProxiesValueFactory = pushProxiesValueFactory;
        this.backgroundExecutor = scheduledExecutorService;
        this.dhtManager = dHTManager;
    }

    private PushProxiesValue getCurrentPushproxiesValue() {
        PushProxiesValue pushProxiesValue = this.pushProxiesValueFactory.createDHTValueForSelf();
        return pushProxiesValue.getPushProxies().isEmpty() ? null : PushProxiesPublisher.createCopy(pushProxiesValue);
    }

    private static final PushProxiesValue createCopy(PushProxiesValue pushProxiesValue) {
        return new PushProxiesValueImpl(pushProxiesValue.getVersion(), pushProxiesValue.getGUID(), pushProxiesValue.getFeatures(), pushProxiesValue.getFwtVersion(), pushProxiesValue.getPort(), pushProxiesValue.getPushProxies());
    }

    void publish() {
        PushProxiesValue pushProxiesValue = this.getValueToPublish();
        if (pushProxiesValue != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("publishing: " + pushProxiesValue));
            }
            GUID gUID = new GUID(this.lastPublishedValue.getGUID());
            KUID kUID = KUIDUtils.toKUID(gUID);
            DHTFuture<StoreResult> dHTFuture = this.dhtManager.put(kUID, this.lastPublishedValue);
            if (LOG.isDebugEnabled() && dHTFuture != null) {
                dHTFuture.addDHTFutureListener(new DHTFutureListener<StoreResult>(){

                    @Override
                    public void handleCancellationException(CancellationException cancellationException) {
                        LOG.debug((Object)"cancelled", (Throwable)cancellationException);
                    }

                    @Override
                    public void handleExecutionException(ExecutionException executionException) {
                        LOG.debug((Object)"execution", (Throwable)executionException);
                    }

                    @Override
                    public void handleFutureSuccess(StoreResult storeResult) {
                        LOG.debug((Object)("success: " + storeResult));
                    }

                    @Override
                    public void handleInterruptedException(InterruptedException interruptedException) {
                        LOG.debug((Object)"interrupted", (Throwable)interruptedException);
                    }
                });
            }
        }
    }

    PushProxiesValue getValueToPublish() {
        if (this.pushProxiesAreStable() && this.valueToPublishChangedSignificantly()) {
            this.lastPublishedValue = this.lastSeenValue;
            return this.lastPublishedValue;
        }
        return null;
    }

    boolean valueToPublishChangedSignificantly() {
        if (this.lastSeenValue == null || this.lastSeenValue.equals(this.lastPublishedValue)) {
            return false;
        }
        if (this.lastPublishedValue == null) {
            return true;
        }
        if (this.lastSeenValue.getFwtVersion() != this.lastPublishedValue.getFwtVersion()) {
            return true;
        }
        IpPortSet ipPortSet = new IpPortSet((Collection<? extends IpPort>)this.lastPublishedValue.getPushProxies());
        ipPortSet.retainAll(this.lastSeenValue.getPushProxies());
        return ipPortSet.size() < 2;
    }

    boolean pushProxiesAreStable() {
        PushProxiesValue pushProxiesValue = this.lastSeenValue;
        this.lastSeenValue = this.getCurrentPushproxiesValue();
        if (this.lastSeenValue == null) {
            return false;
        }
        return this.lastSeenValue.equals(pushProxiesValue);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("PushProxiesPublisher: ");
        stringBuilder.append(this.lastPublishedValue);
        return stringBuilder.toString();
    }

    public synchronized void handleDHTEvent(DHTEvent dHTEvent) {
        if (dHTEvent.getType() == DHTEvent.Type.CONNECTED) {
            LOG.debug((Object)"starting push proxy publishing");
            if (this.publishingFuture != null) {
                this.publishingFuture.cancel(false);
            }
            long l = DHTSettings.PUSH_PROXY_STABLE_PUBLISHING_INTERVAL.getValue();
            long l2 = (long)(Math.random() * (double)l);
            this.publishingFuture = this.backgroundExecutor.scheduleAtFixedRate(new PublishingRunnable(), l2, l, TimeUnit.MILLISECONDS);
        } else if (dHTEvent.getType() == DHTEvent.Type.STOPPED) {
            LOG.debug((Object)"stopping push proxy publishing");
            if (this.publishingFuture != null) {
                this.publishingFuture.cancel(false);
                this.publishingFuture = null;
            }
        }
    }

    private class PublishingRunnable
    implements Runnable {
        private PublishingRunnable() {
        }

        public void run() {
            PushProxiesPublisher.this.publish();
        }
    }
}

