/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.dht.db;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.PushEndpoint;
import com.limegroup.gnutella.PushEndpointCache;
import com.limegroup.gnutella.dht.db.BlockingSearchListener;
import com.limegroup.gnutella.dht.db.PushEndpointService;
import com.limegroup.gnutella.dht.db.SearchListener;
import com.limegroup.gnutella.dht.db.SearchListenerAdapter;
import com.limegroup.gnutella.settings.DHTSettings;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.IpPort;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
class PushEndpointManagerImpl
implements PushEndpointService {
    private static final Log LOG = LogFactory.getLog(PushEndpointManagerImpl.class);
    private final PushEndpointCache pushEndpointCache;
    private final PushEndpointService pushEndpointFinder;
    private final ConcurrentMap<GUID, AtomicLong> lastSearchTimeByGUID = new ConcurrentHashMap<GUID, AtomicLong>();
    private volatile long timeBetweenSearches = DHTSettings.TIME_BETWEEN_PUSH_PROXY_QUERIES.getValue();

    @Inject
    public PushEndpointManagerImpl(PushEndpointCache pushEndpointCache, @Named(value="dhtPushEndpointFinder") PushEndpointService pushEndpointService) {
        this.pushEndpointCache = pushEndpointCache;
        this.pushEndpointFinder = pushEndpointService;
    }

    void setTimeBetweenSearches(long l) {
        this.timeBetweenSearches = l;
    }

    long getTimeBetweenSearches() {
        return this.timeBetweenSearches;
    }

    @Override
    public void findPushEndpoint(GUID gUID, SearchListener<PushEndpoint> searchListener) {
        searchListener = SearchListenerAdapter.nonNullListener(searchListener);
        PushEndpoint pushEndpoint = this.pushEndpointCache.getPushEndpoint(gUID);
        if (pushEndpoint != null && !pushEndpoint.getProxies().isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Found cached endpoint: " + pushEndpoint));
            }
            searchListener.handleResult(pushEndpoint);
        } else {
            long l = System.currentTimeMillis();
            AtomicLong atomicLong = this.lastSearchTimeByGUID.putIfAbsent(gUID, new AtomicLong(l));
            if (atomicLong == null) {
                this.startSearch(gUID, searchListener);
            } else {
                long l2 = atomicLong.longValue();
                if (l - l2 > this.timeBetweenSearches) {
                    if (atomicLong.compareAndSet(l2, l)) {
                        this.startSearch(gUID, searchListener);
                    } else {
                        searchListener.searchFailed();
                    }
                } else {
                    searchListener.searchFailed();
                }
            }
        }
    }

    void startSearch(GUID gUID, final SearchListener<PushEndpoint> searchListener) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Starting dht search for: " + gUID));
        }
        if (!DHTSettings.ENABLE_PUSH_PROXY_QUERIES.getValue()) {
            searchListener.searchFailed();
            return;
        }
        this.pushEndpointFinder.findPushEndpoint(gUID, new SearchListener<PushEndpoint>(){

            @Override
            public void handleResult(PushEndpoint pushEndpoint) {
                pushEndpoint.updateProxies(true);
                IpPort ipPort = pushEndpoint.getValidExternalAddress();
                if (ipPort != null) {
                    PushEndpointManagerImpl.this.pushEndpointCache.setAddr(pushEndpoint.getClientGUID(), ipPort);
                }
                searchListener.handleResult(pushEndpoint);
            }

            @Override
            public void searchFailed() {
                LOG.debug((Object)"dht search failed");
                searchListener.searchFailed();
            }
        });
        this.purge();
    }

    @Override
    public PushEndpoint getPushEndpoint(GUID gUID) {
        BlockingSearchListener<PushEndpoint> blockingSearchListener = new BlockingSearchListener<PushEndpoint>();
        this.findPushEndpoint(gUID, blockingSearchListener);
        return blockingSearchListener.getResult();
    }

    void purge() {
        long l = System.currentTimeMillis();
        for (Map.Entry entry : this.lastSearchTimeByGUID.entrySet()) {
            assert (entry != null) : "entry is null: " + this.lastSearchTimeByGUID;
            assert (entry.getValue() != null) : "value of entry is null: " + this.lastSearchTimeByGUID;
            if (l - ((AtomicLong)entry.getValue()).get() <= 2L * this.timeBetweenSearches) continue;
            this.lastSearchTimeByGUID.remove(entry.getKey(), entry.getValue());
        }
    }

    ConcurrentMap<GUID, AtomicLong> getLastSearchTimeByGUID() {
        return this.lastSearchTimeByGUID;
    }
}

