/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.dht.db;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.PushEndpoint;
import com.limegroup.gnutella.PushEndpointFactory;
import com.limegroup.gnutella.dht.DHTManager;
import com.limegroup.gnutella.dht.db.AbstractPushProxiesValue;
import com.limegroup.gnutella.dht.db.AbstractResultHandler;
import com.limegroup.gnutella.dht.db.BlockingSearchListener;
import com.limegroup.gnutella.dht.db.PushEndpointService;
import com.limegroup.gnutella.dht.db.PushProxiesValue;
import com.limegroup.gnutella.dht.db.SearchListener;
import com.limegroup.gnutella.dht.db.SearchListenerAdapter;
import com.limegroup.gnutella.dht.util.KUIDUtils;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.IpPort;
import org.limewire.io.IpPortImpl;
import org.limewire.mojito.EntityKey;
import org.limewire.mojito.KUID;
import org.limewire.mojito.concurrent.DHTFuture;
import org.limewire.mojito.db.DHTValue;
import org.limewire.mojito.db.DHTValueEntity;
import org.limewire.mojito.result.FindValueResult;
import org.limewire.mojito.routing.Contact;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class DHTPushEndpointFinder
implements PushEndpointService {
    private static final Log LOG = LogFactory.getLog(DHTPushEndpointFinder.class);
    private final PushEndpointFactory pushEndpointFactory;
    private final DHTManager dhtManager;

    @Inject
    public DHTPushEndpointFinder(DHTManager dHTManager, PushEndpointFactory pushEndpointFactory) {
        this.dhtManager = dHTManager;
        this.pushEndpointFactory = pushEndpointFactory;
    }

    @Override
    public void findPushEndpoint(GUID gUID, SearchListener<PushEndpoint> searchListener) {
        KUID kUID;
        EntityKey entityKey;
        DHTFuture<FindValueResult> dHTFuture;
        searchListener = SearchListenerAdapter.nonNullListener(searchListener);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("starting dht lookup for guid: " + gUID));
        }
        if ((dHTFuture = this.dhtManager.get(entityKey = EntityKey.createEntityKey(kUID = KUIDUtils.toKUID(gUID), AbstractPushProxiesValue.PUSH_PROXIES))) != null) {
            dHTFuture.addDHTFutureListener(new PushEndpointHandler(this.dhtManager, gUID, kUID, searchListener));
        } else {
            LOG.debug((Object)"dht manager not bootstrapped or no dht");
            searchListener.searchFailed();
        }
    }

    @Override
    public PushEndpoint getPushEndpoint(GUID gUID) {
        BlockingSearchListener<PushEndpoint> blockingSearchListener = new BlockingSearchListener<PushEndpoint>();
        this.findPushEndpoint(gUID, blockingSearchListener);
        return blockingSearchListener.getResult();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PushEndpointHandler
    extends AbstractResultHandler {
        private final GUID guid;
        private final SearchListener<PushEndpoint> listener;

        private PushEndpointHandler(DHTManager dHTManager, GUID gUID, KUID kUID, SearchListener<PushEndpoint> searchListener) {
            super(dHTManager, kUID, searchListener, AbstractPushProxiesValue.PUSH_PROXIES);
            this.guid = gUID;
            this.listener = searchListener;
        }

        @Override
        protected AbstractResultHandler.Result handleDHTValueEntity(DHTValueEntity dHTValueEntity) {
            DHTValue dHTValue = dHTValueEntity.getValue();
            if (!(dHTValue instanceof PushProxiesValue)) {
                return AbstractResultHandler.Result.NOT_FOUND;
            }
            Contact contact = dHTValueEntity.getCreator();
            InetAddress inetAddress = ((InetSocketAddress)contact.getContactAddress()).getAddress();
            PushProxiesValue pushProxiesValue = (PushProxiesValue)dHTValue;
            byte[] byArray = this.guid.bytes();
            if (!Arrays.equals(byArray, pushProxiesValue.getGUID())) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)"The AltLoc and PushProxy GUIDs do not match!");
                }
                return AbstractResultHandler.Result.NOT_FOUND;
            }
            Set<? extends IpPort> set = pushProxiesValue.getPushProxies();
            byte by = pushProxiesValue.getFeatures();
            int n = pushProxiesValue.getFwtVersion();
            IpPortImpl ipPortImpl = new IpPortImpl(inetAddress, pushProxiesValue.getPort());
            PushEndpoint pushEndpoint = DHTPushEndpointFinder.this.pushEndpointFactory.createPushEndpoint(byArray, set, by, n, ipPortImpl);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("push endpoint found: " + pushEndpoint));
            }
            this.listener.handleResult(pushEndpoint);
            return AbstractResultHandler.Result.FOUND;
        }
    }
}

