/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.dht.db;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.IncompleteFileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.dht.db.AltLocValue;
import com.limegroup.gnutella.dht.db.AltLocValueFactory;
import com.limegroup.gnutella.dht.util.KUIDUtils;
import com.limegroup.gnutella.settings.DHTSettings;
import com.limegroup.gnutella.tigertree.HashTree;
import com.limegroup.gnutella.tigertree.HashTreeCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.limewire.collection.MultiCollection;
import org.limewire.mojito.KUID;
import org.limewire.mojito.db.DHTValue;
import org.limewire.mojito.db.Storable;
import org.limewire.mojito.db.StorableModel;
import org.limewire.mojito.result.StoreResult;
import org.limewire.mojito.util.CollectionUtils;
import org.limewire.mojito.util.DatabaseUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class AltLocModel
implements StorableModel {
    private final Map<KUID, Storable> values = Collections.synchronizedMap(new HashMap());
    private final AltLocValueFactory altLocValueFactory;
    private final Provider<HashTreeCache> tigerTreeCache;
    private final Provider<FileManager> fileManager;

    @Inject
    public AltLocModel(AltLocValueFactory altLocValueFactory, Provider<FileManager> provider, Provider<HashTreeCache> provider2) {
        this.altLocValueFactory = altLocValueFactory;
        this.fileManager = provider;
        this.tigerTreeCache = provider2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Storable> getStorables() {
        if (!DHTSettings.PUBLISH_ALT_LOCS.getValue()) {
            this.values.clear();
            return Collections.emptySet();
        }
        FileDesc[] fileDescArray = ((FileManager)this.fileManager.get()).getAllSharedFileDescriptors();
        ArrayList<Storable> arrayList = new ArrayList<Storable>();
        ArrayList<Storable> arrayList2 = new ArrayList<Storable>();
        Map<KUID, Storable> map = this.values;
        synchronized (map) {
            Object object;
            for (FileDesc object2 : fileDescArray) {
                KUID kUID;
                if (object2 instanceof IncompleteFileDesc || this.values.containsKey(kUID = KUIDUtils.toKUID((URN)(object = object2.getSHA1Urn())))) continue;
                long l = object2.getFileSize();
                HashTree hashTree = ((HashTreeCache)this.tigerTreeCache.get()).getHashTree((URN)object);
                byte[] byArray = null;
                if (hashTree != null) {
                    byArray = hashTree.getRootHashBytes();
                }
                AltLocValue altLocValue = this.altLocValueFactory.createAltLocValueForSelf(l, byArray);
                this.values.put(kUID, new Storable(kUID, altLocValue));
            }
            Iterator<Storable> iterator = this.values.values().iterator();
            while (iterator.hasNext()) {
                Storable storable = (Storable)iterator.next();
                KUID kUID = storable.getPrimaryKey();
                URN uRN = KUIDUtils.toURN(kUID);
                object = ((FileManager)this.fileManager.get()).getFileDescForUrn(uRN);
                if (object == null) {
                    storable = new Storable(kUID, DHTValue.EMPTY_VALUE);
                    iterator.remove();
                    arrayList.add(storable);
                    continue;
                }
                if (!((FileManager)this.fileManager.get()).isRareFile((FileDesc)object) || !DatabaseUtils.isPublishingRequired(storable)) continue;
                arrayList2.add(storable);
            }
        }
        Collections.shuffle(arrayList2);
        return new MultiCollection<Storable>((Collection<Storable>)arrayList, (Collection<Storable>)arrayList2);
    }

    @Override
    public void handleStoreResult(Storable storable, StoreResult storeResult) {
    }

    @Override
    public void handleContactChange() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("AltLocPublisher: ");
        Map<KUID, Storable> map = this.values;
        synchronized (map) {
            stringBuilder.append(CollectionUtils.toString(this.values.values()));
        }
        return stringBuilder.toString();
    }
}

