/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.dht.db;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.PushEndpoint;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.altlocs.AltLocManager;
import com.limegroup.gnutella.altlocs.AlternateLocation;
import com.limegroup.gnutella.altlocs.AlternateLocationFactory;
import com.limegroup.gnutella.dht.DHTManager;
import com.limegroup.gnutella.dht.db.AbstractAltLocValue;
import com.limegroup.gnutella.dht.db.AbstractResultHandler;
import com.limegroup.gnutella.dht.db.AltLocFinder;
import com.limegroup.gnutella.dht.db.AltLocValue;
import com.limegroup.gnutella.dht.db.PushEndpointService;
import com.limegroup.gnutella.dht.db.SearchListener;
import com.limegroup.gnutella.dht.db.SearchListenerAdapter;
import com.limegroup.gnutella.dht.util.KUIDUtils;
import com.limegroup.gnutella.settings.DHTSettings;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.ConnectableImpl;
import org.limewire.io.IpPortImpl;
import org.limewire.mojito.EntityKey;
import org.limewire.mojito.KUID;
import org.limewire.mojito.concurrent.DHTFuture;
import org.limewire.mojito.db.DHTValue;
import org.limewire.mojito.db.DHTValueEntity;
import org.limewire.mojito.result.FindValueResult;
import org.limewire.mojito.routing.Contact;
import org.limewire.nio.observer.Shutdownable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
class AltLocFinderImpl
implements AltLocFinder {
    private static final Log LOG = LogFactory.getLog(AltLocFinderImpl.class);
    private final DHTManager dhtManager;
    private final AlternateLocationFactory alternateLocationFactory;
    private final AltLocManager altLocManager;
    private final PushEndpointService pushEndpointManager;

    @Inject
    public AltLocFinderImpl(DHTManager dHTManager, AlternateLocationFactory alternateLocationFactory, AltLocManager altLocManager, @Named(value="pushEndpointManager") PushEndpointService pushEndpointService) {
        this.dhtManager = dHTManager;
        this.alternateLocationFactory = alternateLocationFactory;
        this.altLocManager = altLocManager;
        this.pushEndpointManager = pushEndpointService;
    }

    @Override
    public Shutdownable findAltLocs(URN uRN, SearchListener<AlternateLocation> searchListener) {
        searchListener = SearchListenerAdapter.nonNullListener(searchListener);
        KUID kUID = KUIDUtils.toKUID(uRN);
        EntityKey entityKey = EntityKey.createEntityKey(kUID, AbstractAltLocValue.ALT_LOC);
        final DHTFuture<FindValueResult> dHTFuture = this.dhtManager.get(entityKey);
        if (dHTFuture == null) {
            return null;
        }
        dHTFuture.addDHTFutureListener(new AltLocsHandler(this.dhtManager, uRN, kUID, searchListener));
        return new Shutdownable(){

            public void shutdown() {
                dHTFuture.cancel(true);
            }
        };
    }

    private void findPushAltLocs(GUID gUID, final URN uRN, final DHTValueEntity dHTValueEntity, final SearchListener<AlternateLocation> searchListener) {
        SearchListener<PushEndpoint> searchListener2 = new SearchListener<PushEndpoint>(){

            @Override
            public void handleResult(PushEndpoint pushEndpoint) {
                InetAddress inetAddress = ((InetSocketAddress)dHTValueEntity.getCreator().getContactAddress()).getAddress();
                InetAddress inetAddress2 = pushEndpoint.getInetAddress();
                if (inetAddress2 != null && !inetAddress2.equals(inetAddress)) {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn((Object)("Creator of " + dHTValueEntity + " and found " + pushEndpoint + " do not match!"));
                    }
                    searchListener.searchFailed();
                } else {
                    AlternateLocation alternateLocation = AltLocFinderImpl.this.alternateLocationFactory.createPushAltLoc(pushEndpoint, uRN);
                    searchListener.handleResult(alternateLocation);
                }
            }

            @Override
            public void searchFailed() {
                searchListener.searchFailed();
            }
        };
        this.pushEndpointManager.findPushEndpoint(gUID, searchListener2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AltLocsHandler
    extends AbstractResultHandler {
        private final SearchListener<AlternateLocation> listener;
        private final URN urn;

        private AltLocsHandler(DHTManager dHTManager, URN uRN, KUID kUID, SearchListener<AlternateLocation> searchListener) {
            super(dHTManager, kUID, searchListener, AbstractAltLocValue.ALT_LOC);
            this.urn = uRN;
            this.listener = searchListener;
        }

        @Override
        protected AbstractResultHandler.Result handleDHTValueEntity(DHTValueEntity dHTValueEntity) {
            DHTValue dHTValue = dHTValueEntity.getValue();
            if (!(dHTValue instanceof AltLocValue)) {
                return AbstractResultHandler.Result.NOT_FOUND;
            }
            AltLocValue altLocValue = (AltLocValue)dHTValue;
            if (altLocValue.isFirewalled()) {
                if (DHTSettings.ENABLE_PUSH_PROXY_QUERIES.getValue()) {
                    GUID gUID = new GUID(altLocValue.getGUID());
                    AltLocFinderImpl.this.findPushAltLocs(gUID, this.urn, dHTValueEntity, this.listener);
                    return AbstractResultHandler.Result.NOT_YET_FOUND;
                }
            } else {
                Contact contact = dHTValueEntity.getCreator();
                InetAddress inetAddress = ((InetSocketAddress)contact.getContactAddress()).getAddress();
                IpPortImpl ipPortImpl = new IpPortImpl(inetAddress, altLocValue.getPort());
                ConnectableImpl connectableImpl = new ConnectableImpl(ipPortImpl, altLocValue.supportsTLS());
                long l = altLocValue.getFileSize();
                byte[] byArray = altLocValue.getRootHash();
                try {
                    AlternateLocation alternateLocation = AltLocFinderImpl.this.alternateLocationFactory.createDirectDHTAltLoc(connectableImpl, this.urn, l, byArray);
                    AltLocFinderImpl.this.altLocManager.add(alternateLocation, this);
                    this.listener.handleResult(alternateLocation);
                    return AbstractResultHandler.Result.FOUND;
                }
                catch (IOException iOException) {
                    LOG.error((Object)"IOException", (Throwable)iOException);
                }
            }
            return AbstractResultHandler.Result.NOT_FOUND;
        }
    }
}

