/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.dht.db;

import com.limegroup.gnutella.dht.DHTManager;
import com.limegroup.gnutella.dht.db.SearchListener;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.mojito.EntityKey;
import org.limewire.mojito.KUID;
import org.limewire.mojito.concurrent.DHTFuture;
import org.limewire.mojito.concurrent.DHTFutureAdapter;
import org.limewire.mojito.db.DHTValueEntity;
import org.limewire.mojito.db.DHTValueType;
import org.limewire.mojito.result.FindValueResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractResultHandler
extends DHTFutureAdapter<FindValueResult> {
    private static final Log LOG = LogFactory.getLog(AbstractResultHandler.class);
    protected final DHTManager dhtManager;
    protected final KUID key;
    private final SearchListener listener;
    protected final DHTValueType valueType;

    AbstractResultHandler(DHTManager dHTManager, KUID kUID, SearchListener searchListener, DHTValueType dHTValueType) {
        this.dhtManager = dHTManager;
        this.key = kUID;
        this.listener = searchListener;
        this.valueType = dHTValueType;
        if (searchListener == null) {
            throw new NullPointerException("listener should not be null");
        }
    }

    @Override
    public void handleFutureSuccess(FindValueResult findValueResult) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("result: " + findValueResult));
        }
        Result result = Result.NOT_FOUND;
        if (findValueResult.isSuccess()) {
            for (DHTValueEntity object : findValueResult.getEntities()) {
                result = this.updateResult(result, this.handleDHTValueEntity(object));
            }
            for (EntityKey entityKey : findValueResult.getEntityKeys()) {
                DHTFuture<FindValueResult> dHTFuture;
                if (!entityKey.getDHTValueType().equals(this.valueType) || (dHTFuture = this.dhtManager.get(entityKey)) == null) continue;
                try {
                    FindValueResult interruptedException = (FindValueResult)dHTFuture.get();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("result from second lookup: " + interruptedException));
                    }
                    if (!interruptedException.isSuccess()) continue;
                    for (DHTValueEntity dHTValueEntity : interruptedException.getEntities()) {
                        result = this.updateResult(result, this.handleDHTValueEntity(dHTValueEntity));
                    }
                }
                catch (ExecutionException executionException) {
                    LOG.error((Object)"ExecutionException", (Throwable)executionException);
                }
                catch (InterruptedException interruptedException) {
                    LOG.error((Object)"InterruptedException", (Throwable)interruptedException);
                }
            }
        }
        if (result == Result.NOT_FOUND) {
            LOG.debug((Object)"Not found");
            this.listener.searchFailed();
        }
    }

    private Result updateResult(Result result, Result result2) {
        if (result == Result.FOUND || result2 == Result.FOUND) {
            return Result.FOUND;
        }
        if (result == Result.NOT_YET_FOUND || result2 == Result.NOT_YET_FOUND) {
            return Result.NOT_YET_FOUND;
        }
        return result2;
    }

    protected abstract Result handleDHTValueEntity(DHTValueEntity var1);

    @Override
    public void handleCancellationException(CancellationException cancellationException) {
        LOG.error((Object)"CancellationException", (Throwable)cancellationException);
        this.listener.searchFailed();
    }

    @Override
    public void handleExecutionException(ExecutionException executionException) {
        LOG.error((Object)"ExecutionException", (Throwable)executionException);
        this.listener.searchFailed();
    }

    @Override
    public void handleInterruptedException(InterruptedException interruptedException) {
        LOG.error((Object)"InterruptedException", (Throwable)interruptedException);
        this.listener.searchFailed();
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AbstractResultHandler)) {
            return false;
        }
        AbstractResultHandler abstractResultHandler = (AbstractResultHandler)object;
        return this.key.equals(abstractResultHandler.key) && this.valueType.equals(abstractResultHandler.valueType);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Result {
        FOUND(true),
        NOT_FOUND(false),
        NOT_YET_FOUND(false){

            public boolean isFound() {
                throw new UnsupportedOperationException("Should not have been called on " + (Object)((Object)this));
            }
        };

        private final boolean value;

        private Result(boolean bl) {
            this.value = bl;
        }

        public boolean isFound() {
            return this.value;
        }
    }
}

