/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.dht;

import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.limewire.mojito.KUID;
import org.limewire.mojito.concurrent.DHTExecutorService;
import org.limewire.mojito.routing.Bucket;
import org.limewire.mojito.routing.ClassfulNetworkCounter;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.routing.ContactFactory;
import org.limewire.mojito.routing.RouteTable;
import org.limewire.mojito.routing.Vendor;
import org.limewire.mojito.routing.Version;
import org.limewire.mojito.settings.KademliaSettings;
import org.limewire.mojito.util.CollectionUtils;
import org.limewire.mojito.util.FixedSizeHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PassiveLeafRouteTable
implements RouteTable {
    private static final long serialVersionUID = 2378400850935282184L;
    private final Bucket bucket;
    private final Contact localNode;

    public PassiveLeafRouteTable(Vendor vendor, Version version) {
        this.localNode = ContactFactory.createLocalContact(vendor, version, true);
        this.bucket = new BucketImpl(this, KademliaSettings.REPLICATION_PARAMETER.getValue());
    }

    @Override
    public synchronized void add(Contact contact) {
        if (this.isLocalNode(contact)) {
            return;
        }
        if (contact.isFirewalled()) {
            return;
        }
        ClassfulNetworkCounter classfulNetworkCounter = this.bucket.getClassfulNetworkCounter();
        if (classfulNetworkCounter == null || classfulNetworkCounter.isOkayToAdd(contact)) {
            this.bucket.addActiveContact(contact);
        }
    }

    @Override
    public synchronized void addRouteTableListener(RouteTable.RouteTableListener routeTableListener) {
    }

    @Override
    public synchronized void removeRouteTableListener(RouteTable.RouteTableListener routeTableListener) {
    }

    @Override
    public synchronized void clear() {
        this.bucket.clear();
    }

    @Override
    public synchronized Contact get(KUID kUID) {
        if (kUID.equals(this.localNode.getNodeID())) {
            return this.localNode;
        }
        return this.bucket.get(kUID);
    }

    @Override
    public synchronized Collection<Contact> getActiveContacts() {
        ArrayList<Contact> arrayList = new ArrayList<Contact>(this.bucket.getActiveContacts());
        arrayList.add(this.localNode);
        return arrayList;
    }

    @Override
    public synchronized Bucket getBucket(KUID kUID) {
        return this.bucket;
    }

    @Override
    public synchronized Collection<Bucket> getBuckets() {
        return Collections.singleton(this.bucket);
    }

    @Override
    public synchronized Collection<Contact> getCachedContacts() {
        return this.bucket.getCachedContacts();
    }

    @Override
    public synchronized Collection<Contact> getContacts() {
        return this.bucket.getActiveContacts();
    }

    @Override
    public synchronized Contact getLocalNode() {
        return this.localNode;
    }

    @Override
    public synchronized Collection<KUID> getRefreshIDs(boolean bl) {
        return Collections.emptySet();
    }

    @Override
    public synchronized void handleFailure(KUID kUID, SocketAddress socketAddress) {
        this.bucket.remove(kUID);
    }

    @Override
    public synchronized boolean isLocalNode(Contact contact) {
        return this.localNode.equals(contact);
    }

    @Override
    public synchronized void purge(long l) {
    }

    @Override
    public synchronized void purge(RouteTable.PurgeMode purgeMode, RouteTable.PurgeMode ... purgeModeArray) {
    }

    @Override
    public synchronized Collection<Contact> select(KUID kUID, int n, RouteTable.SelectMode selectMode) {
        Collection<Contact> collection = this.bucket.select(kUID, n);
        if (collection.size() >= n || selectMode == RouteTable.SelectMode.ALIVE) {
            return collection;
        }
        collection = new ArrayList<Contact>(collection);
        collection.add(this.localNode);
        return collection;
    }

    @Override
    public synchronized Contact select(KUID kUID) {
        Contact contact = this.bucket.select(kUID);
        if (contact != null) {
            return contact;
        }
        return this.localNode;
    }

    @Override
    public synchronized void setContactPinger(RouteTable.ContactPinger contactPinger) {
    }

    @Override
    public void setNotifier(DHTExecutorService dHTExecutorService) {
    }

    @Override
    public synchronized int size() {
        return this.bucket.size() + 1;
    }

    public synchronized String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getLocalNode()).append("\n");
        stringBuilder.append(this.bucket);
        return stringBuilder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BucketImpl
    implements Bucket {
        private static final long serialVersionUID = 7625655390844705296L;
        private final RouteTable routeTable;
        private final int k;
        private final Map<KUID, Contact> map;
        private final ClassfulNetworkCounter counter;

        public BucketImpl(RouteTable routeTable, int n) {
            this.routeTable = routeTable;
            this.k = n;
            this.counter = new ClassfulNetworkCounter(this);
            this.map = new FixedSizeHashMap<KUID, Contact>(n, 0.75f, true, n){
                private static final long serialVersionUID = 4026436727356877846L;

                @Override
                protected boolean removeEldestEntry(Map.Entry<KUID, Contact> entry) {
                    if (super.removeEldestEntry(entry)) {
                        BucketImpl.this.getClassfulNetworkCounter().decrementAndGet(entry.getValue());
                        return true;
                    }
                    return false;
                }
            };
        }

        @Override
        public ClassfulNetworkCounter getClassfulNetworkCounter() {
            return this.counter;
        }

        @Override
        public boolean isLocalNode(Contact contact) {
            return this.routeTable.isLocalNode(contact);
        }

        @Override
        public void addActiveContact(Contact contact) {
            this.updateContact(contact);
        }

        @Override
        public Contact updateContact(Contact contact) {
            Contact contact2 = this.map.remove(contact.getNodeID());
            if (contact2 != null) {
                this.getClassfulNetworkCounter().decrementAndGet(contact2);
            }
            Contact contact3 = this.map.put(contact.getNodeID(), contact);
            assert (contact3 == null);
            this.getClassfulNetworkCounter().incrementAndGet(contact);
            return contact2;
        }

        @Override
        public Contact addCachedContact(Contact contact) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public boolean contains(KUID kUID) {
            return this.map.containsKey(kUID);
        }

        @Override
        public boolean containsActiveContact(KUID kUID) {
            return this.contains(kUID);
        }

        @Override
        public boolean containsCachedContact(KUID kUID) {
            return false;
        }

        @Override
        public Contact get(KUID kUID) {
            return this.map.get(kUID);
        }

        @Override
        public Contact getActiveContact(KUID kUID) {
            return this.get(kUID);
        }

        @Override
        public Collection<Contact> getActiveContacts() {
            return new ArrayList<Contact>(this.map.values());
        }

        @Override
        public Collection<Contact> getCachedContacts() {
            return Collections.emptySet();
        }

        @Override
        public int getActiveSize() {
            return this.map.size();
        }

        @Override
        public int getCacheSize() {
            return this.getCachedContacts().size();
        }

        @Override
        public KUID getBucketID() {
            return KUID.MINIMUM;
        }

        @Override
        public Contact getCachedContact(KUID kUID) {
            return null;
        }

        @Override
        public int getDepth() {
            return 0;
        }

        @Override
        public Contact getLeastRecentlySeenActiveContact() {
            Contact contact = null;
            Iterator<Contact> iterator = this.map.values().iterator();
            while (iterator.hasNext()) {
                Contact contact2;
                contact = contact2 = iterator.next();
            }
            return contact;
        }

        @Override
        public Contact getLeastRecentlySeenCachedContact() {
            return null;
        }

        @Override
        public Contact getMostRecentlySeenActiveContact() {
            Iterator<Contact> iterator = this.map.values().iterator();
            if (iterator.hasNext()) {
                Contact contact = iterator.next();
                return contact;
            }
            return null;
        }

        @Override
        public Contact getMostRecentlySeenCachedContact() {
            return null;
        }

        @Override
        public long getTimeStamp() {
            return Long.MAX_VALUE;
        }

        @Override
        public boolean isActiveFull() {
            return false;
        }

        @Override
        public int getMaxActiveSize() {
            return this.k;
        }

        @Override
        public boolean isCacheFull() {
            return false;
        }

        @Override
        public boolean isRefreshRequired() {
            return false;
        }

        @Override
        public boolean isTooDeep() {
            return false;
        }

        @Override
        public void purge() {
        }

        @Override
        public boolean remove(KUID kUID) {
            Contact contact = this.map.remove(kUID);
            if (contact != null) {
                this.getClassfulNetworkCounter().decrementAndGet(contact);
                return true;
            }
            return false;
        }

        @Override
        public boolean removeActiveContact(KUID kUID) {
            return this.remove(kUID);
        }

        @Override
        public boolean removeCachedContact(KUID kUID) {
            return false;
        }

        @Override
        public Collection<Contact> select(KUID kUID, int n) {
            Contact[] contactArray = new Contact[Math.min(n, this.map.size())];
            int n2 = 0;
            for (Contact contact : this.map.values()) {
                if (n2 >= contactArray.length) break;
                contactArray[n2++] = contact;
            }
            return Arrays.asList(contactArray);
        }

        @Override
        public Contact select(KUID kUID) {
            Iterator<Contact> iterator = this.map.values().iterator();
            if (iterator.hasNext()) {
                Contact contact = iterator.next();
                return contact;
            }
            return null;
        }

        @Override
        public int size() {
            return this.getActiveSize() + this.getCacheSize();
        }

        @Override
        public List<Bucket> split() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void touch() {
        }

        public String toString() {
            return CollectionUtils.toString(this.map.values());
        }
    }
}

