/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.dht;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.gnutella.connection.ConnectionLifecycleEvent;
import com.limegroup.gnutella.dht.DHTController;
import com.limegroup.gnutella.dht.DHTControllerFactory;
import com.limegroup.gnutella.dht.DHTEvent;
import com.limegroup.gnutella.dht.DHTEventListener;
import com.limegroup.gnutella.dht.DHTManager;
import com.limegroup.gnutella.dht.NullDHTController;
import com.limegroup.gnutella.messages.vendor.DHTContactsMessage;
import com.limegroup.gnutella.settings.DHTSettings;
import com.limegroup.gnutella.util.ClassCNetworks;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.Comparators;
import org.limewire.concurrent.ExecutorsHelper;
import org.limewire.inspection.Inspectable;
import org.limewire.inspection.InspectableContainer;
import org.limewire.inspection.InspectionHistogram;
import org.limewire.inspection.InspectionPoint;
import org.limewire.io.IpPort;
import org.limewire.io.NetworkUtils;
import org.limewire.mojito.EntityKey;
import org.limewire.mojito.KUID;
import org.limewire.mojito.MojitoDHT;
import org.limewire.mojito.concurrent.DHTFuture;
import org.limewire.mojito.concurrent.DHTFutureAdapter;
import org.limewire.mojito.concurrent.DHTFutureListener;
import org.limewire.mojito.db.DHTValue;
import org.limewire.mojito.db.Database;
import org.limewire.mojito.result.FindValueResult;
import org.limewire.mojito.result.StoreResult;
import org.limewire.mojito.routing.Bucket;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.routing.RouteTable;
import org.limewire.mojito.routing.Vendor;
import org.limewire.mojito.routing.Version;
import org.limewire.mojito.settings.ContextSettings;
import org.limewire.mojito.settings.KademliaSettings;
import org.limewire.statistic.StatsUtils;
import org.limewire.util.ByteUtils;
import org.limewire.util.DebugRunnable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class DHTManagerImpl
implements DHTManager {
    private static final Log LOG = LogFactory.getLog(DHTManagerImpl.class);
    private final Vendor vendor = ContextSettings.getVendor();
    private final Version version = ContextSettings.getVersion();
    private DHTController controller = new NullDHTController();
    private final List<DHTEventListener> dhtEventListeners = new ArrayList<DHTEventListener>(1);
    private final Executor executor;
    private final Executor dispatchExecutor;
    private volatile boolean enabled = true;
    private final DHTControllerFactory dhtControllerFactory;
    @InspectionPoint(value="time for dht bootstrap")
    private final BootstrapTimer bootstrapTimer = new BootstrapTimer();
    @InspectionPoint(value="dht get statistics")
    private final TimeValuesInspectable getInspectable = new TimeValuesInspectable();
    @InspectionPoint(value="dht put statistics")
    private final TimeValuesInspectable putInspectable = new TimeValuesInspectable();

    @Inject
    public DHTManagerImpl(@Named(value="dhtExecutor") Executor executor, DHTControllerFactory dHTControllerFactory) {
        this.executor = executor;
        this.dispatchExecutor = ExecutorsHelper.newProcessingQueue("DHT-EventDispatch");
        this.dhtControllerFactory = dHTControllerFactory;
        this.addEventListener(this.bootstrapTimer);
    }

    @Override
    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    @Override
    public boolean isEnabled() {
        return !DHTSettings.DISABLE_DHT_NETWORK.getValue() && !DHTSettings.DISABLE_DHT_USER.getValue() && this.enabled;
    }

    @Override
    public synchronized void start(DHTManager.DHTMode dHTMode) {
        this.executor.execute(this.createSwitchModeCommand(dHTMode));
    }

    @Override
    public synchronized void stop() {
        DebugRunnable debugRunnable = new DebugRunnable(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                DHTManagerImpl dHTManagerImpl = DHTManagerImpl.this;
                synchronized (dHTManagerImpl) {
                    try {
                        DHTManagerImpl.this.createSwitchModeCommand(DHTManager.DHTMode.INACTIVE).run();
                    }
                    finally {
                        DHTManagerImpl.this.notifyAll();
                    }
                }
            }
        });
        this.executor.execute(debugRunnable);
        try {
            this.wait(10000L);
        }
        catch (InterruptedException interruptedException) {
            LOG.error((Object)"InterruptedException", (Throwable)interruptedException);
        }
    }

    private Runnable createSwitchModeCommand(final DHTManager.DHTMode dHTMode) {
        DebugRunnable debugRunnable = new DebugRunnable(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                DHTManagerImpl dHTManagerImpl = DHTManagerImpl.this;
                synchronized (dHTManagerImpl) {
                    if (DHTManagerImpl.this.controller.getDHTMode() == dHTMode) {
                        return;
                    }
                    DHTManagerImpl.this.controller.stop();
                    if (dHTMode == DHTManager.DHTMode.ACTIVE) {
                        DHTManagerImpl.this.controller = DHTManagerImpl.this.dhtControllerFactory.createActiveDHTNodeController(DHTManagerImpl.this.vendor, DHTManagerImpl.this.version, DHTManagerImpl.this);
                    } else if (dHTMode == DHTManager.DHTMode.PASSIVE) {
                        DHTManagerImpl.this.controller = DHTManagerImpl.this.dhtControllerFactory.createPassiveDHTNodeController(DHTManagerImpl.this.vendor, DHTManagerImpl.this.version, DHTManagerImpl.this);
                    } else if (dHTMode == DHTManager.DHTMode.PASSIVE_LEAF) {
                        DHTManagerImpl.this.controller = DHTManagerImpl.this.dhtControllerFactory.createPassiveLeafController(DHTManagerImpl.this.vendor, DHTManagerImpl.this.version, DHTManagerImpl.this);
                    } else {
                        DHTManagerImpl.this.controller = new NullDHTController();
                    }
                    DHTManagerImpl.this.controller.start();
                }
            }
        });
        return debugRunnable;
    }

    @Override
    public void addActiveDHTNode(final SocketAddress socketAddress) {
        this.executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                DHTManagerImpl dHTManagerImpl = DHTManagerImpl.this;
                synchronized (dHTManagerImpl) {
                    DHTManagerImpl.this.controller.addActiveDHTNode(socketAddress);
                }
            }
        });
    }

    @Override
    public void addPassiveDHTNode(final SocketAddress socketAddress) {
        this.executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                DHTManagerImpl dHTManagerImpl = DHTManagerImpl.this;
                synchronized (dHTManagerImpl) {
                    DHTManagerImpl.this.controller.addPassiveDHTNode(socketAddress);
                }
            }
        });
    }

    @Override
    public void addressChanged() {
        this.executor.execute(new DebugRunnable(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                DHTManagerImpl dHTManagerImpl = DHTManagerImpl.this;
                synchronized (dHTManagerImpl) {
                    if (DHTManagerImpl.this.controller.isRunning()) {
                        DHTManagerImpl.this.controller.stop();
                        DHTManagerImpl.this.controller.start();
                    }
                }
            }
        }));
    }

    @Override
    public synchronized List<IpPort> getActiveDHTNodes(int n) {
        return this.controller.getActiveDHTNodes(n);
    }

    @Override
    public synchronized DHTManager.DHTMode getDHTMode() {
        return this.controller.getDHTMode();
    }

    @Override
    public synchronized boolean isRunning() {
        return this.controller.isRunning();
    }

    @Override
    public synchronized boolean isBootstrapped() {
        return this.controller.isBootstrapped();
    }

    @Override
    public synchronized boolean isMemberOfDHT() {
        return this.isRunning() && this.isBootstrapped();
    }

    @Override
    public synchronized boolean isWaitingForNodes() {
        return this.controller.isWaitingForNodes();
    }

    @Override
    public synchronized void addEventListener(DHTEventListener dHTEventListener) {
        if (this.dhtEventListeners.contains(dHTEventListener)) {
            throw new IllegalArgumentException("Listener " + dHTEventListener + " already registered");
        }
        this.dhtEventListeners.add(dHTEventListener);
    }

    @Override
    public synchronized void dispatchEvent(final DHTEvent dHTEvent) {
        if (!this.dhtEventListeners.isEmpty()) {
            final ArrayList<DHTEventListener> arrayList = new ArrayList<DHTEventListener>(this.dhtEventListeners);
            this.dispatchExecutor.execute(new Runnable(){

                public void run() {
                    for (DHTEventListener dHTEventListener : arrayList) {
                        dHTEventListener.handleDHTEvent(dHTEvent);
                    }
                }
            });
        }
    }

    @Override
    public synchronized void removeEventListener(DHTEventListener dHTEventListener) {
        this.dhtEventListeners.remove(dHTEventListener);
    }

    @Override
    public synchronized MojitoDHT getMojitoDHT() {
        return this.controller.getMojitoDHT();
    }

    @Override
    public void handleConnectionLifecycleEvent(final ConnectionLifecycleEvent connectionLifecycleEvent) {
        Runnable runnable = null;
        runnable = connectionLifecycleEvent.isDisconnectedEvent() || connectionLifecycleEvent.isNoInternetEvent() ? new DebugRunnable(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                DHTManagerImpl dHTManagerImpl = DHTManagerImpl.this;
                synchronized (dHTManagerImpl) {
                    if (DHTManagerImpl.this.controller.isRunning() && !DHTSettings.FORCE_DHT_CONNECT.getValue()) {
                        DHTManagerImpl.this.controller.stop();
                        DHTManagerImpl.this.controller = new NullDHTController();
                    }
                }
            }
        }) : new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                DHTManagerImpl dHTManagerImpl = DHTManagerImpl.this;
                synchronized (dHTManagerImpl) {
                    DHTManagerImpl.this.controller.handleConnectionLifecycleEvent(connectionLifecycleEvent);
                }
            }
        };
        this.executor.execute(runnable);
    }

    @Override
    public Vendor getVendor() {
        return this.vendor;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public void handleDHTContactsMessage(final DHTContactsMessage dHTContactsMessage) {
        this.executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                DHTManagerImpl dHTManagerImpl = DHTManagerImpl.this;
                synchronized (dHTManagerImpl) {
                    for (Contact contact : dHTContactsMessage.getContacts()) {
                        DHTManagerImpl.this.controller.addContact(contact);
                    }
                }
            }
        });
    }

    @Override
    public synchronized DHTFuture<FindValueResult> get(EntityKey entityKey) {
        MojitoDHT mojitoDHT = this.getMojitoDHT();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("DHT:" + mojitoDHT));
        }
        if (mojitoDHT == null || !mojitoDHT.isBootstrapped()) {
            LOG.debug((Object)"DHT is null or is not bootstrapped");
            return null;
        }
        TimeInspector<FindValueResult> timeInspector = new TimeInspector<FindValueResult>(this.getInspectable){

            @Override
            public void handleFutureSuccess(FindValueResult findValueResult) {
                this.count(findValueResult.isSuccess());
            }
        };
        DHTFuture<FindValueResult> dHTFuture = mojitoDHT.get(entityKey);
        dHTFuture.addDHTFutureListener((DHTFutureListener<FindValueResult>)timeInspector);
        return dHTFuture;
    }

    @Override
    public synchronized DHTFuture<StoreResult> put(KUID kUID, DHTValue dHTValue) {
        MojitoDHT mojitoDHT = this.getMojitoDHT();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("DHT: " + mojitoDHT));
        }
        if (mojitoDHT == null || !mojitoDHT.isBootstrapped()) {
            LOG.debug((Object)"DHT is null or unable to bootstrap");
            return null;
        }
        TimeInspector<StoreResult> timeInspector = new TimeInspector<StoreResult>(this.putInspectable){

            @Override
            public void handleFutureSuccess(StoreResult storeResult) {
                boolean bl = (double)storeResult.getLocations().size() > 0.8 * (double)KademliaSettings.REPLICATION_PARAMETER.getValue();
                this.count(bl);
            }
        };
        DHTFuture<StoreResult> dHTFuture = mojitoDHT.put(kUID, dHTValue);
        dHTFuture.addDHTFutureListener((DHTFutureListener<StoreResult>)timeInspector);
        return dHTFuture;
    }

    private static List<Double> getXorDistances(Double d, List<Double> list) {
        ArrayList<Double> arrayList = new ArrayList<Double>(list.size());
        for (Double d2 : list) {
            if (d2 == d) continue;
            arrayList.add(Double.valueOf(d.longValue() ^ d2.longValue()));
        }
        return arrayList;
    }

    private static List<Double> getDouble(Collection<? extends Contact> collection) {
        ArrayList<Double> arrayList = new ArrayList<Double>(collection.size());
        for (Contact contact : collection) {
            arrayList.add(DHTManagerImpl.getDoubleKUID(contact.getNodeID()));
        }
        return arrayList;
    }

    private static double getDoubleKUID(KUID kUID) {
        byte[] byArray = kUID.getBytes();
        long l = byArray[0];
        for (int i = 1; i < 4; ++i) {
            l >>>= 8;
            l |= (long)byArray[i];
        }
        return l;
    }

    private static double getUnsignedMaskedAddress(Contact contact) {
        InetSocketAddress inetSocketAddress = (InetSocketAddress)contact.getContactAddress();
        long l = (long)NetworkUtils.getClassC(inetSocketAddress.getAddress()) & 0xFFFFFFFFL;
        return l;
    }

    static class TimeValuesInspectable
    implements Inspectable {
        final InspectionHistogram<Integer> successes = new InspectionHistogram();
        final InspectionHistogram<Integer> failures = new InspectionHistogram();
        volatile int maxSuccessful = 0;
        volatile int maxFailed = 0;

        TimeValuesInspectable() {
        }

        public synchronized Object inspect() {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("success hist", this.successes.inspect());
            hashMap.put("failure hist", this.failures.inspect());
            hashMap.put("max success", this.maxSuccessful);
            hashMap.put("max failure", this.maxFailed);
            return hashMap;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TimeInspector<T>
    extends DHTFutureAdapter<T> {
        private final long startTime = System.currentTimeMillis();
        private final TimeValuesInspectable values;

        public TimeInspector(TimeValuesInspectable timeValuesInspectable) {
            this.values = timeValuesInspectable;
        }

        public int getCurrentDuration() {
            return ByteUtils.long2int(System.currentTimeMillis() - this.startTime);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void count(boolean bl) {
            int n = this.getCurrentDuration();
            int n2 = this.getIndex(n);
            if (bl) {
                this.values.successes.count(n2);
            } else {
                this.values.failures.count(n2);
            }
            TimeValuesInspectable timeValuesInspectable = this.values;
            synchronized (timeValuesInspectable) {
                if (bl) {
                    this.values.maxSuccessful = Math.max(this.values.maxSuccessful, n);
                } else {
                    this.values.maxFailed = Math.max(this.values.maxFailed, n);
                }
            }
        }

        public int getIndex(int n) {
            int n2 = n == 0 ? 0 : (n < 5000 && n > 0 ? n / 500 + 1 : (n < 10000 ? (n - 5000) / 1000 + 11 : (n < 60000 ? (n - 10000) / 5000 + 16 : (n < 180000 ? (n - 60000) / 10000 + 26 : (n < 360000 ? (n - 180000) / 30000 + 38 : 44)))));
            return n2;
        }
    }

    private class BootstrapTimer
    implements DHTEventListener,
    Inspectable {
        private long start;
        private long stop;

        private BootstrapTimer() {
        }

        public synchronized Object inspect() {
            HashMap<String, Number> hashMap = new HashMap<String, Number>();
            hashMap.put("ver", 1);
            hashMap.put("start", this.start);
            hashMap.put("stop", this.stop);
            return hashMap;
        }

        public synchronized void handleDHTEvent(DHTEvent dHTEvent) {
            if (dHTEvent.getType() == DHTEvent.Type.STARTING) {
                this.start = System.currentTimeMillis();
            } else if (dHTEvent.getType() == DHTEvent.Type.CONNECTED && this.start != 0L) {
                this.stop = System.currentTimeMillis();
            }
        }
    }

    private class DBHist
    implements Inspectable {
        private final int breaks;

        DBHist(int n) {
            this.breaks = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object inspect() {
            MojitoDHT mojitoDHT = DHTManagerImpl.this.getMojitoDHT();
            if (mojitoDHT != null) {
                ArrayList<BigInteger> arrayList;
                Database database;
                Database database2 = database = mojitoDHT.getDatabase();
                synchronized (database2) {
                    Set<KUID> set = database.keySet();
                    arrayList = new ArrayList<BigInteger>(set.size());
                    for (KUID kUID : set) {
                        arrayList.add(kUID.toBigInteger());
                    }
                }
                return StatsUtils.getHistogramBigInt(arrayList, this.breaks);
            }
            return Collections.emptyList();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @InspectableContainer
    private class DHTInspectables {
        private static final int VERSION = 3;
        @InspectionPoint(value="general dht stats")
        public Inspectable general = new Inspectable(){

            public Object inspect() {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                DHTInspectables.this.addVersion(hashMap);
                DHTManager.DHTMode dHTMode = DHTManagerImpl.this.getDHTMode();
                boolean bl = DHTManagerImpl.this.isRunning();
                boolean bl2 = DHTManagerImpl.this.isBootstrapped();
                boolean bl3 = DHTManagerImpl.this.isWaitingForNodes();
                boolean bl4 = DHTManagerImpl.this.isEnabled();
                Version version = DHTManagerImpl.this.getVersion();
                hashMap.put("mode", dHTMode.byteValue());
                hashMap.put("v", version.shortValue());
                hashMap.put("r", bl);
                hashMap.put("b", bl2);
                hashMap.put("w", bl3);
                hashMap.put("e", bl4);
                MojitoDHT mojitoDHT = DHTManagerImpl.this.getMojitoDHT();
                if (mojitoDHT != null) {
                    hashMap.put("s", mojitoDHT.size().toByteArray());
                    RouteTable routeTable = mojitoDHT.getRouteTable();
                    Contact contact = routeTable.getLocalNode();
                    hashMap.put("id", contact.getNodeID().getBytes());
                }
                return hashMap;
            }
        };
        @InspectionPoint(value="dht contacts")
        public Inspectable contacts = new Inspectable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object inspect() {
                HashMap<String, Map<String, Object>> hashMap = new HashMap<String, Map<String, Object>>();
                DHTInspectables.this.addVersion(hashMap);
                MojitoDHT mojitoDHT = DHTManagerImpl.this.getMojitoDHT();
                if (mojitoDHT != null) {
                    RouteTable routeTable;
                    RouteTable routeTable2 = routeTable = mojitoDHT.getRouteTable();
                    synchronized (routeTable2) {
                        double d;
                        double d2 = DHTManagerImpl.getDoubleKUID(routeTable.getLocalNode().getNodeID());
                        List list = DHTManagerImpl.getDouble(routeTable.getActiveContacts());
                        hashMap.put("acc", StatsUtils.quickStatsDouble(list).getMap());
                        hashMap.put("accx", StatsUtils.quickStatsDouble(DHTManagerImpl.getXorDistances(d2, list)).getMap());
                        List list2 = DHTManagerImpl.getDouble(routeTable.getCachedContacts());
                        hashMap.put("ccc", StatsUtils.quickStatsDouble(list2).getMap());
                        hashMap.put("cccx", StatsUtils.quickStatsDouble(DHTManagerImpl.getXorDistances(d2, list2)).getMap());
                        ArrayList<Double> arrayList = new ArrayList<Double>();
                        ArrayList<Double> arrayList2 = new ArrayList<Double>();
                        ArrayList<Double> arrayList3 = new ArrayList<Double>();
                        for (Contact contact : routeTable.getActiveContacts()) {
                            d = DHTManagerImpl.getUnsignedMaskedAddress(contact);
                            arrayList.add(d);
                            arrayList3.add(d);
                        }
                        for (Contact contact : routeTable.getCachedContacts()) {
                            d = DHTManagerImpl.getUnsignedMaskedAddress(contact);
                            arrayList2.add(d);
                            arrayList3.add(d);
                        }
                        hashMap.put("aips", StatsUtils.quickStatsDouble(arrayList).getMap());
                        hashMap.put("cips", StatsUtils.quickStatsDouble(arrayList2).getMap());
                        hashMap.put("allips", StatsUtils.quickStatsDouble(arrayList3).getMap());
                    }
                }
                return hashMap;
            }
        };
        @InspectionPoint(value="dht route table dump")
        public Inspectable RTDump = new Inspectable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object inspect() {
                HashMap<String, Collection<Contact>> hashMap = new HashMap<String, Collection<Contact>>();
                DHTInspectables.this.addVersion(hashMap);
                MojitoDHT mojitoDHT = DHTManagerImpl.this.getMojitoDHT();
                if (mojitoDHT != null) {
                    RouteTable routeTable;
                    RouteTable routeTable2 = routeTable = mojitoDHT.getRouteTable();
                    synchronized (routeTable2) {
                        hashMap.put("active", routeTable.getActiveContacts());
                        hashMap.put("cached", routeTable.getCachedContacts());
                    }
                }
                return hashMap;
            }
        };
        @InspectionPoint(value="dht route table class C networks")
        public Inspectable routeTableTop10Networks = new Inspectable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object inspect() {
                HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
                DHTInspectables.this.addVersion(hashMap);
                MojitoDHT mojitoDHT = DHTManagerImpl.this.getMojitoDHT();
                if (mojitoDHT != null) {
                    RouteTable routeTable;
                    RouteTable routeTable2 = routeTable = mojitoDHT.getRouteTable();
                    synchronized (routeTable2) {
                        hashMap.put("ta", this.getTopNetworks(routeTable.getActiveContacts(), 10));
                        hashMap.put("tc", this.getTopNetworks(routeTable.getCachedContacts(), 10));
                    }
                }
                return hashMap;
            }

            private byte[] getTopNetworks(Collection<? extends Contact> collection, int n) {
                ClassCNetworks classCNetworks = new ClassCNetworks();
                for (Contact contact : collection) {
                    InetAddress inetAddress = ((InetSocketAddress)contact.getContactAddress()).getAddress();
                    classCNetworks.add(inetAddress, 1);
                }
                return classCNetworks.getTopInspectable(10);
            }
        };
        @InspectionPoint(value="dht buckets")
        public Inspectable buckets = new Inspectable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object inspect() {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                DHTInspectables.this.addVersion(hashMap);
                MojitoDHT mojitoDHT = DHTManagerImpl.this.getMojitoDHT();
                if (mojitoDHT != null) {
                    RouteTable routeTable;
                    RouteTable routeTable2 = routeTable = mojitoDHT.getRouteTable();
                    synchronized (routeTable2) {
                        double d = DHTManagerImpl.getDoubleKUID(routeTable.getLocalNode().getNodeID());
                        Collection<Bucket> collection = routeTable.getBuckets();
                        ArrayList<Double> arrayList = new ArrayList<Double>(collection.size());
                        ArrayList<Double> arrayList2 = new ArrayList<Double>(collection.size());
                        ArrayList<Double> arrayList3 = new ArrayList<Double>(collection.size());
                        ArrayList<Double> arrayList4 = new ArrayList<Double>(collection.size());
                        double d2 = 0.0;
                        long l = System.currentTimeMillis();
                        for (Bucket bucket : collection) {
                            arrayList.add(Double.valueOf(bucket.getDepth()));
                            arrayList2.add(Double.valueOf(bucket.size()));
                            arrayList3.add(DHTManagerImpl.getDoubleKUID(bucket.getBucketID()));
                            arrayList4.add(Double.valueOf(l - bucket.getTimeStamp()));
                            if (bucket.isRefreshRequired()) continue;
                            d2 += 1.0;
                        }
                        hashMap.put("bk", StatsUtils.quickStatsDouble(arrayList3).getMap());
                        hashMap.put("bkx", StatsUtils.quickStatsDouble(DHTManagerImpl.getXorDistances(d, arrayList3)).getMap());
                        hashMap.put("bd", StatsUtils.quickStatsDouble(arrayList).getMap());
                        hashMap.put("bs", StatsUtils.quickStatsDouble(arrayList2).getMap());
                        hashMap.put("bt", StatsUtils.quickStatsDouble(arrayList4).getMap());
                        hashMap.put("bfr", (int)(100.0 * d2 / (double)collection.size()));
                    }
                }
                return hashMap;
            }
        };
        @InspectionPoint(value="dht buckets detailed")
        public Inspectable bucketDetail = new Inspectable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object inspect() {
                ArrayList arrayList = new ArrayList();
                MojitoDHT mojitoDHT = DHTManagerImpl.this.getMojitoDHT();
                if (mojitoDHT != null) {
                    RouteTable routeTable;
                    RouteTable routeTable2 = routeTable = mojitoDHT.getRouteTable();
                    synchronized (routeTable2) {
                        Collection<Bucket> collection = routeTable.getBuckets();
                        for (Bucket bucket : collection) {
                            HashMap<String, Object> hashMap = new HashMap<String, Object>();
                            hashMap.put("i", bucket.getBucketID().getBytes());
                            hashMap.put("d", bucket.getDepth());
                            hashMap.put("t", System.currentTimeMillis() - bucket.getTimeStamp());
                            hashMap.put("a", bucket.getActiveSize());
                            hashMap.put("c", bucket.getCacheSize());
                            hashMap.put("f", !bucket.isRefreshRequired());
                            arrayList.add(hashMap);
                        }
                    }
                }
                return arrayList;
            }
        };
        @InspectionPoint(value="dht database")
        public Inspectable database = new Inspectable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object inspect() {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                DHTInspectables.this.addVersion(hashMap);
                MojitoDHT mojitoDHT = DHTManagerImpl.this.getMojitoDHT();
                if (mojitoDHT != null) {
                    Database database = mojitoDHT.getDatabase();
                    Double d = DHTManagerImpl.getDoubleKUID(mojitoDHT.getLocalNodeID());
                    ArrayList<Double> arrayList = null;
                    ArrayList<Double> arrayList2 = null;
                    ArrayList<Double> arrayList3 = null;
                    Object object = database;
                    synchronized (object) {
                        hashMap.put("dvc", database.getValueCount());
                        Set<KUID> set = database.keySet();
                        arrayList = new ArrayList<Double>(set.size());
                        arrayList2 = new ArrayList<Double>(set.size());
                        arrayList3 = new ArrayList<Double>(set.size());
                        for (KUID kUID : set) {
                            Double d2 = DHTManagerImpl.getDoubleKUID(kUID);
                            double d3 = database.getRequestLoad(kUID, false);
                            arrayList.add(d2);
                            arrayList2.add(d3);
                            if (d == d2) continue;
                            d2 = d.longValue() ^ d2.longValue();
                            arrayList3.add(d2 - d3 * 2.147483647E9);
                        }
                    }
                    object = DHTManagerImpl.getXorDistances(d, arrayList);
                    hashMap.put("dsk", StatsUtils.quickStatsDouble(arrayList).getMap());
                    hashMap.put("drl", StatsUtils.quickStatsDouble(arrayList2).getMap());
                    hashMap.put("dskx", StatsUtils.quickStatsDouble((List<Double>)object).getMap());
                    hashMap.put("dxlt", StatsUtils.quickStatsDouble(arrayList3).getTTestMap());
                }
                return hashMap;
            }
        };
        @InspectionPoint(value="dht database top 10 keys")
        public Inspectable databaseTop10Keys = new Inspectable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object inspect() {
                ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
                MojitoDHT mojitoDHT = DHTManagerImpl.this.getMojitoDHT();
                if (mojitoDHT != null) {
                    Database database = mojitoDHT.getDatabase();
                    TreeMap<Double, KUID> treeMap = new TreeMap<Double, KUID>(Comparators.inverseDoubleComparator());
                    Object object = database;
                    synchronized (object) {
                        Set<KUID> set = database.keySet();
                        for (KUID kUID : set) {
                            treeMap.put(Double.valueOf(database.getRequestLoad(kUID, false)), kUID);
                        }
                    }
                    object = treeMap.keySet().iterator();
                    while (object.hasNext()) {
                        double d = (Double)object.next();
                        if (arrayList.size() >= 20) break;
                        arrayList.add(BigInteger.valueOf(Double.doubleToLongBits(d)).toByteArray());
                        arrayList.add(((KUID)treeMap.get(d)).getBytes());
                    }
                }
                return arrayList;
            }
        };
        @InspectionPoint(value="dht internal format stats")
        public Inspectable mojitoStats = new Inspectable(){

            public Object inspect() {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(byteArrayOutputStream);
                try {
                    DHTManagerImpl.this.getMojitoDHT().getDHTStats().dump(outputStreamWriter, false);
                    ((Writer)outputStreamWriter).flush();
                    return byteArrayOutputStream.toByteArray();
                }
                catch (IOException iOException) {
                    return iOException.getMessage();
                }
            }
        };
        @InspectionPoint(value="dht database 10 histogram")
        public Inspectable database10StoredHist = new DBHist(10);
        @InspectionPoint(value="dht database 100 histogram")
        public Inspectable database100StoredHist = new DBHist(100);
        @InspectionPoint(value="dht database 500 histogram")
        public Inspectable database500StoredHist = new DBHist(500);

        private DHTInspectables() {
        }

        private void addVersion(Map<String, Object> map) {
            map.put("sv", 3);
        }
    }
}

