/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.dht;

import com.limegroup.gnutella.connection.ConnectionLifecycleListener;
import com.limegroup.gnutella.dht.DHTEvent;
import com.limegroup.gnutella.dht.DHTEventListener;
import com.limegroup.gnutella.messages.vendor.DHTContactsMessage;
import com.limegroup.gnutella.util.EventDispatcher;
import java.net.SocketAddress;
import java.util.List;
import org.limewire.io.IpPort;
import org.limewire.mojito.EntityKey;
import org.limewire.mojito.KUID;
import org.limewire.mojito.MojitoDHT;
import org.limewire.mojito.concurrent.DHTFuture;
import org.limewire.mojito.db.DHTValue;
import org.limewire.mojito.result.FindValueResult;
import org.limewire.mojito.result.StoreResult;
import org.limewire.mojito.routing.Vendor;
import org.limewire.mojito.routing.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface DHTManager
extends ConnectionLifecycleListener,
EventDispatcher<DHTEvent, DHTEventListener> {
    public void setEnabled(boolean var1);

    public boolean isEnabled();

    public void start(DHTMode var1);

    public void stop();

    public void addActiveDHTNode(SocketAddress var1);

    public void addPassiveDHTNode(SocketAddress var1);

    public void addressChanged();

    public List<IpPort> getActiveDHTNodes(int var1);

    public DHTMode getDHTMode();

    public boolean isRunning();

    public boolean isBootstrapped();

    public boolean isMemberOfDHT();

    public boolean isWaitingForNodes();

    public MojitoDHT getMojitoDHT();

    public Vendor getVendor();

    public Version getVersion();

    public void handleDHTContactsMessage(DHTContactsMessage var1);

    public DHTFuture<FindValueResult> get(EntityKey var1);

    public DHTFuture<StoreResult> put(KUID var1, DHTValue var2);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DHTMode
    extends Enum<DHTMode> {
        public static final /* enum */ DHTMode INACTIVE = new DHTMode(0, new byte[]{73, 68, 72, 84});
        public static final /* enum */ DHTMode ACTIVE = new DHTMode(1, new byte[]{65, 68, 72, 84});
        public static final /* enum */ DHTMode PASSIVE = new DHTMode(2, new byte[]{80, 68, 72, 84});
        public static final /* enum */ DHTMode PASSIVE_LEAF = new DHTMode(3, new byte[]{76, 68, 72, 84});
        public static final byte DHT_MODE_MASK = 15;
        private final int mode;
        private final byte[] capabilityName;
        private static final DHTMode[] MODES;
        private static final /* synthetic */ DHTMode[] $VALUES;

        public static final DHTMode[] values() {
            return (DHTMode[])$VALUES.clone();
        }

        public static DHTMode valueOf(String string) {
            return Enum.valueOf(DHTMode.class, string);
        }

        private DHTMode(int n2, byte[] byArray) {
            assert (byArray.length == 4);
            this.mode = n2;
            this.capabilityName = byArray;
        }

        public byte byteValue() {
            return (byte)(this.mode & 0xFF);
        }

        public byte[] getCapabilityName() {
            byte[] byArray = new byte[this.capabilityName.length];
            System.arraycopy(this.capabilityName, 0, byArray, 0, byArray.length);
            return byArray;
        }

        public static DHTMode valueOf(int n) {
            int n2 = (n & 0xFF) % MODES.length;
            DHTMode dHTMode = MODES[n2];
            if (dHTMode.mode == n) {
                return dHTMode;
            }
            return null;
        }

        static {
            $VALUES = new DHTMode[]{INACTIVE, ACTIVE, PASSIVE, PASSIVE_LEAF};
            DHTMode[] dHTModeArray = DHTMode.values();
            MODES = new DHTMode[dHTModeArray.length];
            for (DHTMode dHTMode : dHTModeArray) {
                int n = (dHTMode.mode & 0xFF) % MODES.length;
                assert (MODES[n] == null);
                DHTMode.MODES[n] = dHTMode;
            }
        }
    }
}

