/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.dht;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.ConnectionServices;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.SpamServices;
import com.limegroup.gnutella.connection.RoutedConnection;
import com.limegroup.gnutella.dht.DHTBootstrapper;
import com.limegroup.gnutella.dht.DHTBootstrapperFactory;
import com.limegroup.gnutella.dht.DHTController;
import com.limegroup.gnutella.dht.DHTControllerFacade;
import com.limegroup.gnutella.dht.db.AltLocModel;
import com.limegroup.gnutella.dht.db.AltLocValueFactory;
import com.limegroup.gnutella.dht.db.PushProxiesValueFactory;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.messages.vendor.CapabilitiesVMFactory;
import java.net.SocketAddress;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.limewire.mojito.db.DHTValueFactory;
import org.limewire.mojito.db.StorableModel;
import org.limewire.mojito.io.MessageDispatcherFactory;
import org.limewire.security.MACCalculatorRepositoryManager;
import org.limewire.security.SecurityToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class DHTControllerFacadeImpl
implements DHTControllerFacade {
    private final NetworkManager networkManager;
    private final Provider<ConnectionManager> connectionManager;
    private final Provider<IPFilter> ipFilter;
    private final SpamServices spamServices;
    private final ScheduledExecutorService backgroundExecutor;
    private final CapabilitiesVMFactory capabilitiesVMFactory;
    private final ConnectionServices connectionServices;
    private final Provider<AltLocValueFactory> altLocValueFactory;
    private final Provider<PushProxiesValueFactory> pushProxyValueFactory;
    private final Provider<AltLocModel> altLocModel;
    private final Provider<MessageDispatcherFactory> messageDispatcherFactory;
    private final DHTBootstrapperFactory dhtBootstrapperFactory;
    private final Provider<SecurityToken.TokenProvider> securityTokenProvider;
    private final Provider<MACCalculatorRepositoryManager> MACCalculatorRepositoryManager;

    @Inject
    public DHTControllerFacadeImpl(NetworkManager networkManager, Provider<ConnectionManager> provider, Provider<IPFilter> provider2, SpamServices spamServices, @Named(value="backgroundExecutor") ScheduledExecutorService scheduledExecutorService, CapabilitiesVMFactory capabilitiesVMFactory, ConnectionServices connectionServices, Provider<AltLocValueFactory> provider3, Provider<PushProxiesValueFactory> provider4, Provider<AltLocModel> provider5, Provider<MessageDispatcherFactory> provider6, DHTBootstrapperFactory dHTBootstrapperFactory, Provider<SecurityToken.TokenProvider> provider7, Provider<MACCalculatorRepositoryManager> provider8) {
        this.networkManager = networkManager;
        this.connectionManager = provider;
        this.ipFilter = provider2;
        this.spamServices = spamServices;
        this.backgroundExecutor = scheduledExecutorService;
        this.capabilitiesVMFactory = capabilitiesVMFactory;
        this.connectionServices = connectionServices;
        this.altLocValueFactory = provider3;
        this.pushProxyValueFactory = provider4;
        this.altLocModel = provider5;
        this.messageDispatcherFactory = provider6;
        this.dhtBootstrapperFactory = dHTBootstrapperFactory;
        this.securityTokenProvider = provider7;
        this.MACCalculatorRepositoryManager = provider8;
    }

    @Override
    public boolean allow(SocketAddress socketAddress) {
        return ((IPFilter)this.ipFilter.get()).allow(socketAddress);
    }

    @Override
    public byte[] getAddress() {
        return this.networkManager.getAddress();
    }

    @Override
    public StorableModel getAltLocModel() {
        return (StorableModel)this.altLocModel.get();
    }

    @Override
    public DHTValueFactory getAltLocValueFactory() {
        return (DHTValueFactory)this.altLocValueFactory.get();
    }

    @Override
    public List<RoutedConnection> getInitializedClientConnections() {
        return ((ConnectionManager)this.connectionManager.get()).getInitializedClientConnections();
    }

    @Override
    public MessageDispatcherFactory getMessageDispatcherFactory() {
        return (MessageDispatcherFactory)this.messageDispatcherFactory.get();
    }

    @Override
    public int getPort() {
        return this.networkManager.getPort();
    }

    @Override
    public DHTValueFactory getPushProxyValueFactory() {
        return (DHTValueFactory)this.pushProxyValueFactory.get();
    }

    @Override
    public boolean isActiveSupernode() {
        return this.connectionServices.isActiveSuperNode();
    }

    @Override
    public boolean isConnected() {
        return this.connectionServices.isConnected();
    }

    @Override
    public void reloadIPFilter() {
        this.spamServices.reloadIPFilter();
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable runnable, long l, long l2, TimeUnit timeUnit) {
        return this.backgroundExecutor.scheduleWithFixedDelay(runnable, l, l2, timeUnit);
    }

    @Override
    public void sendUpdatedCapabilities() {
        ((ConnectionManager)this.connectionManager.get()).sendUpdatedCapabilities();
    }

    @Override
    public void updateCapabilities() {
        this.capabilitiesVMFactory.updateCapabilities();
    }

    @Override
    public DHTBootstrapper getDHTBootstrapper(DHTController dHTController) {
        return this.dhtBootstrapperFactory.createBootstrapper(dHTController);
    }

    @Override
    public SecurityToken.TokenProvider getSecurityTokenProvider() {
        return (SecurityToken.TokenProvider)this.securityTokenProvider.get();
    }

    @Override
    public MACCalculatorRepositoryManager getMACCalculatorRespositoryManager() {
        return (MACCalculatorRepositoryManager)this.MACCalculatorRepositoryManager.get();
    }
}

