/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.dht;

import com.limegroup.gnutella.connection.ConnectionLifecycleEvent;
import com.limegroup.gnutella.connection.RoutedConnection;
import com.limegroup.gnutella.dht.AbstractDHTController;
import com.limegroup.gnutella.dht.DHTControllerFacade;
import com.limegroup.gnutella.dht.DHTEvent;
import com.limegroup.gnutella.dht.DHTEventListener;
import com.limegroup.gnutella.dht.DHTManager;
import com.limegroup.gnutella.settings.DHTSettings;
import com.limegroup.gnutella.util.EventDispatcher;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.List;
import org.limewire.io.IOUtils;
import org.limewire.io.IpPort;
import org.limewire.io.SecureInputStream;
import org.limewire.io.SecureOutputStream;
import org.limewire.mojito.MojitoDHT;
import org.limewire.mojito.MojitoFactory;
import org.limewire.mojito.db.Database;
import org.limewire.mojito.routing.RouteTable;
import org.limewire.mojito.routing.Vendor;
import org.limewire.mojito.routing.Version;
import org.limewire.util.CommonUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActiveDHTNodeController
extends AbstractDHTController {
    private static final File FILE = new File(CommonUtils.getUserSettingsDir(), "active.mojito");

    ActiveDHTNodeController(Vendor vendor, Version version, EventDispatcher<DHTEvent, DHTEventListener> eventDispatcher, DHTControllerFacade dHTControllerFacade) {
        super(vendor, version, eventDispatcher, DHTManager.DHTMode.ACTIVE, dHTControllerFacade);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected MojitoDHT createMojitoDHT(Vendor vendor, Version version) {
        MojitoDHT mojitoDHT = MojitoFactory.createDHT("ActiveMojitoDHT", vendor, version);
        if (DHTSettings.PERSIST_ACTIVE_DHT_ROUTETABLE.getValue() && FILE.exists() && FILE.isFile()) {
            ObjectInputStream objectInputStream;
            block10: {
                objectInputStream = null;
                try {
                    objectInputStream = new ObjectInputStream(new BufferedInputStream(new SecureInputStream(new FileInputStream(FILE))));
                    int n = objectInputStream.readInt();
                    if (n < this.getRouteTableVersion()) break block10;
                    RouteTable routeTable = (RouteTable)objectInputStream.readObject();
                    Database database = null;
                    try {
                        if (DHTSettings.PERSIST_DHT_DATABASE.getValue()) {
                            database = (Database)objectInputStream.readObject();
                        }
                    }
                    catch (Throwable throwable) {
                        this.LOG.error((Object)"Throwable", throwable);
                    }
                    if (routeTable == null) break block10;
                    long l = DHTSettings.MAX_ELAPSED_TIME_SINCE_LAST_CONTACT.getValue();
                    if (l < Long.MAX_VALUE) {
                        routeTable.purge(l);
                    }
                    mojitoDHT.setRouteTable(routeTable);
                    if (database == null) break block10;
                    mojitoDHT.setDatabase(database);
                }
                catch (Throwable throwable) {
                    try {
                        this.LOG.error((Object)"Throwable", throwable);
                    }
                    catch (Throwable throwable2) {
                        throw throwable2;
                    }
                    finally {
                        IOUtils.close(objectInputStream);
                    }
                }
            }
            IOUtils.close(objectInputStream);
        }
        return mojitoDHT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void stop() {
        if (!this.isRunning()) {
            return;
        }
        super.stop();
        this.sendUpdatedCapabilities();
        if (DHTSettings.PERSIST_ACTIVE_DHT_ROUTETABLE.getValue()) {
            ObjectOutputStream objectOutputStream = null;
            try {
                objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new SecureOutputStream(new FileOutputStream(FILE))));
                objectOutputStream.writeInt(this.getRouteTableVersion());
                MojitoDHT mojitoDHT = this.dht;
                synchronized (mojitoDHT) {
                    objectOutputStream.writeObject(this.dht.getRouteTable());
                    Database database = null;
                    if (DHTSettings.PERSIST_DHT_DATABASE.getValue()) {
                        database = this.dht.getDatabase();
                    }
                    objectOutputStream.writeObject(database);
                }
                objectOutputStream.flush();
            }
            catch (IOException iOException) {
                IOUtils.close(objectOutputStream);
                catch (Throwable throwable) {
                    IOUtils.close(objectOutputStream);
                    throw throwable;
                }
            }
            IOUtils.close(objectOutputStream);
        }
    }

    @Override
    public void handleConnectionLifecycleEvent(ConnectionLifecycleEvent connectionLifecycleEvent) {
        RoutedConnection routedConnection = connectionLifecycleEvent.getConnection();
        if (routedConnection == null) {
            return;
        }
        String string = routedConnection.getAddress();
        int n = routedConnection.getPort();
        if (connectionLifecycleEvent.isConnectionCapabilitiesEvent()) {
            if (routedConnection.getConnectionCapabilities().remostHostIsPassiveDHTNode() > -1) {
                if (this.LOG.isDebugEnabled()) {
                    this.LOG.debug((Object)("Connection is passive dht node: " + routedConnection));
                }
                this.addPassiveDHTNode(new InetSocketAddress(string, n));
            } else if (routedConnection.getConnectionCapabilities().remostHostIsActiveDHTNode() > -1) {
                if (DHTSettings.EXCLUDE_ULTRAPEERS.getValue()) {
                    return;
                }
                this.addActiveDHTNode(new InetSocketAddress(string, n));
            }
        }
    }

    @Override
    public List<IpPort> getActiveDHTNodes(int n) {
        if (!this.isRunning() || !this.dht.isBootstrapped()) {
            return Collections.emptyList();
        }
        return this.getMRSNodes(n, false);
    }
}

