/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.dht;

import com.limegroup.gnutella.connection.ConnectionLifecycleEvent;
import com.limegroup.gnutella.connection.RoutedConnection;
import com.limegroup.gnutella.dht.DHTBootstrapper;
import com.limegroup.gnutella.dht.DHTController;
import com.limegroup.gnutella.dht.DHTControllerFacade;
import com.limegroup.gnutella.dht.DHTEvent;
import com.limegroup.gnutella.dht.DHTEventListener;
import com.limegroup.gnutella.dht.DHTManager;
import com.limegroup.gnutella.dht.db.AbstractAltLocValue;
import com.limegroup.gnutella.dht.db.AbstractPushProxiesValue;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.vendor.DHTContactsMessage;
import com.limegroup.gnutella.settings.DHTSettings;
import com.limegroup.gnutella.util.EventDispatcher;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.PublicKey;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.Buffer;
import org.limewire.collection.FixedSizeLIFOSet;
import org.limewire.concurrent.ManagedThread;
import org.limewire.io.IpPort;
import org.limewire.mojito.KUID;
import org.limewire.mojito.MojitoDHT;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.routing.RouteTable;
import org.limewire.mojito.routing.Vendor;
import org.limewire.mojito.routing.Version;
import org.limewire.mojito.statistics.DHTStatsManager;
import org.limewire.mojito.util.ContactUtils;
import org.limewire.mojito.util.CryptoUtils;
import org.limewire.mojito.util.HostFilter;
import org.limewire.service.ErrorService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDHTController
implements DHTController {
    private static final String PUBLIC_KEY = "GCBADOBQQIASYBQHFKDERTRYAQATBAQBD4BIDAIA7V7VHAI5OUJCSUW7JKOC53HE473BDN2SHTXUIAGDDY7YBNSREZUUKXKAEJI7WWJ5RVMPVP6F6W5DB5WLTNKWZV4BHOAB2NDP6JTGBN3LTFIKLJE7T7UAI6YQELBE7O5J277LPRQ37A5VPZ6GVCTBKDYE7OB7NU6FD3BQENKUCNNBNEJS6Z27HLRLMHLSV37SEIBRTHORJAA4OAQVACLWAUEPCURQXTFSSK4YFIXLQQF7AWA46UBIDAIA67Q2BBOWTM655S54VNODNOCXXF4ZJL537I5OVAXZK5GAWPIHQJTVCWKXR25NIWKP4ZYQOEEBQC2ESFTREPUEYKAWCO346CJSRTEKNYJ4CZ5IWVD4RUUOBI5ODYV3HJTVSFXKG7YL7IQTKYXR7NRHUAJEHPGKJ4N6VBIZBCNIQPP6CWXFT4DJFC3GL2AHWVJFMQAUYO76Z5ESUA4BQUAAFAMBADVUPOYXTTF3IOLCXBEDV7ZPCCW2MDZIM2T2JHUA4HLLGRQCING7PUOJOHCC6CNALSXXYXH3HZHKA5TGV4LC2WGYK5UEYY6BYQBKDQ6RV5JE2XPBJPRT5E5SWDGD2PJPOE34ZSSKBYLQCWQEMN46HZGH75DAIDATD3S3FLETRCHRNWWK6JT7TC4DELTHMAMTZPLTCPYDLPX2T5A";
    protected final Log LOG = LogFactory.getLog(this.getClass());
    protected final MojitoDHT dht;
    protected final DHTBootstrapper bootstrapper;
    private final RandomNodeAdder dhtNodeAdder = new RandomNodeAdder();
    private final NodeForwarder nodeForwarder = new NodeForwarder();
    private final EventDispatcher<DHTEvent, DHTEventListener> dispatcher;
    private final DHTManager.DHTMode mode;
    private final int routeTableVersion;
    private final DHTControllerFacade dhtControllerFacade;

    public AbstractDHTController(Vendor vendor, Version version, EventDispatcher<DHTEvent, DHTEventListener> eventDispatcher, final DHTManager.DHTMode dHTMode, DHTControllerFacade dHTControllerFacade) {
        this.dhtControllerFacade = dHTControllerFacade;
        switch (dHTMode) {
            case ACTIVE: {
                this.routeTableVersion = DHTSettings.ACTIVE_DHT_ROUTETABLE_VERSION.getValue();
                break;
            }
            case PASSIVE: {
                this.routeTableVersion = DHTSettings.PASSIVE_DHT_ROUTETABLE_VERSION.getValue();
                break;
            }
            default: {
                this.routeTableVersion = -1;
            }
        }
        this.dispatcher = eventDispatcher;
        this.mode = dHTMode;
        this.dht = this.createMojitoDHT(vendor, version);
        assert (this.dht != null);
        this.dht.setMessageDispatcher(dHTControllerFacade.getMessageDispatcherFactory());
        this.dht.setMACCalculatorRepositoryManager(dHTControllerFacade.getMACCalculatorRespositoryManager());
        this.dht.setSecurityTokenProvider(dHTControllerFacade.getSecurityTokenProvider());
        this.dht.getDHTExecutorService().setThreadFactory(new ThreadFactory(){

            public Thread newThread(Runnable runnable) {
                return new ManagedThread(runnable);
            }
        });
        this.dht.setHostFilter(new FilterDelegate());
        this.dht.getDHTValueFactoryManager().addValueFactory(AbstractAltLocValue.ALT_LOC, dHTControllerFacade.getAltLocValueFactory());
        this.dht.getDHTValueFactoryManager().addValueFactory(AbstractPushProxiesValue.PUSH_PROXIES, dHTControllerFacade.getPushProxyValueFactory());
        try {
            PublicKey publicKey = CryptoUtils.loadPublicKey(PUBLIC_KEY);
            KeyPair keyPair = new KeyPair(publicKey, null);
            this.dht.setKeyPair(keyPair);
        }
        catch (InvalidKeyException invalidKeyException) {
            this.LOG.error((Object)"InvalidKeyException", (Throwable)invalidKeyException);
        }
        catch (SignatureException signatureException) {
            this.LOG.error((Object)"SignatureException", (Throwable)signatureException);
        }
        catch (IOException iOException) {
            this.LOG.error((Object)"IOException", (Throwable)iOException);
        }
        this.dht.getStorableModelManager().addStorableModel(AbstractAltLocValue.ALT_LOC, dHTControllerFacade.getAltLocModel());
        this.bootstrapper = dHTControllerFacade.getDHTBootstrapper(this);
        if (dHTControllerFacade.isActiveSupernode()) {
            this.dht.getRouteTable().addRouteTableListener(new RouteTable.RouteTableListener(){

                public void handleRouteTableEvent(RouteTable.RouteTableEvent routeTableEvent) {
                    switch (routeTableEvent.getEventType()) {
                        case ADD_ACTIVE_CONTACT: 
                        case ADD_CACHED_CONTACT: 
                        case UPDATE_CONTACT: {
                            Contact contact = routeTableEvent.getContact();
                            if (dHTMode != DHTManager.DHTMode.ACTIVE && AbstractDHTController.this.dht.getLocalNodeID().equals(contact.getNodeID())) break;
                            AbstractDHTController.this.nodeForwarder.addContact(contact);
                        }
                    }
                }
            });
        }
        DHTSettings.DHT_NODE_ID.setValue(this.dht.getLocalNodeID().toHexString());
        DHTStatsManager.clear();
    }

    protected final int getRouteTableVersion() {
        return this.routeTableVersion;
    }

    protected abstract MojitoDHT createMojitoDHT(Vendor var1, Version var2);

    @Override
    public DHTManager.DHTMode getDHTMode() {
        return this.mode;
    }

    @Override
    public List<IpPort> getActiveDHTNodes(int n) {
        return Collections.emptyList();
    }

    @Override
    public void handleConnectionLifecycleEvent(ConnectionLifecycleEvent connectionLifecycleEvent) {
    }

    @Override
    public void start() {
        if (this.isRunning() || !DHTSettings.FORCE_DHT_CONNECT.getValue() && !this.dhtControllerFacade.isConnected()) {
            return;
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)"Initializing the DHT");
        }
        try {
            InetAddress inetAddress = InetAddress.getByAddress(this.dhtControllerFacade.getAddress());
            int n = this.dhtControllerFacade.getPort();
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug((Object)("binding dht to: " + new InetSocketAddress(inetAddress, n)));
            }
            this.dht.bind(new InetSocketAddress(inetAddress, n));
            this.dht.start();
            if (this.dhtControllerFacade.isActiveSupernode()) {
                this.nodeForwarder.start();
            }
            if (this.getDHTMode() != DHTManager.DHTMode.PASSIVE_LEAF) {
                this.bootstrapper.bootstrap();
            }
            this.dispatcher.dispatchEvent(new DHTEvent(this, DHTEvent.Type.STARTING));
        }
        catch (IOException iOException) {
            this.LOG.error((Object)"IOException", (Throwable)iOException);
            ErrorService.error(iOException);
        }
    }

    @Override
    public void stop() {
        this.LOG.debug((Object)"Shutting down DHT Controller");
        this.bootstrapper.stop();
        this.dhtNodeAdder.stop();
        this.nodeForwarder.stop();
        this.dht.close();
        this.dispatcher.dispatchEvent(new DHTEvent(this, DHTEvent.Type.STOPPED));
    }

    protected void addActiveDHTNode(SocketAddress socketAddress, boolean bl) {
        if (!this.dht.isBootstrapped()) {
            this.bootstrapper.addBootstrapHost(socketAddress);
        } else if (bl) {
            this.dhtNodeAdder.addDHTNode(socketAddress);
            this.dhtNodeAdder.start();
        }
    }

    @Override
    public void addActiveDHTNode(SocketAddress socketAddress) {
        this.addActiveDHTNode(socketAddress, true);
    }

    @Override
    public void addPassiveDHTNode(SocketAddress socketAddress) {
        if (!this.dht.isBootstrapped()) {
            this.bootstrapper.addPassiveNode(socketAddress);
        }
    }

    @Override
    public void addContact(Contact contact) {
        if (this.getDHTMode() == DHTManager.DHTMode.PASSIVE_LEAF) {
            this.getMojitoDHT().getRouteTable().add(contact);
        }
    }

    protected List<IpPort> getMRSNodes(int n, boolean bl) {
        Collection<Contact> collection = ContactUtils.sort(this.dht.getRouteTable().getActiveContacts(), n + 1);
        KUID kUID = this.dht.getLocalNodeID();
        ArrayList<IpPort> arrayList = new ArrayList<IpPort>();
        for (Contact contact : collection) {
            if (bl && contact.getNodeID().equals(kUID)) continue;
            arrayList.add(new IpPortRemoteContact(contact));
        }
        return arrayList;
    }

    @Override
    public boolean isRunning() {
        return this.dht.isRunning();
    }

    @Override
    public boolean isBootstrapped() {
        return this.dht.isBootstrapped();
    }

    @Override
    public boolean isWaitingForNodes() {
        return this.bootstrapper.isWaitingForNodes();
    }

    @Override
    public MojitoDHT getMojitoDHT() {
        return this.dht;
    }

    @Override
    public void sendUpdatedCapabilities() {
        this.LOG.debug((Object)"Sending updated capabilities to our connections");
        this.dhtControllerFacade.updateCapabilities();
        this.dhtControllerFacade.sendUpdatedCapabilities();
        if (this.isRunning()) {
            this.dispatcher.dispatchEvent(new DHTEvent(this, DHTEvent.Type.CONNECTED));
        }
    }

    private class NodeForwarder
    implements Runnable {
        private final Buffer<Contact> contactsToForward = new Buffer(10);
        private volatile Future<?> forwarderFuture;

        private NodeForwarder() {
        }

        void start() {
            this.forwarderFuture = AbstractDHTController.this.dhtControllerFacade.scheduleWithFixedDelay(this, 60L, 60L, TimeUnit.SECONDS);
        }

        synchronized void addContact(Contact contact) {
            this.contactsToForward.add(contact);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ArrayList<Contact> arrayList;
            if (!DHTSettings.ENABLE_PASSIVE_LEAF_DHT_MODE.getValue() || !AbstractDHTController.this.isRunning()) {
                return;
            }
            Object object2 = this;
            synchronized (object2) {
                if (this.contactsToForward.isEmpty()) {
                    return;
                }
                arrayList = new ArrayList<Contact>(10);
                for (Contact object3 : this.contactsToForward) {
                    arrayList.add(object3);
                }
            }
            object2 = new DHTContactsMessage(arrayList);
            List<RoutedConnection> list = AbstractDHTController.this.dhtControllerFacade.getInitializedClientConnections();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                RoutedConnection routedConnection = (RoutedConnection)iterator.next();
                if (!routedConnection.isPushProxyFor() || routedConnection.getConnectionCapabilities().remoteHostIsPassiveLeafNode() <= -1) continue;
                routedConnection.send((Message)object2);
            }
        }

        void stop() {
            Future<?> future = this.forwarderFuture;
            if (future != null) {
                future.cancel(false);
            }
        }
    }

    private class FilterDelegate
    implements HostFilter {
        private FilterDelegate() {
        }

        public boolean allow(SocketAddress socketAddress) {
            return AbstractDHTController.this.dhtControllerFacade.allow(socketAddress);
        }
    }

    class RandomNodeAdder
    implements Runnable {
        private static final int MAX_SIZE = 30;
        private final Set<SocketAddress> dhtNodes = new FixedSizeLIFOSet<SocketAddress>(30, FixedSizeLIFOSet.EjectionPolicy.FIFO);
        private ScheduledFuture<?> timerTask;
        private boolean isRunning;

        public synchronized void start() {
            if (this.isRunning) {
                return;
            }
            long l = DHTSettings.DHT_NODE_ADDER_DELAY.getValue();
            this.timerTask = AbstractDHTController.this.dhtControllerFacade.scheduleWithFixedDelay(this, l, l, TimeUnit.MILLISECONDS);
            this.isRunning = true;
        }

        synchronized void addDHTNode(SocketAddress socketAddress) {
            this.dhtNodes.add(socketAddress);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ArrayList<SocketAddress> arrayList = null;
            Object object = this;
            synchronized (object) {
                if (!this.isRunning()) {
                    return;
                }
                arrayList = new ArrayList<SocketAddress>(this.dhtNodes);
                this.dhtNodes.clear();
            }
            object = AbstractDHTController.this.dht;
            synchronized (object) {
                for (SocketAddress socketAddress : arrayList) {
                    if (AbstractDHTController.this.LOG.isDebugEnabled()) {
                        AbstractDHTController.this.LOG.debug((Object)("RandomNodeAdder pinging: " + socketAddress));
                    }
                    AbstractDHTController.this.dht.ping(socketAddress);
                }
            }
        }

        synchronized boolean isRunning() {
            return this.isRunning;
        }

        synchronized void stop() {
            if (this.timerTask != null) {
                this.timerTask.cancel(true);
            }
            this.dhtNodes.clear();
            this.isRunning = false;
        }
    }

    private static class IpPortRemoteContact
    implements IpPort {
        private InetSocketAddress addr;

        public IpPortRemoteContact(Contact contact) {
            if (!(contact.getContactAddress() instanceof InetSocketAddress)) {
                throw new IllegalArgumentException("Contact not instance of InetSocketAddress");
            }
            this.addr = (InetSocketAddress)contact.getContactAddress();
        }

        public String getAddress() {
            return this.getInetAddress().getHostAddress();
        }

        public InetAddress getInetAddress() {
            return this.addr.getAddress();
        }

        public int getPort() {
            return this.addr.getPort();
        }

        public SocketAddress getSocketAddress() {
            return this.addr;
        }

        public InetSocketAddress getInetSocketAddress() {
            return this.addr;
        }
    }
}

