/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.connection;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.limegroup.gnutella.ConnectionServices;
import com.limegroup.gnutella.HostCatcher;
import com.limegroup.gnutella.MessageListener;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.UDPPinger;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.connection.UDPConnectionChecker;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.messages.PingRequestFactory;
import java.util.Collection;
import org.limewire.collection.Cancellable;
import org.limewire.io.IpPort;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UDPConnectionCheckerImpl
implements UDPConnectionChecker {
    private final ConnectionServices connectionServices;
    private final Provider<UDPService> udpService;
    private final Provider<HostCatcher> hostCatcher;
    private final PingRequestFactory pingRequestFactory;

    @Inject
    public UDPConnectionCheckerImpl(ConnectionServices connectionServices, Provider<UDPService> provider, Provider<HostCatcher> provider2, PingRequestFactory pingRequestFactory) {
        this.connectionServices = connectionServices;
        this.udpService = provider;
        this.hostCatcher = provider2;
        this.pingRequestFactory = pingRequestFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean udpIsDead() {
        PingRequest pingRequest = this.pingRequestFactory.createUDPPing();
        Collection<IpPort> collection = this.connectionServices.getPreferencedHosts(false, "en", 50);
        UDPPinger uDPPinger = ((HostCatcher)this.hostCatcher.get()).getPinger();
        UDPChecker uDPChecker = new UDPChecker();
        uDPPinger.rank(collection, uDPChecker, uDPChecker, pingRequest);
        long l = System.currentTimeMillis();
        UDPChecker uDPChecker2 = uDPChecker;
        synchronized (uDPChecker2) {
            try {
                for (int i = 0; i < 5; ++i) {
                    uDPChecker.wait(1000L);
                    if (((UDPService)this.udpService.get()).getLastReceivedTime() <= l) continue;
                    uDPChecker.received = true;
                    return false;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return !uDPChecker.received;
    }

    private class UDPChecker
    implements MessageListener,
    Cancellable {
        volatile boolean received;

        private UDPChecker() {
        }

        public boolean isCancelled() {
            return this.received;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processMessage(Message message, ReplyHandler replyHandler) {
            this.received = true;
            UDPChecker uDPChecker = this;
            synchronized (uDPChecker) {
                this.notify();
            }
        }

        public void registered(byte[] byArray) {
        }

        public void unregistered(byte[] byArray) {
        }
    }
}

