/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.connection;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.Acceptor;
import com.limegroup.gnutella.ApplicationServices;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.ConnectionServices;
import com.limegroup.gnutella.GuidMapManager;
import com.limegroup.gnutella.MessageDispatcher;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.NetworkUpdateSanityChecker;
import com.limegroup.gnutella.connection.GnutellaConnection;
import com.limegroup.gnutella.connection.MessageReaderFactory;
import com.limegroup.gnutella.connection.RoutedConnection;
import com.limegroup.gnutella.connection.RoutedConnectionFactory;
import com.limegroup.gnutella.filters.SpamFilterFactory;
import com.limegroup.gnutella.handshaking.HandshakeResponderFactory;
import com.limegroup.gnutella.handshaking.HeadersFactory;
import com.limegroup.gnutella.messages.MessageFactory;
import com.limegroup.gnutella.messages.QueryReplyFactory;
import com.limegroup.gnutella.messages.QueryRequestFactory;
import com.limegroup.gnutella.messages.vendor.CapabilitiesVMFactory;
import com.limegroup.gnutella.messages.vendor.MessagesSupportedVendorMessage;
import com.limegroup.gnutella.search.SearchResultHandler;
import com.limegroup.gnutella.simpp.SimppManager;
import com.limegroup.gnutella.statistics.OutOfBandStatistics;
import java.net.Socket;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.net.SocketsManager;
import org.limewire.security.SecureMessageVerifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class RoutedConnectionFactoryImpl
implements RoutedConnectionFactory {
    private final Provider<ConnectionManager> connectionManager;
    private final NetworkManager networkManager;
    private final QueryRequestFactory queryRequestFactory;
    private final HeadersFactory headersFactory;
    private final HandshakeResponderFactory handshakeResponderFactory;
    private final QueryReplyFactory queryReplyFactory;
    private final Provider<MessageDispatcher> messageDispatcher;
    private final Provider<NetworkUpdateSanityChecker> networkUpdateSanityChecker;
    private final Provider<SearchResultHandler> searchResultHandler;
    private final CapabilitiesVMFactory capabilitiesVMFactory;
    private final Provider<SocketsManager> socketsManager;
    private final Provider<Acceptor> acceptor;
    private final MessagesSupportedVendorMessage supportedVendorMessage;
    private final Provider<SimppManager> simppManager;
    private final Provider<ConnectionServices> connectionServices;
    private final GuidMapManager guidMapManager;
    private final SpamFilterFactory spamFilterFactory;
    private final MessageFactory messageFactory;
    private final MessageReaderFactory messageReaderFactory;
    private final ApplicationServices applicationServices;
    private final Provider<SecureMessageVerifier> secureMessageVerifier;
    private final OutOfBandStatistics outOfBandStatistics;
    private final NetworkInstanceUtils networkInstanceUtils;

    @Inject
    public RoutedConnectionFactoryImpl(Provider<ConnectionManager> provider, NetworkManager networkManager, QueryRequestFactory queryRequestFactory, HeadersFactory headersFactory, HandshakeResponderFactory handshakeResponderFactory, QueryReplyFactory queryReplyFactory, Provider<MessageDispatcher> provider2, Provider<NetworkUpdateSanityChecker> provider3, Provider<SearchResultHandler> provider4, CapabilitiesVMFactory capabilitiesVMFactory, Provider<SocketsManager> provider5, Provider<Acceptor> provider6, MessagesSupportedVendorMessage messagesSupportedVendorMessage, Provider<SimppManager> provider7, Provider<ConnectionServices> provider8, GuidMapManager guidMapManager, SpamFilterFactory spamFilterFactory, MessageFactory messageFactory, MessageReaderFactory messageReaderFactory, ApplicationServices applicationServices, Provider<SecureMessageVerifier> provider9, OutOfBandStatistics outOfBandStatistics, NetworkInstanceUtils networkInstanceUtils) {
        this.connectionManager = provider;
        this.networkManager = networkManager;
        this.queryRequestFactory = queryRequestFactory;
        this.headersFactory = headersFactory;
        this.handshakeResponderFactory = handshakeResponderFactory;
        this.queryReplyFactory = queryReplyFactory;
        this.messageDispatcher = provider2;
        this.networkUpdateSanityChecker = provider3;
        this.applicationServices = applicationServices;
        this.searchResultHandler = provider4;
        this.capabilitiesVMFactory = capabilitiesVMFactory;
        this.socketsManager = provider5;
        this.acceptor = provider6;
        this.supportedVendorMessage = messagesSupportedVendorMessage;
        this.simppManager = provider7;
        this.connectionServices = provider8;
        this.guidMapManager = guidMapManager;
        this.spamFilterFactory = spamFilterFactory;
        this.messageFactory = messageFactory;
        this.messageReaderFactory = messageReaderFactory;
        this.secureMessageVerifier = provider9;
        this.outOfBandStatistics = outOfBandStatistics;
        this.networkInstanceUtils = networkInstanceUtils;
    }

    @Override
    public RoutedConnection createRoutedConnection(String string, int n) {
        return this.createRoutedConnection(string, n, SocketsManager.ConnectType.PLAIN);
    }

    @Override
    public RoutedConnection createRoutedConnection(String string, int n, SocketsManager.ConnectType connectType) {
        return new GnutellaConnection(string, n, connectType, (ConnectionManager)this.connectionManager.get(), this.networkManager, this.queryRequestFactory, this.headersFactory, this.handshakeResponderFactory, this.queryReplyFactory, (MessageDispatcher)this.messageDispatcher.get(), (NetworkUpdateSanityChecker)this.networkUpdateSanityChecker.get(), (SearchResultHandler)this.searchResultHandler.get(), this.capabilitiesVMFactory, (SocketsManager)this.socketsManager.get(), (Acceptor)this.acceptor.get(), this.supportedVendorMessage, this.simppManager, this.connectionServices, this.guidMapManager, this.spamFilterFactory, this.messageReaderFactory, this.messageFactory, this.applicationServices, (SecureMessageVerifier)this.secureMessageVerifier.get(), this.outOfBandStatistics, this.networkInstanceUtils);
    }

    @Override
    public RoutedConnection createRoutedConnection(Socket socket) {
        return new GnutellaConnection(socket, (ConnectionManager)this.connectionManager.get(), this.networkManager, this.queryRequestFactory, this.headersFactory, this.handshakeResponderFactory, this.queryReplyFactory, (MessageDispatcher)this.messageDispatcher.get(), (NetworkUpdateSanityChecker)this.networkUpdateSanityChecker.get(), (SearchResultHandler)this.searchResultHandler.get(), this.capabilitiesVMFactory, (Acceptor)this.acceptor.get(), this.supportedVendorMessage, this.simppManager, this.connectionServices, this.guidMapManager, this.spamFilterFactory, this.messageReaderFactory, this.messageFactory, this.applicationServices, (SecureMessageVerifier)this.secureMessageVerifier.get(), this.outOfBandStatistics, this.networkInstanceUtils);
    }
}

