/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.connection;

import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.QueryRequest;
import java.util.List;
import java.util.Map;
import org.limewire.collection.Buffer;
import org.limewire.util.ByteUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionStats {
    private volatile int _numMessagesSent;
    private volatile int _numMessagesReceived;
    private volatile int _numReceivedMessagesDropped;
    private volatile int _numSentMessagesDropped;
    private volatile long repliesReceived;
    private volatile long repliesSent;
    private volatile long queriesReceived;
    private volatile long queriesSent;
    private volatile int _lastReceived;
    private volatile int _lastRecvDropped;
    private volatile int _lastSent;
    private volatile int _lastSentDropped;
    private final Buffer<Byte> responsesPerReply = new Buffer(200);
    private final Buffer<Byte> altsPerResponse = new Buffer(200);
    private final Buffer<Short> altsPerReply = new Buffer(200);

    public int getSent() {
        return this._numMessagesSent;
    }

    public int getReceived() {
        return this._numMessagesReceived;
    }

    public int getSentDropped() {
        return this._numSentMessagesDropped;
    }

    public int getReceivedDropped() {
        return this._numReceivedMessagesDropped;
    }

    public long getRepliesReceived() {
        return this.repliesReceived;
    }

    public void addSentDropped(int n) {
        this._numSentMessagesDropped += n;
    }

    public void addSent(Message message) {
        ++this._numMessagesSent;
        if (message instanceof QueryRequest) {
            ++this.queriesSent;
        } else if (message instanceof QueryReply) {
            ++this.repliesSent;
        }
    }

    public void addReceivedDropped() {
        ++this._numReceivedMessagesDropped;
    }

    public void addReceived() {
        ++this._numMessagesReceived;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replyReceived(QueryReply queryReply) {
        List<Response> list;
        byte by = (byte)queryReply.getUniqueResultCount();
        try {
            list = queryReply.getResultsAsList();
        }
        catch (BadPacketException badPacketException) {
            return;
        }
        ConnectionStats connectionStats = this;
        synchronized (connectionStats) {
            this.responsesPerReply.add(by);
            short s = 0;
            for (Response response : list) {
                byte by2 = (byte)response.getLocations().size();
                this.altsPerResponse.add(by2);
                s = (short)(s + by2);
            }
            this.altsPerReply.add(s);
            ++this.repliesReceived;
        }
    }

    public void queryReceived() {
        ++this.queriesReceived;
    }

    public synchronized float getPercentReceivedDropped() {
        int n = this._numMessagesReceived - this._lastReceived;
        int n2 = this._numReceivedMessagesDropped - this._lastRecvDropped;
        float f = n == 0 ? 0.0f : (float)n2 / (float)n * 100.0f;
        this._lastReceived = this._numMessagesReceived;
        this._lastRecvDropped = this._numReceivedMessagesDropped;
        return f;
    }

    public synchronized float getPercentSentDropped() {
        int n = this._numMessagesSent - this._lastSent;
        int n2 = this._numSentMessagesDropped - this._lastSentDropped;
        float f = n == 0 ? 0.0f : (float)n2 / (float)n * 100.0f;
        this._lastSent = this._numMessagesSent;
        this._lastSentDropped = this._numSentMessagesDropped;
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStats(Map<String, Object> map) {
        map.put("nqr", this.repliesReceived);
        map.put("nqs", this.repliesSent);
        map.put("npr", this.queriesReceived);
        map.put("nps", this.queriesSent);
        ConnectionStats connectionStats = this;
        synchronized (connectionStats) {
            int n;
            map.put("nqr", this.repliesReceived);
            byte[] byArray = new byte[this.responsesPerReply.size()];
            byte[] byArray2 = new byte[this.altsPerResponse.size()];
            byte[] byArray3 = new byte[this.altsPerReply.size() * 2];
            for (n = 0; n < this.responsesPerReply.size(); ++n) {
                byArray[n] = this.responsesPerReply.get(n);
            }
            for (n = 0; n < this.altsPerResponse.size(); ++n) {
                byArray2[n] = this.altsPerResponse.get(n);
            }
            for (n = 0; n < this.altsPerReply.size(); ++n) {
                ByteUtils.short2leb(this.altsPerReply.get(n), byArray3, n * 2);
            }
            map.put("respreply", byArray);
            map.put("altresp", byArray2);
            map.put("altreply", byArray3);
        }
    }
}

