/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.connection;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.ConnectionServices;
import com.limegroup.gnutella.DownloadServices;
import com.limegroup.gnutella.UploadServices;
import com.limegroup.gnutella.connection.ConnectionChecker;
import com.limegroup.gnutella.connection.ConnectionCheckerListener;
import com.limegroup.gnutella.connection.ConnectionCheckerManager;
import com.limegroup.gnutella.connection.UDPConnectionChecker;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.net.SocketsManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class ConnectionCheckerManagerImpl
implements ConnectionCheckerManager {
    private static final Log LOG = LogFactory.getLog(ConnectionCheckerManagerImpl.class);
    private static final String[] STANDARD_HOSTS = new String[]{"www.wanadoo.fr", "www.tiscali.com", "www.ntt.com", "www.tonline.com", "www.download.com", "www.ibm.com", "www.sun.com", "www.apple.com", "www.ebay.com", "www.sun.com", "www.monster.com", "www.uunet.com", "www.real.com", "www.microsoft.com", "www.sco.com", "www.google.com", "www.cnn.com", "www.amazon.com", "www.espn.com", "www.yahoo.com", "www.oracle.com", "www.dell.com", "www.ge.com", "www.sprint.com", "www.att.com", "www.mci.com", "www.cisco.com", "www.intel.com", "www.motorola.com", "www.hp.com", "www.gateway.com", "www.sony.com", "www.ford.com", "www.gm.com", "www.aol.com", "www.verizon.com", "www.passport.com", "www.go.com", "www.overture.com", "www.earthlink.net", "www.bellsouth.net", "www.excite.com", "www.paypal.com", "www.altavista.com", "www.weather.com", "www.mapquest.com", "www.geocities.com", "www.juno.com", "www.msnbc.com", "www.lycos.com", "www.comcast.com"};
    private final AtomicInteger numWorkarounds = new AtomicInteger();
    private volatile ConnectionChecker currentChecker;
    private ConnectionServices connectionServices;
    private Provider<ConnectionManager> connectionManager;
    private UploadServices uploadServices;
    private SocketsManager socketsManager;
    private final DownloadServices downloadServices;
    private final Provider<UDPConnectionChecker> udpConnectionChecker;
    private final ExecutorService executor;
    private volatile boolean connected;
    private volatile Future<Boolean> currentCheckerFuture;

    @Inject
    public ConnectionCheckerManagerImpl(ConnectionServices connectionServices, Provider<ConnectionManager> provider, UploadServices uploadServices, DownloadServices downloadServices, SocketsManager socketsManager, Provider<UDPConnectionChecker> provider2, @Named(value="unlimitedExecutor") ExecutorService executorService) {
        this.connectionServices = connectionServices;
        this.connectionManager = provider;
        this.uploadServices = uploadServices;
        this.downloadServices = downloadServices;
        this.socketsManager = socketsManager;
        this.udpConnectionChecker = provider2;
        this.executor = executorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<Boolean> checkForLiveConnection() {
        LOG.trace((Object)"checking for live connection");
        boolean bl = false;
        ConnectionCheckerManagerImpl connectionCheckerManagerImpl = this;
        synchronized (connectionCheckerManagerImpl) {
            if (this.currentChecker == null) {
                bl = true;
                this.currentChecker = new ConnectionChecker(this.numWorkarounds, this.getDefaultHosts(), this.connectionServices, this.uploadServices, this.downloadServices, this.socketsManager, (UDPConnectionChecker)this.udpConnectionChecker.get());
            }
        }
        if (bl) {
            LOG.debug((Object)"Starting a new connection-checker thread");
            this.currentCheckerFuture = this.executor.submit(new ConnectionCheckerRunner());
        }
        return this.currentCheckerFuture;
    }

    public String[] getDefaultHosts() {
        return STANDARD_HOSTS;
    }

    @Override
    public int getNumWorkarounds() {
        return this.numWorkarounds.get();
    }

    public boolean isConnected() {
        return this.connected;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConnectionCheckerRunner
    implements ConnectionCheckerListener,
    Callable<Boolean> {
        private ConnectionCheckerRunner() {
        }

        @Override
        public void connected() {
            ConnectionCheckerManagerImpl.this.connected = true;
        }

        @Override
        public void noInternetConnection() {
            ConnectionCheckerManagerImpl.this.connected = false;
            ((ConnectionManager)ConnectionCheckerManagerImpl.this.connectionManager.get()).noInternetConnection();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean call() {
            ConnectionChecker connectionChecker;
            ConnectionCheckerManagerImpl connectionCheckerManagerImpl = ConnectionCheckerManagerImpl.this;
            synchronized (connectionCheckerManagerImpl) {
                connectionChecker = ConnectionCheckerManagerImpl.this.currentChecker;
            }
            try {
                connectionChecker.run(this);
            }
            finally {
                connectionCheckerManagerImpl = ConnectionCheckerManagerImpl.this;
                synchronized (connectionCheckerManagerImpl) {
                    ConnectionCheckerManagerImpl.this.currentChecker = null;
                }
            }
            return ConnectionCheckerManagerImpl.this.connected;
        }
    }
}

