/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.connection;

import com.limegroup.gnutella.connection.ConnectionBandwidthStatistics;
import org.limewire.nio.ProtocolBandwidthTracker;

public class ConnectionBandwidthStatisticsImpl
implements ConnectionBandwidthStatistics {
    private volatile boolean useTls;
    private volatile ProtocolBandwidthTracker sslBandwidthTracker;
    private volatile boolean writeDeflated;
    private volatile boolean readDeflated;
    private volatile ProtocolBandwidthTracker compressionBandwidthTracker;
    private volatile ProtocolBandwidthTracker rawBandwidthTracker;

    public void setTlsOption(boolean bl, ProtocolBandwidthTracker protocolBandwidthTracker) {
        this.useTls = bl;
        this.sslBandwidthTracker = protocolBandwidthTracker;
    }

    public void setCompressionOption(boolean bl, boolean bl2, ProtocolBandwidthTracker protocolBandwidthTracker) {
        this.writeDeflated = bl;
        this.readDeflated = bl2;
        this.compressionBandwidthTracker = protocolBandwidthTracker;
    }

    public void setRawBandwidthTracker(ProtocolBandwidthTracker protocolBandwidthTracker) {
        this.rawBandwidthTracker = protocolBandwidthTracker;
    }

    public long getBytesSent() {
        if (this.useTls) {
            return this.sslBandwidthTracker.getWrittenBytesProduced();
        }
        if (this.writeDeflated) {
            return this.compressionBandwidthTracker.getWrittenBytesProduced();
        }
        return this.rawBandwidthTracker.getWrittenBytesProduced();
    }

    public long getUncompressedBytesSent() {
        return this.rawBandwidthTracker.getWrittenBytesProduced();
    }

    public long getBytesReceived() {
        if (this.useTls) {
            return this.sslBandwidthTracker.getReadBytesConsumed();
        }
        if (this.readDeflated) {
            return this.compressionBandwidthTracker.getReadBytesConsumed();
        }
        return this.rawBandwidthTracker.getReadBytesConsumed();
    }

    public long getUncompressedBytesReceived() {
        return this.rawBandwidthTracker.getReadBytesConsumed();
    }

    public float getSentSavedFromCompression() {
        return ConnectionBandwidthStatisticsImpl.getWriteSavings(this.writeDeflated, this.compressionBandwidthTracker);
    }

    public float getReadSavedFromCompression() {
        return ConnectionBandwidthStatisticsImpl.getReadSavings(this.readDeflated, this.compressionBandwidthTracker);
    }

    public float getSentLostFromSSL() {
        return ConnectionBandwidthStatisticsImpl.getWriteLosings(this.useTls, this.sslBandwidthTracker);
    }

    public float getReadLostFromSSL() {
        return ConnectionBandwidthStatisticsImpl.getReadLosings(this.useTls, this.sslBandwidthTracker);
    }

    private static float getWriteSavings(boolean bl, ProtocolBandwidthTracker protocolBandwidthTracker) {
        if (!bl) {
            return 0.0f;
        }
        long l = protocolBandwidthTracker.getWrittenBytesConsumed();
        if (l != 0L) {
            return 1.0f - (float)protocolBandwidthTracker.getWrittenBytesProduced() / (float)l;
        }
        return 0.0f;
    }

    private static float getReadSavings(boolean bl, ProtocolBandwidthTracker protocolBandwidthTracker) {
        if (!bl) {
            return 0.0f;
        }
        long l = protocolBandwidthTracker.getReadBytesProduced();
        if (l != 0L) {
            return 1.0f - (float)protocolBandwidthTracker.getReadBytesConsumed() / (float)l;
        }
        return 0.0f;
    }

    private static float getWriteLosings(boolean bl, ProtocolBandwidthTracker protocolBandwidthTracker) {
        if (!bl) {
            return 0.0f;
        }
        long l = protocolBandwidthTracker.getWrittenBytesProduced();
        if (l != 0L) {
            return 1.0f - (float)protocolBandwidthTracker.getWrittenBytesConsumed() / (float)l;
        }
        return 0.0f;
    }

    private static float getReadLosings(boolean bl, ProtocolBandwidthTracker protocolBandwidthTracker) {
        if (!bl) {
            return 0.0f;
        }
        long l = protocolBandwidthTracker.getReadBytesConsumed();
        if (l != 0L) {
            return 1.0f - (float)protocolBandwidthTracker.getReadBytesProduced() / (float)l;
        }
        return 0.0f;
    }
}

