/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.bootstrap;

import com.google.inject.Provider;
import com.limegroup.gnutella.ConnectionServices;
import com.limegroup.gnutella.ExtendedEndpoint;
import com.limegroup.gnutella.MessageListener;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.UDPPinger;
import com.limegroup.gnutella.UDPReplyHandler;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.messages.PingRequestFactory;
import com.limegroup.gnutella.util.StrictIpPortSet;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.Cancellable;
import org.limewire.collection.FixedSizeExpiringSet;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.io.NetworkUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UDPHostCache {
    private static final Log LOG = LogFactory.getLog(UDPHostCache.class);
    private static final int MAXIMUM_FAILURES = 5;
    public static final int PERMANENT_SIZE = 100;
    public static final int FETCH_AMOUNT = 5;
    private final List<ExtendedEndpoint> udpHosts = new ArrayList<ExtendedEndpoint>(100);
    private final Set<ExtendedEndpoint> udpHostsSet = new HashSet<ExtendedEndpoint>();
    private final UDPPinger pinger;
    private final Set<ExtendedEndpoint> attemptedHosts;
    private boolean dirty = false;
    private boolean writeDirty = false;
    private final Provider<MessageRouter> messageRouter;
    private final PingRequestFactory pingRequestFactory;
    private final ConnectionServices connectionServices;
    private final NetworkInstanceUtils networkInstanceUtils;
    private static final Comparator<ExtendedEndpoint> FAILURE_COMPARATOR = new FailureComparator();

    protected UDPHostCache(UDPPinger uDPPinger, Provider<MessageRouter> provider, PingRequestFactory pingRequestFactory, ConnectionServices connectionServices, NetworkInstanceUtils networkInstanceUtils) {
        this(600000L, uDPPinger, provider, pingRequestFactory, connectionServices, networkInstanceUtils);
    }

    protected UDPHostCache(long l, UDPPinger uDPPinger, Provider<MessageRouter> provider, PingRequestFactory pingRequestFactory, ConnectionServices connectionServices, NetworkInstanceUtils networkInstanceUtils) {
        this.connectionServices = connectionServices;
        this.attemptedHosts = new FixedSizeExpiringSet<ExtendedEndpoint>(100, l);
        this.pinger = uDPPinger;
        this.messageRouter = provider;
        this.pingRequestFactory = pingRequestFactory;
        this.networkInstanceUtils = networkInstanceUtils;
    }

    public synchronized void write(Writer writer) throws IOException {
        for (ExtendedEndpoint extendedEndpoint : this.udpHosts) {
            extendedEndpoint.write(writer);
        }
        this.writeDirty = false;
    }

    public synchronized boolean isWriteDirty() {
        return this.writeDirty;
    }

    public synchronized int getSize() {
        return this.udpHostsSet.size();
    }

    public synchronized void resetData() {
        LOG.debug((Object)"Clearing attempted udp host caches");
        this.decrementFailures();
        this.attemptedHosts.clear();
    }

    protected synchronized void decrementFailures() {
        for (ExtendedEndpoint extendedEndpoint : this.attemptedHosts) {
            extendedEndpoint.decrementUDPHostCacheFailure();
            if (extendedEndpoint.getUDPHostCacheFailures() == 5 && this.udpHosts.size() < 100) {
                this.add(extendedEndpoint);
            }
            this.dirty = true;
            this.writeDirty = true;
        }
    }

    public synchronized boolean fetchHosts() {
        if (this.dirty) {
            Collections.shuffle(this.udpHosts);
            Collections.sort(this.udpHosts, FAILURE_COMPARATOR);
            this.dirty = false;
        }
        ArrayList<ExtendedEndpoint> arrayList = new ArrayList<ExtendedEndpoint>(Math.min(5, this.udpHosts.size()));
        LinkedList<ExtendedEndpoint> linkedList = new LinkedList<ExtendedEndpoint>();
        for (ExtendedEndpoint extendedEndpoint : this.udpHosts) {
            if (arrayList.size() >= 5) break;
            if (this.attemptedHosts.contains(extendedEndpoint)) continue;
            if (!this.networkInstanceUtils.isValidExternalIpPort(extendedEndpoint) || !NetworkUtils.isValidIpPort(extendedEndpoint) || this.networkInstanceUtils.isPrivateAddress(extendedEndpoint.getAddress())) {
                linkedList.add(extendedEndpoint);
                continue;
            }
            arrayList.add(extendedEndpoint);
        }
        for (ExtendedEndpoint extendedEndpoint : linkedList) {
            this.remove(extendedEndpoint);
        }
        this.attemptedHosts.addAll(arrayList);
        return this.fetch(arrayList);
    }

    protected synchronized boolean fetch(Collection<? extends ExtendedEndpoint> collection) {
        if (collection.isEmpty()) {
            LOG.debug((Object)"No hosts to fetch");
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Fetching endpoints from " + collection + " host caches"));
        }
        this.pinger.rank(collection, new HostExpirer(collection), new Cancellable(){

            public boolean isCancelled() {
                return UDPHostCache.this.connectionServices.isConnected();
            }
        }, this.getPing());
        return true;
    }

    protected PingRequest getPing() {
        return this.pingRequestFactory.createUHCPing();
    }

    public synchronized boolean remove(ExtendedEndpoint extendedEndpoint) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Removing endpoint: " + extendedEndpoint));
        }
        boolean bl = this.udpHosts.remove(extendedEndpoint);
        boolean bl2 = this.udpHostsSet.remove(extendedEndpoint);
        assert (bl == bl2) : "Set " + bl + " but queue " + bl2;
        if (bl) {
            this.writeDirty = true;
        }
        return bl;
    }

    public synchronized boolean add(ExtendedEndpoint extendedEndpoint) {
        assert (extendedEndpoint.isUDPHostCache());
        if (this.udpHostsSet.contains(extendedEndpoint)) {
            return false;
        }
        if (this.udpHosts.size() >= 100) {
            ExtendedEndpoint extendedEndpoint2 = this.udpHosts.remove(this.udpHosts.size() - 1);
            this.udpHostsSet.remove(extendedEndpoint2);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Ejected: " + extendedEndpoint2));
            }
        }
        this.udpHosts.add(extendedEndpoint);
        this.udpHostsSet.add(extendedEndpoint);
        this.dirty = true;
        this.writeDirty = true;
        return true;
    }

    public void loadDefaults() {
        this.createAndAdd("cornflake.sirinet.net", 21000);
        this.createAndAdd("galvatron.dyndns.org", 59009);
        this.createAndAdd("gwc.dietpac.com", 8080);
        this.createAndAdd("gwc.glucolene.com", 8080);
        this.createAndAdd("kisama.ath.cx", 8080);
        this.createAndAdd("krill.shacknet.nu", 20095);
        this.createAndAdd("pokerface.ibiza.bishopston.net", 3558);
        this.createAndAdd("secondary.udp-host-cache.com", 9999);
        this.createAndAdd("uhc.udp-host-cache.com", 9999);
        this.createAndAdd("uhc2.limewire.com", 20181);
        this.createAndAdd("uhc3.limewire.com", 51180);
        this.createAndAdd("yang.cloud.bishopston.net", 33558);
        this.createAndAdd("yin.cloud.bishopston.net", 33558);
        this.createAndAdd("tertiary.udp-host-cache.com", 9999);
        this.createAndAdd("leet.gtkg.org", 1337);
        this.createAndAdd("sissy.gtkg.org", 51557);
        this.createAndAdd("ein.gtkg.net", 60666);
        this.createAndAdd("zwei.gtkg.net", 61666);
        this.createAndAdd("drei.gtkg.net", 62666);
        this.createAndAdd("ec2-72-44-40-255.z-2.compute-1.amazonaws.com", 9999);
        this.createAndAdd("ec2-72-44-45-131.z-2.compute-1.amazonaws.com", 60666);
        this.createAndAdd("ec2-72-44-47-123.z-2.compute-1.amazonaws.com", 9999);
        this.createAndAdd("ec2-67-202-41-17.compute-1.amazonaws.com", 1337);
        this.createAndAdd("ec2-67-202-37-110.compute-1.amazonaws.com", 62666);
    }

    private void createAndAdd(String string, int n) {
        try {
            ExtendedEndpoint extendedEndpoint = new ExtendedEndpoint(string, n).setUDPHostCache(true);
            this.add(extendedEndpoint);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FailureComparator
    implements Comparator<ExtendedEndpoint> {
        private FailureComparator() {
        }

        @Override
        public int compare(ExtendedEndpoint extendedEndpoint, ExtendedEndpoint extendedEndpoint2) {
            return extendedEndpoint.getUDPHostCacheFailures() - extendedEndpoint2.getUDPHostCacheFailures();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HostExpirer
    implements MessageListener {
        private final Set<ExtendedEndpoint> hosts = new StrictIpPortSet<ExtendedEndpoint>();
        private final Set<ExtendedEndpoint> allHosts;
        private byte[] guid;

        public HostExpirer(Collection<? extends ExtendedEndpoint> collection) {
            this.hosts.addAll(collection);
            this.allHosts = new HashSet<ExtendedEndpoint>(collection);
            this.removeDuplicates(collection, this.hosts);
        }

        private void removeDuplicates(Collection<? extends ExtendedEndpoint> collection, Collection<? extends ExtendedEndpoint> collection2) {
            HashSet<? extends ExtendedEndpoint> hashSet = new HashSet<ExtendedEndpoint>(collection);
            hashSet.removeAll(collection2);
            for (ExtendedEndpoint extendedEndpoint : hashSet) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Removing duplicate entry: " + extendedEndpoint));
                }
                UDPHostCache.this.remove(extendedEndpoint);
            }
        }

        @Override
        public void processMessage(Message message, ReplyHandler replyHandler) {
            if (replyHandler instanceof UDPReplyHandler) {
                if (this.hosts.remove(replyHandler) && LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Recieved: " + message));
                }
                if (this.hosts.isEmpty()) {
                    ((MessageRouter)UDPHostCache.this.messageRouter.get()).unregisterMessageListener(this.guid, this);
                }
            }
        }

        @Override
        public void registered(byte[] byArray) {
            this.guid = byArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unregistered(byte[] byArray) {
            UDPHostCache uDPHostCache = UDPHostCache.this;
            synchronized (uDPHostCache) {
                for (ExtendedEndpoint extendedEndpoint : this.hosts) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("No response from cache: " + extendedEndpoint));
                    }
                    extendedEndpoint.recordUDPHostCacheFailure();
                    UDPHostCache.this.dirty = true;
                    UDPHostCache.this.writeDirty = true;
                    if (extendedEndpoint.getUDPHostCacheFailures() <= 5) continue;
                    UDPHostCache.this.remove(extendedEndpoint);
                }
                this.allHosts.removeAll(this.hosts);
                for (ExtendedEndpoint extendedEndpoint : this.allHosts) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Valid response from cache: " + extendedEndpoint));
                    }
                    extendedEndpoint.recordUDPHostCacheSuccess();
                    UDPHostCache.this.dirty = true;
                    UDPHostCache.this.writeDirty = true;
                }
            }
        }
    }
}

