/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.bootstrap;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import com.limegroup.gnutella.ConnectionServices;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.http.HttpClientListener;
import com.limegroup.gnutella.http.HttpExecutor;
import com.limegroup.gnutella.util.EncodingUtils;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.DefaultedHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.limewire.collection.Cancellable;
import org.limewire.collection.FixedSizeExpiringSet;
import org.limewire.concurrent.ExecutorsHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TcpBootstrap {
    private static final Log LOG = LogFactory.getLog(TcpBootstrap.class);
    private final int WANTED_HOSTS = 15;
    private final ExecutorService bootstrapQueue = ExecutorsHelper.newProcessingQueue("TCP Bootstrap");
    private final List<URI> hosts = new ArrayList<URI>();
    private final Set<URI> hostsSet = new HashSet<URI>();
    private final Set<URI> attemptedHosts;
    private boolean dirty = false;
    private final HttpExecutor httpExecutor;
    private final Provider<HttpParams> defaultParams;
    private final ConnectionServices connectionServices;

    @Inject
    protected TcpBootstrap(HttpExecutor httpExecutor, @Named(value="defaults") Provider<HttpParams> provider, ConnectionServices connectionServices) {
        this(600000L, httpExecutor, provider, connectionServices);
    }

    protected TcpBootstrap(long l, HttpExecutor httpExecutor, Provider<HttpParams> provider, ConnectionServices connectionServices) {
        this.httpExecutor = httpExecutor;
        this.defaultParams = provider;
        this.connectionServices = connectionServices;
        this.attemptedHosts = new FixedSizeExpiringSet<URI>(100, l);
    }

    public synchronized int getSize() {
        return this.hostsSet.size();
    }

    public synchronized void resetData() {
        LOG.debug((Object)"Clearing attempted host caches");
        this.attemptedHosts.clear();
    }

    public synchronized boolean fetchHosts(TcpBootstrapListener tcpBootstrapListener) {
        if (this.dirty) {
            Collections.shuffle(this.hosts);
            this.dirty = false;
        }
        return this.doFetch(tcpBootstrapListener);
    }

    private boolean doFetch(TcpBootstrapListener tcpBootstrapListener) {
        ArrayList<HttpUriRequest> arrayList = new ArrayList<HttpUriRequest>();
        HashMap<HttpUriRequest, URI> hashMap = new HashMap<HttpUriRequest, URI>();
        for (URI uRI : this.hosts) {
            if (this.attemptedHosts.contains(uRI)) continue;
            HttpUriRequest httpUriRequest = this.newRequest(uRI);
            arrayList.add(httpUriRequest);
            hashMap.put(httpUriRequest, uRI);
        }
        if (arrayList.isEmpty()) {
            return false;
        }
        BasicHttpParams basicHttpParams = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)basicHttpParams, (int)5000);
        HttpConnectionParams.setSoTimeout((HttpParams)basicHttpParams, (int)5000);
        basicHttpParams = new DefaultedHttpParams((HttpParams)basicHttpParams, (HttpParams)this.defaultParams.get());
        this.httpExecutor.executeAny(new Listener(hashMap, tcpBootstrapListener), this.bootstrapQueue, arrayList, (HttpParams)basicHttpParams, new Cancellable(){

            public boolean isCancelled() {
                return TcpBootstrap.this.connectionServices.isConnected();
            }
        });
        return true;
    }

    private HttpUriRequest newRequest(URI uRI) {
        uRI = URI.create(uRI.toString() + "?hostfile=1" + "&client=" + "LIME" + "&version=" + EncodingUtils.encode(LimeWireUtils.getLimeWireVersion()));
        HttpGet httpGet = new HttpGet(uRI);
        httpGet.addHeader("Cache-Control", "no-cache");
        return httpGet;
    }

    private int parseResponse(HttpResponse httpResponse, TcpBootstrapListener tcpBootstrapListener) {
        if (httpResponse.getEntity() == null) {
            LOG.warn((Object)"No response entity!");
            return 0;
        }
        String string = null;
        ArrayList<Endpoint> arrayList = new ArrayList<Endpoint>();
        try {
            InputStream inputStream = httpResponse.getEntity().getContent();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while ((string = bufferedReader.readLine()) != null) {
                Endpoint endpoint = new Endpoint(string, true);
                arrayList.add(endpoint);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOG.error((Object)"IAE", (Throwable)illegalArgumentException);
        }
        catch (IOException iOException) {
            LOG.error((Object)"IOX", (Throwable)iOException);
        }
        if (!arrayList.isEmpty()) {
            return tcpBootstrapListener.handleHosts(arrayList);
        }
        return 0;
    }

    public synchronized boolean add(URI uRI) {
        if (this.hostsSet.contains(uRI)) {
            return false;
        }
        this.hosts.add(uRI);
        this.hostsSet.add(uRI);
        this.dirty = true;
        return true;
    }

    public void loadDefaults() {
        this.add(URI.create("http://aniraws.com/bootstrap/skulls.php"));
        this.add(URI.create("http://bbs.robertwoolley.co.uk/gwebcache/gcache.php"));
        this.add(URI.create("http://beacon.awardspace.com/gwc.php"));
        this.add(URI.create("http://drei.gtkg.net:8080/gwc/"));
        this.add(URI.create("http://ein.gtkg.net:8080/gwc/"));
        this.add(URI.create("http://gnutelladev1.udp-host-cache.com:8080/gwc/"));
        this.add(URI.create("http://gnutelladev2.udp-host-cache.com:8080/gwc/"));
        this.add(URI.create("http://gofoxy.net/gwc/cgi-bin/fc"));
        this.add(URI.create("http://grantgalitz.com/Beacon/gwc.php"));
        this.add(URI.create("http://gwc.ak-electron.eu/gcache.cgi"));
        this.add(URI.create("http://gwc.cluephone.com/skulls.php"));
        this.add(URI.create("http://gwc.dietpac.com:8080/"));
        this.add(URI.create("http://gwc.eod.cc/skulls.php"));
        this.add(URI.create("http://gwc.frodoslair.net.nyud.net/skulls/skulls.php"));
        this.add(URI.create("http://gwc.frodoslair.net/skulls/skulls.php"));
        this.add(URI.create("http://gwc.glucolene.com:8080/"));
        this.add(URI.create("http://gwc.gofoxy.net:2108/gwc/cgi-bin/fc"));
        this.add(URI.create("http://gwc.lame.net/gwcii.php"));
        this.add(URI.create("http://gwc.movingpages.org/gcache/xgcache.php"));
        this.add(URI.create("http://gwc.movingpages.org/skulls.php"));
        this.add(URI.create("http://gwc.stalin.lv/skulls/skulls.php"));
        this.add(URI.create("http://gweb.4octets.co.uk/skulls.php"));
        this.add(URI.create("http://gweb2.4octets.co.uk/gwc.php"));
        this.add(URI.create("http://gwebcache.spearforensics.com/"));
        this.add(URI.create("http://leet.gtkg.org:8080/gwc/"));
        this.add(URI.create("http://secondary.udp-host-cache.com:8080/gwc/"));
        this.add(URI.create("http://sissy.gtkg.org:8080/gwc/"));
        this.add(URI.create("http://tertiary.udp-host-cache.com:8080/gwc/"));
        this.add(URI.create("http://wc.neoboffins.com/index.php"));
        this.add(URI.create("http://zwei.gtkg.net:8080/gwc/"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface TcpBootstrapListener {
        public int handleHosts(Collection<? extends Endpoint> var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Listener
    implements HttpClientListener {
        private final Map<HttpUriRequest, URI> hosts;
        private final TcpBootstrapListener listener;
        private int totalAdded = 0;

        Listener(Map<HttpUriRequest, URI> map, TcpBootstrapListener tcpBootstrapListener) {
            this.hosts = map;
            this.listener = tcpBootstrapListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean requestComplete(HttpUriRequest httpUriRequest, HttpResponse httpResponse) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Completed request: " + httpUriRequest.getRequestLine()));
            }
            TcpBootstrap tcpBootstrap = TcpBootstrap.this;
            synchronized (tcpBootstrap) {
                TcpBootstrap.this.attemptedHosts.add(this.hosts.remove(httpUriRequest));
            }
            this.totalAdded += TcpBootstrap.this.parseResponse(httpResponse, this.listener);
            TcpBootstrap.this.httpExecutor.releaseResources(httpResponse);
            return this.totalAdded < 15;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean requestFailed(HttpUriRequest httpUriRequest, HttpResponse httpResponse, IOException iOException) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Failed request: " + httpUriRequest.getRequestLine()));
            }
            TcpBootstrap tcpBootstrap = TcpBootstrap.this;
            synchronized (tcpBootstrap) {
                TcpBootstrap.this.attemptedHosts.add(this.hosts.remove(httpUriRequest));
            }
            TcpBootstrap.this.httpExecutor.releaseResources(httpResponse);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean allowRequest(HttpUriRequest httpUriRequest) {
            TcpBootstrap tcpBootstrap = TcpBootstrap.this;
            synchronized (tcpBootstrap) {
                return this.hosts.containsKey(httpUriRequest) && !TcpBootstrap.this.attemptedHosts.contains(this.hosts.get(httpUriRequest));
            }
        }
    }
}

