/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.auth;

import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.auth.ContentAuthority;
import com.limegroup.gnutella.messages.Message;
import java.net.UnknownHostException;
import org.limewire.io.IpPort;
import org.limewire.io.IpPortImpl;

public class IpPortContentAuthority
implements ContentAuthority {
    private IpPort authority;
    private String host;
    private int port;
    private final UDPService udpService;

    IpPortContentAuthority(IpPort ipPort, UDPService uDPService) {
        this.authority = ipPort;
        this.udpService = uDPService;
        this.host = ipPort.getAddress();
        this.port = ipPort.getPort();
    }

    IpPortContentAuthority(String string, int n, UDPService uDPService) {
        this.host = string;
        this.port = n;
        this.udpService = uDPService;
    }

    public void send(Message message) {
        this.udpService.send(message, this.authority);
    }

    public boolean initialize() {
        if (this.authority == null) {
            try {
                this.authority = new IpPortImpl(this.host, this.port);
            }
            catch (UnknownHostException unknownHostException) {
                return false;
            }
        }
        return true;
    }

    public IpPort getIpPort() {
        return this.authority;
    }
}

