/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.altlocs;

import com.limegroup.gnutella.ApplicationServices;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.PushEndpoint;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.UrnSet;
import com.limegroup.gnutella.altlocs.AbstractAlternateLocation;
import com.limegroup.gnutella.altlocs.AlternateLocation;
import com.limegroup.gnutella.downloader.RemoteFileDescFactory;
import java.util.Arrays;

public class PushAltLoc
extends AbstractAlternateLocation {
    private final PushEndpoint _pushAddress;
    private final ApplicationServices applicationServices;

    protected PushAltLoc(PushEndpoint pushEndpoint, URN uRN, ApplicationServices applicationServices) {
        super(uRN);
        if (pushEndpoint == null) {
            throw new NullPointerException("null address");
        }
        this._pushAddress = pushEndpoint;
        this.applicationServices = applicationServices;
    }

    protected String generateHTTPString() {
        return this._pushAddress.httpStringValue();
    }

    public RemoteFileDesc createRemoteFileDesc(long l, RemoteFileDescFactory remoteFileDescFactory) {
        UrnSet urnSet = new UrnSet(this.getSHA1Urn());
        int n = 3;
        RemoteFileDesc remoteFileDesc = remoteFileDescFactory.createRemoteFileDesc(this._pushAddress.getAddress(), this._pushAddress.getPort(), 0L, "/uri-res/N2R?" + this.SHA1_URN, l, 1000, true, n, false, null, urnSet, false, true, "ALT", -1L, this._pushAddress);
        return remoteFileDesc;
    }

    public synchronized AlternateLocation createClone() {
        PushAltLoc pushAltLoc = new PushAltLoc(this._pushAddress.createClone(), this.SHA1_URN, this.applicationServices);
        pushAltLoc._count = this._count;
        return pushAltLoc;
    }

    public boolean isMe() {
        return Arrays.equals(this._pushAddress.getClientGUID(), this.applicationServices.getMyGUID());
    }

    public void updateProxies(boolean bl) {
        this._pushAddress.updateProxies(bl);
    }

    public PushEndpoint getPushAddress() {
        return this._pushAddress;
    }

    public int supportsFWTVersion() {
        return this._pushAddress.getFWTVersion();
    }

    void promote() {
    }

    void demote() {
    }

    public boolean isDemoted() {
        return this._pushAddress.getProxies().isEmpty();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof PushAltLoc)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        PushAltLoc pushAltLoc = (PushAltLoc)object;
        return ((Object)this._pushAddress).equals(pushAltLoc._pushAddress);
    }

    public int compareTo(AlternateLocation alternateLocation) {
        if (this == alternateLocation) {
            return 0;
        }
        int n = super.compareTo(alternateLocation);
        if (n != 0) {
            return n;
        }
        if (!(alternateLocation instanceof PushAltLoc)) {
            return 1;
        }
        PushAltLoc pushAltLoc = (PushAltLoc)alternateLocation;
        return GUID.GUID_BYTE_COMPARATOR.compare(this._pushAddress.getClientGUID(), pushAltLoc.getPushAddress().getClientGUID());
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int n = super.hashCode();
            this.hashCode = n = 37 * n + ((Object)this._pushAddress).hashCode();
        }
        return this.hashCode;
    }

    public String toString() {
        return this._pushAddress + "," + this._count;
    }
}

