/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.altlocs;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.gnutella.DownloadManagerEvent;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.PushEndpoint;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.altlocs.AltLocManager;
import com.limegroup.gnutella.altlocs.AlternateLocation;
import com.limegroup.gnutella.altlocs.AlternateLocationFactory;
import com.limegroup.gnutella.dht.db.PushEndpointService;
import com.limegroup.gnutella.dht.db.SearchListener;
import com.limegroup.gnutella.downloader.DownloadStatusEvent;
import java.io.IOException;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.IpPort;
import org.limewire.listener.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class DownloaderGuidAlternateLocationFinder
implements EventListener<DownloadManagerEvent> {
    private static final Log LOG = LogFactory.getLog(DownloaderGuidAlternateLocationFinder.class);
    private final PushEndpointService pushEndpointManager;
    private final AlternateLocationFactory alternateLocationFactory;
    private final AltLocManager altLocManager;
    final EventListener<DownloadStatusEvent> downloadStatusListener = new EventListener<DownloadStatusEvent>(){

        @Override
        public void handleEvent(DownloadStatusEvent downloadStatusEvent) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("per download event received: " + downloadStatusEvent));
            }
            DownloaderGuidAlternateLocationFinder.this.handleStatusEvent(downloadStatusEvent);
        }
    };

    @Inject
    public DownloaderGuidAlternateLocationFinder(@Named(value="pushEndpointManager") PushEndpointService pushEndpointService, AlternateLocationFactory alternateLocationFactory, AltLocManager altLocManager) {
        this.pushEndpointManager = pushEndpointService;
        this.alternateLocationFactory = alternateLocationFactory;
        this.altLocManager = altLocManager;
    }

    @Override
    public void handleEvent(DownloadManagerEvent downloadManagerEvent) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("event received: " + downloadManagerEvent));
        }
        switch ((DownloadManagerEvent.Type)((Object)downloadManagerEvent.getType())) {
            case ADDED: {
                break;
            }
        }
    }

    void handleStatusEvent(DownloadStatusEvent downloadStatusEvent) {
        switch ((Downloader.DownloadStatus)((Object)downloadStatusEvent.getType())) {
            default: 
        }
    }

    void searchForPushEndpoints(URN uRN, Set<URN> set) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Searching for guid urns: " + set));
        }
        for (URN uRN2 : set) {
            try {
                GUID gUID = new GUID(uRN2.getNamespaceSpecificString());
                this.pushEndpointManager.findPushEndpoint(gUID, new PushendpointHandler(uRN));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (!LOG.isErrorEnabled()) continue;
                LOG.error((Object)"invalid hex string of guid", (Throwable)illegalArgumentException);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PushendpointHandler
    implements SearchListener<PushEndpoint> {
        private final URN sha1;

        public PushendpointHandler(URN uRN) {
            this.sha1 = uRN;
        }

        @Override
        public void handleResult(PushEndpoint pushEndpoint) {
            IpPort ipPort;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("endpoint found: " + pushEndpoint));
            }
            if ((ipPort = pushEndpoint.getValidExternalAddress()) != null && pushEndpoint.getProxies().size() == 1 && pushEndpoint.getProxies().contains(ipPort)) {
                try {
                    LOG.debug((Object)"creating direct altloc");
                    AlternateLocation alternateLocation = DownloaderGuidAlternateLocationFinder.this.alternateLocationFactory.createDirectAltLoc(ipPort, this.sha1);
                    DownloaderGuidAlternateLocationFinder.this.altLocManager.add(alternateLocation, null);
                }
                catch (IOException iOException) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)("error creating direct alt loc from " + ipPort), (Throwable)iOException);
                    }
                }
            } else {
                LOG.debug((Object)"creating push altloc");
                AlternateLocation alternateLocation = DownloaderGuidAlternateLocationFinder.this.alternateLocationFactory.createPushAltLoc(pushEndpoint, this.sha1);
                DownloaderGuidAlternateLocationFinder.this.altLocManager.add(alternateLocation, null);
            }
        }

        @Override
        public void searchFailed() {
        }
    }
}

