/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.altlocs;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.ApplicationServices;
import com.limegroup.gnutella.ConnectionServices;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.PushEndpoint;
import com.limegroup.gnutella.PushEndpointFactory;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.altlocs.AlternateLocation;
import com.limegroup.gnutella.altlocs.AlternateLocationFactory;
import com.limegroup.gnutella.altlocs.DirectAltLoc;
import com.limegroup.gnutella.altlocs.DirectDHTAltLoc;
import com.limegroup.gnutella.altlocs.PushAltLoc;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.SSLSettings;
import java.io.IOException;
import org.limewire.io.ConnectableImpl;
import org.limewire.io.IP;
import org.limewire.io.IpPort;
import org.limewire.io.IpPortForSelf;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.io.NetworkUtils;
import org.limewire.service.ErrorService;

@Singleton
public class AlternateLocationFactoryImpl
implements AlternateLocationFactory {
    private final NetworkManager networkManager;
    private final PushEndpointFactory pushEndpointFactory;
    private final ApplicationServices applicationServices;
    private final ConnectionServices connectionServices;
    private final NetworkInstanceUtils networkInstanceUtils;
    private final IpPortForSelf ipPortForSelf;

    @Inject
    public AlternateLocationFactoryImpl(NetworkManager networkManager, PushEndpointFactory pushEndpointFactory, ApplicationServices applicationServices, ConnectionServices connectionServices, NetworkInstanceUtils networkInstanceUtils, IpPortForSelf ipPortForSelf) {
        this.networkManager = networkManager;
        this.pushEndpointFactory = pushEndpointFactory;
        this.applicationServices = applicationServices;
        this.connectionServices = connectionServices;
        this.networkInstanceUtils = networkInstanceUtils;
        this.ipPortForSelf = ipPortForSelf;
    }

    public AlternateLocation create(URN uRN) {
        if (uRN == null) {
            throw new NullPointerException("null sha1");
        }
        try {
            boolean bl = this.connectionServices.isConnected() ? this.networkManager.acceptedIncomingConnection() : ConnectionSettings.EVER_ACCEPTED_INCOMING.getValue();
            if (bl && this.networkInstanceUtils.isValidExternalIpPort(this.ipPortForSelf)) {
                return new DirectAltLoc(new ConnectableImpl(NetworkUtils.ip2string(this.networkManager.getAddress()), this.networkManager.getPort(), SSLSettings.isIncomingTLSEnabled()), uRN, this.networkInstanceUtils, this.ipPortForSelf);
            }
            return new PushAltLoc(this.pushEndpointFactory.createForSelf(), uRN, this.applicationServices);
        }
        catch (IOException iOException) {
            ErrorService.error(iOException);
            return null;
        }
    }

    public AlternateLocation create(RemoteFileDesc remoteFileDesc) throws IOException {
        if (remoteFileDesc == null) {
            throw new NullPointerException("cannot accept null RFD");
        }
        URN uRN = remoteFileDesc.getSHA1Urn();
        if (uRN == null) {
            throw new NullPointerException("cannot accept null URN");
        }
        if (!remoteFileDesc.needsPush()) {
            return new DirectAltLoc(new ConnectableImpl(remoteFileDesc.getHost(), remoteFileDesc.getPort(), remoteFileDesc.isTLSCapable()), uRN, this.networkInstanceUtils, this.ipPortForSelf);
        }
        PushEndpoint pushEndpoint = remoteFileDesc.getPushAddr() != null ? remoteFileDesc.getPushAddr() : this.pushEndpointFactory.createPushEndpoint(remoteFileDesc.getClientGUID(), IpPort.EMPTY_SET, (byte)0, 0, null);
        return new PushAltLoc(pushEndpoint, uRN, this.applicationServices);
    }

    public AlternateLocation createPushAltLoc(PushEndpoint pushEndpoint, URN uRN) {
        return new PushAltLoc(pushEndpoint, uRN, this.applicationServices);
    }

    public AlternateLocation createDirectDHTAltLoc(IpPort ipPort, URN uRN, long l, byte[] byArray) throws IOException {
        return new DirectDHTAltLoc(ipPort, uRN, l, byArray, this.networkInstanceUtils, this.ipPortForSelf);
    }

    public AlternateLocation createDirectAltLoc(IpPort ipPort, URN uRN) throws IOException {
        return new DirectAltLoc(ipPort, uRN, this.networkInstanceUtils, this.ipPortForSelf);
    }

    public AlternateLocation create(String string, URN uRN, boolean bl) throws IOException {
        if (string == null || string.equals("")) {
            throw new IOException("null or empty location");
        }
        if (uRN == null) {
            throw new IOException("null URN.");
        }
        if (string.indexOf(";") == -1) {
            IpPort ipPort = this.createUrlFromMini(string, uRN, bl);
            return new DirectAltLoc(ipPort, uRN, this.networkInstanceUtils, this.ipPortForSelf);
        }
        PushEndpoint pushEndpoint = this.pushEndpointFactory.createPushEndpoint(string);
        return new PushAltLoc(pushEndpoint, uRN, this.applicationServices);
    }

    public AlternateLocation create(String string, URN uRN) throws IOException {
        return this.create(string, uRN, false);
    }

    private IpPort createUrlFromMini(String string, URN uRN, boolean bl) throws IOException {
        int n = string.indexOf(58);
        String string2 = n == -1 ? string : string.substring(0, n);
        try {
            new IP(string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException("invalid location: " + string);
        }
        if (string2.indexOf(47) != -1) {
            throw new IOException("invalid location: " + string);
        }
        if (!NetworkUtils.isValidAddress(string2)) {
            throw new IOException("invalid location: " + string);
        }
        if (n == -1) {
            n = 6346;
        } else {
            if (string.length() < n + 1) {
                throw new IOException("invalid location: " + string);
            }
            try {
                n = Integer.parseInt(string.substring(n + 1));
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException("invalid location: " + string);
            }
        }
        if (!NetworkUtils.isValidPort(n)) {
            throw new IOException("invalid port: " + n);
        }
        return new ConnectableImpl(string2, n, bl);
    }
}

