/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.altlocs;

import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.altlocs.AbstractAlternateLocation;
import com.limegroup.gnutella.altlocs.AlternateLocation;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import java.io.IOException;
import java.util.Iterator;
import org.limewire.collection.FixedSizeSortedSet;
import org.limewire.service.ErrorService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlternateLocationCollection<T extends AlternateLocation>
implements HTTPHeaderValue,
Iterable<T> {
    private static final int MAX_SIZE = 100;
    public static final AlternateLocationCollection EMPTY;
    private final FixedSizeSortedSet<T> LOCATIONS = new FixedSizeSortedSet(100);
    private final URN SHA1;

    public static <T extends AlternateLocation> AlternateLocationCollection<T> getEmptyCollection() {
        return EMPTY;
    }

    public static <T extends AlternateLocation> AlternateLocationCollection<T> create(URN uRN) {
        return new AlternateLocationCollection<T>(uRN);
    }

    private AlternateLocationCollection(URN uRN) {
        if (uRN == null) {
            throw new NullPointerException("null URN");
        }
        if (!uRN.isSHA1()) {
            throw new IllegalArgumentException("URN must be a SHA1");
        }
        this.SHA1 = uRN;
    }

    public URN getSHA1Urn() {
        return this.SHA1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(T t) {
        URN uRN = t.getSHA1Urn();
        if (!uRN.equals(this.SHA1)) {
            throw new IllegalArgumentException("SHA1 does not match");
        }
        AlternateLocationCollection alternateLocationCollection = this;
        synchronized (alternateLocationCollection) {
            AlternateLocation alternateLocation = (AlternateLocation)this.LOCATIONS.get(t);
            boolean bl = false;
            if (alternateLocation == null) {
                bl = true;
                this.LOCATIONS.add(t);
            } else {
                this.LOCATIONS.remove(alternateLocation);
                alternateLocation.increment();
                if (alternateLocation instanceof AbstractAlternateLocation) {
                    AbstractAlternateLocation abstractAlternateLocation = (AbstractAlternateLocation)alternateLocation;
                    abstractAlternateLocation.promote();
                    abstractAlternateLocation.resetSent();
                }
                bl = false;
                this.LOCATIONS.add(alternateLocation);
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(T t) {
        URN uRN = t.getSHA1Urn();
        if (!uRN.equals(this.SHA1)) {
            return false;
        }
        AlternateLocationCollection alternateLocationCollection = this;
        synchronized (alternateLocationCollection) {
            AlternateLocation alternateLocation = (AlternateLocation)this.LOCATIONS.get(t);
            if (alternateLocation == null) {
                return false;
            }
            if (alternateLocation.isDemoted()) {
                this.LOCATIONS.remove(alternateLocation);
                return true;
            }
            this.LOCATIONS.remove(alternateLocation);
            if (alternateLocation instanceof AbstractAlternateLocation) {
                AbstractAlternateLocation abstractAlternateLocation = (AbstractAlternateLocation)alternateLocation;
                abstractAlternateLocation.demote();
            }
            this.LOCATIONS.add(alternateLocation);
            return false;
        }
    }

    public synchronized void clear() {
        this.LOCATIONS.clear();
    }

    public synchronized boolean hasAlternateLocations() {
        return !this.LOCATIONS.isEmpty();
    }

    public synchronized boolean contains(AlternateLocation alternateLocation) {
        return this.LOCATIONS.contains(alternateLocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String httpStringValue() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        AlternateLocationCollection alternateLocationCollection = this;
        synchronized (alternateLocationCollection) {
            for (AlternateLocation alternateLocation : this.LOCATIONS) {
                stringBuilder.append(alternateLocation.httpStringValue());
                stringBuilder.append(", ");
                bl = true;
            }
        }
        if (bl) {
            stringBuilder.setLength(stringBuilder.length() - 2);
        }
        return stringBuilder.toString();
    }

    public synchronized int getAltLocsSize() {
        return this.LOCATIONS.size();
    }

    @Override
    public Iterator<T> iterator() {
        return this.LOCATIONS.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Alternate Locations: ");
        AlternateLocationCollection alternateLocationCollection = this;
        synchronized (alternateLocationCollection) {
            for (AlternateLocation alternateLocation : this.LOCATIONS) {
                stringBuilder.append(alternateLocation.toString());
                stringBuilder.append("\n");
            }
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AlternateLocationCollection)) {
            return false;
        }
        AlternateLocationCollection alternateLocationCollection = (AlternateLocationCollection)object;
        boolean bl = this.SHA1.equals(alternateLocationCollection.SHA1);
        if (!bl) {
            return false;
        }
        Class<AlternateLocationCollection> clazz = AlternateLocationCollection.class;
        synchronized (AlternateLocationCollection.class) {
            AlternateLocationCollection alternateLocationCollection2 = this;
            synchronized (alternateLocationCollection2) {
                AlternateLocationCollection alternateLocationCollection3 = alternateLocationCollection;
                synchronized (alternateLocationCollection3) {
                    bl = this.LOCATIONS.equals(alternateLocationCollection.LOCATIONS);
                }
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return bl;
        }
    }

    static {
        EmptyCollection emptyCollection = null;
        try {
            emptyCollection = new EmptyCollection();
        }
        catch (IOException iOException) {
            ErrorService.error(iOException);
        }
        EMPTY = emptyCollection;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EmptyCollection
    extends AlternateLocationCollection<AlternateLocation> {
        EmptyCollection() throws IOException {
            super(URN.createSHA1Urn("urn:sha1:PLSTHIPQGSSZTS5FJUPAKUZWUGYQYPFB"));
        }

        @Override
        public boolean add(AlternateLocation alternateLocation) {
            throw new UnsupportedOperationException();
        }
    }
}

