/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.altlocs;

import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.altlocs.AlternateLocation;
import com.limegroup.gnutella.altlocs.AlternateLocationFactory;
import com.limegroup.gnutella.http.HTTPUtils;
import java.io.IOException;
import java.util.StringTokenizer;
import org.limewire.collection.BitNumbers;
import org.limewire.collection.Function;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AltLocUtils {
    private AltLocUtils() {
    }

    public static void parseAlternateLocations(URN uRN, String string, boolean bl, AlternateLocationFactory alternateLocationFactory, Function<AlternateLocation, Void> function) {
        AltLocUtils.parseAlternateLocations(uRN, string, bl, alternateLocationFactory, function, false);
    }

    public static void parseAlternateLocations(URN uRN, String string, boolean bl, AlternateLocationFactory alternateLocationFactory, Function<AlternateLocation, Void> function, boolean bl2) {
        if (string == null) {
            return;
        }
        if (uRN == null) {
            return;
        }
        BitNumbers bitNumbers = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            Object object;
            String string2 = stringTokenizer.nextToken().trim();
            if (bl && bitNumbers == null && string2.startsWith("tls=")) {
                bitNumbers = BitNumbers.EMPTY_BN;
                try {
                    object = HTTPUtils.parseValue(string2);
                    if (object == null) continue;
                    try {
                        bitNumbers = new BitNumbers((String)object);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                }
                catch (IOException iOException) {}
                continue;
            }
            if (bitNumbers == null) {
                bitNumbers = BitNumbers.EMPTY_BN;
            }
            try {
                object = alternateLocationFactory.create(string2, uRN, bitNumbers.isSet(n));
                ++n;
                assert (object.getSHA1Urn().equals(uRN)) : "sha1 mismatch!";
                if (object.isMe() && !bl2) continue;
                function.apply((AlternateLocation)object);
            }
            catch (IOException iOException) {
                bitNumbers = BitNumbers.EMPTY_BN;
            }
        }
    }
}

