/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.altlocs;

import com.google.inject.Singleton;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.altlocs.AltLocListener;
import com.limegroup.gnutella.altlocs.AlternateLocation;
import com.limegroup.gnutella.altlocs.AlternateLocationCollection;
import com.limegroup.gnutella.altlocs.DirectAltLoc;
import com.limegroup.gnutella.altlocs.PushAltLoc;
import com.limegroup.gnutella.util.ClassCNetworks;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.inspection.Inspectable;
import org.limewire.inspection.InspectableContainer;
import org.limewire.inspection.InspectionPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class AltLocManager {
    private static final Log LOG = LogFactory.getLog(AltLocManager.class);
    private final Map<URN, URNData> urnMap = Collections.synchronizedMap(new HashMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(AlternateLocation alternateLocation, Object object) {
        URNData uRNData;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("alternate location added: " + alternateLocation));
        }
        URN uRN = alternateLocation.getSHA1Urn();
        AlternateLocationCollection<DirectAltLoc> alternateLocationCollection = null;
        AlternateLocationCollection<PushAltLoc> alternateLocationCollection2 = null;
        Object object2 = this.urnMap;
        synchronized (object2) {
            uRNData = this.urnMap.get(uRN);
            if (uRNData == null) {
                uRNData = new URNData();
                this.urnMap.put(uRN, uRNData);
            }
        }
        object2 = uRNData;
        synchronized (object2) {
            if (alternateLocation instanceof DirectAltLoc) {
                if (uRNData.direct == AlternateLocationCollection.EMPTY) {
                    uRNData.direct = AlternateLocationCollection.create(uRN);
                }
                alternateLocationCollection = uRNData.direct;
            } else if (alternateLocation instanceof PushAltLoc) {
                PushAltLoc pushAltLoc = (PushAltLoc)alternateLocation;
                if (pushAltLoc.supportsFWTVersion() < 1) {
                    if (uRNData.push == AlternateLocationCollection.EMPTY) {
                        uRNData.push = AlternateLocationCollection.create(uRN);
                    }
                    alternateLocationCollection2 = uRNData.push;
                } else {
                    if (uRNData.fwt == AlternateLocationCollection.EMPTY) {
                        uRNData.fwt = AlternateLocationCollection.create(uRN);
                    }
                    alternateLocationCollection2 = uRNData.fwt;
                }
            } else {
                throw new IllegalStateException("unknown loc class: " + alternateLocation.getClass());
            }
        }
        boolean bl = false;
        if (alternateLocationCollection != null) {
            bl = alternateLocationCollection.add((DirectAltLoc)alternateLocation);
        } else if (alternateLocationCollection2 != null) {
            bl = alternateLocationCollection2.add((PushAltLoc)alternateLocation);
        } else {
            throw new IllegalStateException("didn't set a collection!");
        }
        for (AltLocListener altLocListener : uRNData.getListeners()) {
            if (altLocListener == object) continue;
            altLocListener.locationAdded(alternateLocation);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(AlternateLocation alternateLocation, Object object) {
        URN uRN = alternateLocation.getSHA1Urn();
        URNData uRNData = this.urnMap.get(uRN);
        if (uRNData == null) {
            return false;
        }
        AlternateLocationCollection<DirectAltLoc> alternateLocationCollection = null;
        AlternateLocationCollection<PushAltLoc> alternateLocationCollection2 = null;
        AlternateLocationCollection<PushAltLoc> alternateLocationCollection3 = uRNData;
        synchronized (alternateLocationCollection3) {
            if (alternateLocation instanceof DirectAltLoc) {
                alternateLocationCollection = uRNData.direct;
            } else {
                PushAltLoc pushAltLoc = (PushAltLoc)alternateLocation;
                alternateLocationCollection2 = pushAltLoc.supportsFWTVersion() < 1 ? uRNData.push : uRNData.fwt;
            }
        }
        alternateLocationCollection3 = null;
        boolean bl = false;
        if (alternateLocationCollection != null) {
            bl = alternateLocationCollection.remove((DirectAltLoc)alternateLocation);
            alternateLocationCollection3 = alternateLocationCollection;
        } else if (alternateLocationCollection2 != null) {
            bl = alternateLocationCollection2.remove((PushAltLoc)alternateLocation);
            alternateLocationCollection3 = alternateLocationCollection2;
        } else {
            return false;
        }
        if (!alternateLocationCollection3.hasAlternateLocations()) {
            this.removeIfEmpty(uRN, uRNData);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeIfEmpty(URN uRN, URNData uRNData) {
        boolean bl = false;
        URNData uRNData2 = uRNData;
        synchronized (uRNData2) {
            if (!uRNData.direct.hasAlternateLocations() && !uRNData.push.hasAlternateLocations() && !uRNData.fwt.hasAlternateLocations() && uRNData.getListeners().isEmpty()) {
                bl = true;
            }
        }
        if (bl) {
            this.urnMap.remove(uRN);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AlternateLocationCollection<DirectAltLoc> getDirect(URN uRN) {
        URNData uRNData = this.urnMap.get(uRN);
        if (uRNData == null) {
            return AlternateLocationCollection.getEmptyCollection();
        }
        URNData uRNData2 = uRNData;
        synchronized (uRNData2) {
            return uRNData.direct;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AlternateLocationCollection<PushAltLoc> getPushNoFWT(URN uRN) {
        URNData uRNData = this.urnMap.get(uRN);
        if (uRNData == null) {
            return AlternateLocationCollection.getEmptyCollection();
        }
        URNData uRNData2 = uRNData;
        synchronized (uRNData2) {
            return uRNData.push;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AlternateLocationCollection<PushAltLoc> getPushFWT(URN uRN) {
        URNData uRNData = this.urnMap.get(uRN);
        if (uRNData == null) {
            return AlternateLocationCollection.getEmptyCollection();
        }
        URNData uRNData2 = uRNData;
        synchronized (uRNData2) {
            return uRNData.fwt;
        }
    }

    public void purge() {
        this.urnMap.clear();
    }

    public void purge(URN uRN) {
        this.urnMap.remove(uRN);
    }

    public boolean hasAltlocs(URN uRN) {
        URNData uRNData = this.urnMap.get(uRN);
        if (uRNData == null) {
            return false;
        }
        return uRNData.hasAltLocs();
    }

    public int getNumLocs(URN uRN) {
        URNData uRNData = this.urnMap.get(uRN);
        if (uRNData == null) {
            return 0;
        }
        return uRNData.getNumLocs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(URN uRN, AltLocListener altLocListener) {
        URNData uRNData;
        Map<URN, URNData> map = this.urnMap;
        synchronized (map) {
            uRNData = this.urnMap.get(uRN);
            if (uRNData == null) {
                uRNData = new URNData();
                this.urnMap.put(uRN, uRNData);
            }
        }
        uRNData.addListener(altLocListener);
    }

    public void removeListener(URN uRN, AltLocListener altLocListener) {
        URNData uRNData = this.urnMap.get(uRN);
        if (uRNData == null) {
            return;
        }
        uRNData.removeListener(altLocListener);
        this.removeIfEmpty(uRN, uRNData);
    }

    @InspectableContainer
    private class ALMInspectables {
        @InspectionPoint(value="alternate locations class C stats")
        public final Inspectable classC = new Inspectable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object inspect() {
                ClassCNetworks classCNetworks = new ClassCNetworks();
                ClassCNetworks classCNetworks2 = new ClassCNetworks();
                HashMap<String, byte[]> hashMap = AltLocManager.this.urnMap;
                synchronized (hashMap) {
                    for (URNData uRNData : AltLocManager.this.urnMap.values()) {
                        for (DirectAltLoc directAltLoc : uRNData.direct) {
                            classCNetworks.add(directAltLoc.getHost().getInetAddress(), 1);
                        }
                        for (PushAltLoc pushAltLoc : uRNData.push) {
                            classCNetworks2.addAll(pushAltLoc.getPushAddress().getProxies());
                        }
                        for (PushAltLoc pushAltLoc : uRNData.fwt) {
                            classCNetworks2.addAll(pushAltLoc.getPushAddress().getProxies());
                        }
                    }
                }
                hashMap = new HashMap<String, byte[]>();
                hashMap.put("direct", classCNetworks.getTopInspectable(10));
                hashMap.put("proxies", classCNetworks2.getTopInspectable(10));
                return hashMap;
            }
        };

        private ALMInspectables() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class URNData {
        public AlternateLocationCollection<DirectAltLoc> direct = AlternateLocationCollection.getEmptyCollection();
        public AlternateLocationCollection<PushAltLoc> push = AlternateLocationCollection.getEmptyCollection();
        public AlternateLocationCollection<PushAltLoc> fwt = AlternateLocationCollection.getEmptyCollection();
        private volatile List<AltLocListener> listeners = Collections.emptyList();

        private URNData() {
        }

        public synchronized boolean hasAltLocs() {
            return this.direct.hasAlternateLocations() || this.push.hasAlternateLocations() || this.fwt.hasAlternateLocations();
        }

        public synchronized int getNumLocs() {
            return this.direct.getAltLocsSize() + this.push.getAltLocsSize() + this.fwt.getAltLocsSize();
        }

        public synchronized void addListener(AltLocListener altLocListener) {
            ArrayList<AltLocListener> arrayList = new ArrayList<AltLocListener>(this.listeners);
            arrayList.add(altLocListener);
            this.listeners = arrayList;
        }

        public synchronized void removeListener(AltLocListener altLocListener) {
            ArrayList<AltLocListener> arrayList = new ArrayList<AltLocListener>(this.listeners);
            arrayList.remove(altLocListener);
            this.listeners = arrayList;
        }

        public List<AltLocListener> getListeners() {
            return this.listeners;
        }
    }
}

