/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.altlocs;

import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.altlocs.AlternateLocation;
import com.limegroup.gnutella.downloader.RemoteFileDescFactory;
import com.limegroup.gnutella.settings.UploadSettings;
import org.limewire.util.Objects;

public abstract class AbstractAlternateLocation
implements AlternateLocation {
    protected final URN SHA1_URN;
    private String DISPLAY_STRING;
    protected volatile int hashCode = 0;
    protected volatile int _count = 0;
    private final Average legacy;
    private final Average ping;
    private final Average response;

    protected AbstractAlternateLocation(URN uRN) {
        this.SHA1_URN = Objects.nonNull(uRN, "sha1");
        this.legacy = new Average();
        this.ping = new Average();
        this.response = new Average();
    }

    public URN getSHA1Urn() {
        return this.SHA1_URN;
    }

    public synchronized int getCount() {
        return this._count;
    }

    public abstract boolean isDemoted();

    public String httpStringValue() {
        if (this.DISPLAY_STRING == null) {
            this.DISPLAY_STRING = this.generateHTTPString();
        }
        return this.DISPLAY_STRING;
    }

    public abstract RemoteFileDesc createRemoteFileDesc(long var1, RemoteFileDescFactory var3);

    public abstract boolean isMe();

    public synchronized void increment() {
        ++this._count;
    }

    abstract void demote();

    abstract void promote();

    public abstract AlternateLocation createClone();

    public synchronized void send(long l, int n) {
        switch (n) {
            case 1: {
                this.legacy.send(l);
                return;
            }
            case 0: {
                this.ping.send(l);
                return;
            }
            case 2: {
                this.response.send(l);
                return;
            }
        }
        throw new IllegalArgumentException("unknown mesh type");
    }

    public synchronized boolean canBeSent(int n) {
        switch (n) {
            case 1: {
                if (!UploadSettings.EXPIRE_LEGACY.getValue()) {
                    return true;
                }
                return this.legacy.canBeSent(UploadSettings.LEGACY_BIAS.getValue(), UploadSettings.LEGACY_EXPIRATION_DAMPER.getValue());
            }
            case 0: {
                if (!UploadSettings.EXPIRE_PING.getValue()) {
                    return true;
                }
                return this.ping.canBeSent(UploadSettings.PING_BIAS.getValue(), UploadSettings.PING_EXPIRATION_DAMPER.getValue());
            }
            case 2: {
                if (!UploadSettings.EXPIRE_RESPONSE.getValue()) {
                    return true;
                }
                return this.response.canBeSent(UploadSettings.RESPONSE_BIAS.getValue(), UploadSettings.RESPONSE_EXPIRATION_DAMPER.getValue());
            }
        }
        throw new IllegalArgumentException("unknown mesh type");
    }

    public synchronized boolean canBeSentAny() {
        return this.canBeSent(1) || this.canBeSent(0) || this.canBeSent(2);
    }

    synchronized void resetSent() {
        this.ping.reset();
        this.legacy.reset();
        this.response.reset();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AbstractAlternateLocation)) {
            return false;
        }
        AbstractAlternateLocation abstractAlternateLocation = (AbstractAlternateLocation)object;
        return this.SHA1_URN.equals(abstractAlternateLocation.SHA1_URN);
    }

    public int compareTo(AlternateLocation alternateLocation) {
        int n = this._count - alternateLocation.getCount();
        if (n != 0) {
            return n;
        }
        return n;
    }

    protected abstract String generateHTTPString();

    public int hashCode() {
        return 629 + this.SHA1_URN.hashCode();
    }

    private static class Average {
        private int numTimes;
        private double average;
        private long lastSentTime;
        private double cachedTreshold = -1.0;

        private Average() {
        }

        public void send(long l) {
            if (this.lastSentTime == 0L) {
                this.lastSentTime = l;
            }
            this.average = (this.average * (double)this.numTimes + (double)(l - this.lastSentTime)) / (double)(++this.numTimes);
            this.lastSentTime = l;
            this.cachedTreshold = -1.0;
        }

        public boolean canBeSent(float f, float f2) {
            if (this.numTimes < 2 || this.average == 0.0) {
                return true;
            }
            if (this.cachedTreshold == -1.0) {
                this.cachedTreshold = Math.abs(Math.log(this.average) / Math.log(f2));
            }
            return (double)this.numTimes < this.cachedTreshold * (double)f;
        }

        public void reset() {
            this.numTimes = 0;
            this.average = 0.0;
            this.lastSentTime = 0L;
        }
    }
}

