/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.UrnSet;
import com.limegroup.gnutella.UrnType;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import com.limegroup.gnutella.security.MerkleTree;
import com.limegroup.gnutella.security.SHA1;
import com.limegroup.gnutella.security.Tiger;
import com.limegroup.gnutella.settings.SharingSettings;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.limewire.io.IOUtils;
import org.limewire.util.Base32;
import org.limewire.util.SystemUtils;

public final class URN
implements HTTPHeaderValue,
Serializable {
    private static final long serialVersionUID = -6053855548211564799L;
    public static final Set<URN> NO_URN_SET = Collections.emptySet();
    public static final URN INVALID = new URN("bad:bad", Type.INVALID);
    public static final int MIN_IDLE_TIME = 300000;
    private static final String SPACE = " ";
    private static final String QUESTION_MARK = "?";
    private static final String SLASH = "/";
    private static final String TWO = "2";
    private static final String DOT = ".";
    private transient String _urnString;
    private transient Type _urnType;
    private volatile transient int hashCode = 0;
    private static final Map<File, AtomicInteger> progressMap = Collections.synchronizedMap(new HashMap());
    private static final ThreadLocal<byte[]> threadLocal = new ThreadLocal<byte[]>(){

        @Override
        protected byte[] initialValue() {
            return new byte[65536];
        }
    };

    public static int getHashingProgress(File file) {
        AtomicInteger atomicInteger = progressMap.get(file);
        if (atomicInteger == null) {
            return -1;
        }
        return atomicInteger.get();
    }

    public static URN createSHA1Urn(File file) throws IOException, InterruptedException {
        return URN.createSHA1AndTTRootUrns(file).getSHA1();
    }

    public static URN createSHA1Urn(String string) throws IOException {
        String string2 = URN.getTypeString(string).toLowerCase(Locale.US);
        if (string2.indexOf(Type.SHA1.getDescriptor()) == 4) {
            return URN.createUrnFromString(string);
        }
        if (string2.indexOf(Type.BITPRINT.getDescriptor()) == 4) {
            return URN.createSHA1UrnFromBitprint(string);
        }
        throw new IOException("unsupported or malformed URN");
    }

    public static URN createGUIDUrn(String string) throws IOException {
        URN uRN = URN.createUrnFromString(string);
        if (uRN.getUrnType() != Type.GUID) {
            throw new IOException("Not a GUID urn: " + string);
        }
        return uRN;
    }

    public static URN createGUIDUrn(GUID gUID) {
        return new URN("urn:" + Type.GUID.getDescriptor() + gUID.toHexString(), Type.GUID);
    }

    public static URN createTTRootUrn(String string) throws IOException {
        String string2 = URN.getTypeString(string).toLowerCase(Locale.US);
        if (string2.indexOf(Type.TTROOT.getDescriptor()) == 4) {
            return new URN(string, Type.TTROOT);
        }
        throw new IOException("unsupported or malformed URN");
    }

    public static String getTigerTreeRoot(String string) throws IOException {
        String string2 = URN.getTypeString(string).toLowerCase(Locale.US);
        if (string2.indexOf(Type.BITPRINT.getDescriptor()) == 4) {
            return URN.getTTRootFromBitprint(string);
        }
        throw new IOException("unsupported or malformed URN");
    }

    public static URN createSHA1UrnFromURL(URL uRL) throws IOException {
        return URN.createSHA1UrnFromUriRes(uRL.getFile());
    }

    public static URN createSHA1UrnFromUriRes(String string) throws IOException {
        string.trim();
        if (URN.isValidUriResSHA1Format(string)) {
            return URN.createUrnFromString(string.substring(13));
        }
        throw new IOException("could not parse string format: " + string);
    }

    public static URN createSHA1UrnFromHttpRequest(String string) throws IOException {
        if (!URN.isValidUrnHttpRequest(string)) {
            throw new IOException("INVALID URN HTTP REQUEST");
        }
        String string2 = URN.extractUrnFromHttpRequest(string);
        if (string2 == null) {
            throw new IOException("COULD NOT CONSTRUCT URN");
        }
        return URN.createSHA1Urn(string2);
    }

    public static URN createSHA1UrnFromBytes(byte[] byArray) throws IOException {
        if (byArray == null || byArray.length != 20) {
            throw new IOException("invalid bytes!");
        }
        String string = Base32.encode(byArray);
        return URN.createUrnFromString("urn:sha1:" + string);
    }

    public static URN createTTRootFromBytes(byte[] byArray) throws IOException {
        if (byArray == null || byArray.length != 24) {
            throw new IOException("invalid bytes!");
        }
        String string = Base32.encode(byArray);
        return new URN("urn:" + Type.TTROOT.getDescriptor() + string, Type.TTROOT);
    }

    private static URN createUrnFromString(String string) throws IOException {
        if (!URN.isValidUrn(string)) {
            throw new IOException("invalid urn string: " + string);
        }
        String string2 = URN.getTypeString(string);
        Type type = Type.createUrnType(string2);
        if (type == null) {
            throw new IOException("urn type not recognized: " + string2);
        }
        return new URN(string, type);
    }

    private static URN createSHA1UrnFromBitprint(String string) throws IOException {
        int n = string.indexOf(DOT);
        if (n == -1) {
            throw new IOException("invalid bitprint: " + string);
        }
        String string2 = string.substring(string.indexOf(58, 4) + 1, n);
        return URN.createUrnFromString("urn:" + Type.SHA1.getDescriptor() + string2);
    }

    private static String getTTRootFromBitprint(String string) throws IOException {
        int n = string.indexOf(DOT);
        if (n == -1 || n == string.length() - 1) {
            throw new IOException("invalid bitprint: " + string);
        }
        String string2 = string.substring(n + 1);
        if (string2.length() != 39) {
            throw new IOException("wrong length: " + string2.length());
        }
        return string2;
    }

    private URN(String string, Type type) {
        int n = string.lastIndexOf(":");
        String string2 = string.substring(0, n + 1);
        String string3 = string.substring(n + 1);
        this._urnString = string2.toLowerCase(Locale.US) + string3.toUpperCase(Locale.US);
        this._urnType = type;
    }

    public byte[] getBytes() {
        return Base32.decode(this.getNamespaceSpecificString());
    }

    public String getNamespaceSpecificString() {
        return this._urnString.substring(this._urnString.lastIndexOf(58) + 1);
    }

    public Type getUrnType() {
        return this._urnType;
    }

    public String httpStringValue() {
        return this._urnString;
    }

    public static boolean isUrn(String string) {
        return URN.isValidUrn(string);
    }

    public boolean isSHA1() {
        return this._urnType == Type.SHA1;
    }

    public boolean isTTRoot() {
        return this._urnType == Type.TTROOT;
    }

    public boolean isGUID() {
        return this._urnType == Type.GUID;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof URN)) {
            return false;
        }
        if (this.hashCode() != object.hashCode()) {
            return false;
        }
        URN uRN = (URN)object;
        return this._urnString.equals(uRN._urnString) && this._urnType.equals((Object)uRN._urnType);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int n = 17;
            n = 37 * n + this._urnString.hashCode();
            this.hashCode = n = 37 * n + this._urnType.hashCode();
        }
        return this.hashCode;
    }

    public String toString() {
        return this._urnString;
    }

    private static boolean isValidUriResSHA1Format(String string) {
        String string2 = string.toLowerCase(Locale.US);
        if (string2.startsWith("/uri-res/n2r?urn:sha1:")) {
            return string.length() == 54;
        }
        return false;
    }

    private static String extractUrnFromHttpRequest(String string) {
        int n = string.indexOf(QUESTION_MARK) + 1;
        int n2 = string.indexOf(SPACE, n);
        if (n == -1 || n2 == -1) {
            return null;
        }
        return string.substring(n, n2);
    }

    private static boolean isValidUrnHttpRequest(String string) {
        return URN.isValidLength(string) && URN.isValidUriRes(string) && URN.isValidResolutionProtocol(string) && URN.isValidHTTPSpecifier(string);
    }

    private static final boolean isValidLength(String string) {
        int n = string.length();
        return n == 63 || n == 107;
    }

    private static final boolean isValidUriRes(String string) {
        int n = string.indexOf(SLASH);
        if (n == -1 || n == string.length()) {
            return false;
        }
        int n2 = string.indexOf(SLASH, n + 1);
        if (n2 == -1) {
            return false;
        }
        String string2 = string.substring(n + 1, n2);
        return string2.equalsIgnoreCase("uri-res");
    }

    private static boolean isValidResolutionProtocol(String string) {
        int n = string.indexOf(TWO);
        if (n == -1) {
            return false;
        }
        String string2 = string.substring(n - 1, n + 3);
        return string2.equalsIgnoreCase("N2R?") || string2.equalsIgnoreCase("N2X?");
    }

    private static boolean isValidHTTPSpecifier(String string) {
        int n = string.lastIndexOf(SPACE);
        if (n == -1) {
            return false;
        }
        String string2 = string.substring(n + 1);
        return string2.equalsIgnoreCase("HTTP/1.0") || string2.equalsIgnoreCase("HTTP/1.1");
    }

    private static String getTypeString(String string) throws IOException {
        String string2 = string.trim();
        if (string2.length() <= 4) {
            throw new IOException("no type string");
        }
        return string2.substring(0, string2.indexOf(58, 4) + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UrnSet createSHA1AndTTRootUrns(File file) throws IOException, InterruptedException {
        SHA1 sHA1 = new SHA1();
        MerkleTree merkleTree = new MerkleTree(new Tiger());
        byte[] byArray = threadLocal.get();
        AtomicInteger atomicInteger = new AtomicInteger(0);
        progressMap.put(file, atomicInteger);
        FileInputStream fileInputStream = null;
        try {
            int n;
            fileInputStream = new FileInputStream(file);
            while ((n = ((InputStream)fileInputStream).read(byArray)) != -1) {
                long l = System.nanoTime();
                sHA1.update(byArray, 0, n);
                merkleTree.update(byArray, 0, n);
                atomicInteger.addAndGet(n);
                if (SystemUtils.getIdleTime() >= 300000L || !SharingSettings.FRIENDLY_HASHING.getValue()) continue;
                long l2 = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - l);
                if (l2 > 0L) {
                    Thread.sleep(l2 * 3L);
                    continue;
                }
                Thread.yield();
            }
        }
        finally {
            progressMap.remove(file);
            IOUtils.close(fileInputStream);
        }
        UrnSet urnSet = new UrnSet();
        URN uRN = new URN("urn:" + Type.SHA1.getDescriptor() + Base32.encode(sHA1.digest()), Type.SHA1);
        URN uRN2 = new URN("urn:" + Type.TTROOT.getDescriptor() + Base32.encode(merkleTree.digest()), Type.TTROOT);
        urnSet.add(uRN);
        urnSet.add(uRN2);
        return urnSet;
    }

    private static boolean isValidUrn(String string) {
        int n = string.indexOf(":");
        if (n == -1 || n + 1 > string.length()) {
            return false;
        }
        int n2 = n - 3;
        int n3 = n + 1;
        if (n2 < 0 || n3 < 0) {
            return false;
        }
        int n4 = string.indexOf(":", n + 1);
        if (n4 == -1 || n4 + 1 > string.length()) {
            return false;
        }
        String string2 = string.substring(0, n4 + 1);
        Type type = Type.createUrnType(string2);
        if (type == null) {
            return false;
        }
        return type.getLength() == string.substring(n4 + 1).length();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeUTF(this._urnString);
        objectOutputStream.writeObject((Object)this._urnType);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this._urnString = objectInputStream.readUTF();
        Object object = objectInputStream.readObject();
        if (object instanceof UrnType) {
            object = Type.createFromDescriptor(((UrnType)object).getType());
        }
        this._urnType = (Type)((Object)object);
        if (this._urnType != Type.SHA1 && this._urnType != Type.TTROOT) {
            throw new InvalidObjectException("invalid urn type: " + object);
        }
        if (!URN.isValidUrn(this._urnString)) {
            throw new InvalidObjectException("invalid urn: " + this._urnString);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        SHA1("sha1:", 32),
        BITPRINT("bitprint:", 72),
        TTROOT("ttroot:", 39),
        ANY_TYPE("", -1),
        INVALID("Invalid", -1),
        GUID("guid:", 32);

        private final String descriptor;
        private final int length;
        public static final Set<Type> SHA1_SET;
        public static final Set<Type> ANY_TYPE_SET;
        public static final Set<Type> NO_TYPE_SET;
        public static final String URN_NAMESPACE_ID = "urn:";

        private Type(String string2, int n2) {
            this.descriptor = string2;
            this.length = n2;
        }

        public String getDescriptor() {
            return this.descriptor;
        }

        public int getLength() {
            return this.length;
        }

        public String toString() {
            return URN_NAMESPACE_ID + this.descriptor;
        }

        static Type createFromDescriptor(String string) {
            string = string.toLowerCase(Locale.US).trim();
            for (Type type : Type.values()) {
                if (!type.descriptor.equals(string)) continue;
                return type;
            }
            return null;
        }

        public static Type createUrnType(String string) {
            string = string.toLowerCase(Locale.US).trim();
            for (Type type : Type.values()) {
                if (!type.toString().equals(string)) continue;
                return type;
            }
            return null;
        }

        public static boolean isSupportedUrnType(String string) {
            return Type.createUrnType(string) != null;
        }

        static {
            SHA1_SET = EnumSet.of(SHA1);
            ANY_TYPE_SET = EnumSet.of(ANY_TYPE);
            NO_TYPE_SET = EnumSet.noneOf(Type.class);
        }
    }
}

