/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.gnutella.Acceptor;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.ConnectionServices;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.MessageDispatcher;
import com.limegroup.gnutella.MessageListener;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.QueryUnicaster;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.guess.GUESSEndpoint;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.MessageFactory;
import com.limegroup.gnutella.messages.PingReply;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.messages.PingRequestFactory;
import com.limegroup.gnutella.messages.vendor.ReplyNumberVendorMessage;
import com.limegroup.gnutella.settings.ConnectionSettings;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.inspection.Inspectable;
import org.limewire.inspection.InspectionPoint;
import org.limewire.io.ByteBufferOutputStream;
import org.limewire.io.IpPort;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.io.NetworkUtils;
import org.limewire.nio.NIODispatcher;
import org.limewire.nio.observer.ReadWriteObserver;
import org.limewire.security.AddressSecurityToken;
import org.limewire.security.MACCalculator;
import org.limewire.security.MACCalculatorRepositoryManager;
import org.limewire.service.ErrorService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class UDPService
implements ReadWriteObserver {
    private static final Log LOG = LogFactory.getLog(UDPService.class);
    private static final MACCalculator PING_GENERATOR = MACCalculatorRepositoryManager.createDefaultCalculatorFactory().createMACCalculator();
    private DatagramChannel _channel;
    private final List<SendBundle> OUTGOING_MSGS;
    private final ByteBuffer BUFFER;
    private final int BUFFER_SIZE = 2048;
    private volatile boolean _acceptedSolicitedIncoming = false;
    private volatile boolean _acceptedUnsolicitedIncoming = false;
    private long _lastUnsolicitedIncomingTime = 0L;
    private volatile long _lastReceivedAny = 0L;
    private long _lastConnectBackTime = System.currentTimeMillis();
    private boolean _portStable = true;
    private int _lastReportedPort;
    private int _numReceivedIPPongs;
    private final GUID CONNECT_BACK_GUID = new GUID(GUID.makeGuid());
    private final GUID SOLICITED_PING_GUID = new GUID(GUID.makeGuid());
    private boolean _started = false;
    private static final long PING_PERIOD = 85000L;
    private static final byte[] IN_HEADER_BUF = new byte[23];
    private final NetworkManager networkManager;
    private final Provider<MessageDispatcher> messageDispatcher;
    private final Provider<IPFilter> hostileFilter;
    private final Provider<ConnectionManager> connectionManager;
    private final Provider<MessageRouter> messageRouter;
    private final Provider<Acceptor> acceptor;
    private final Provider<QueryUnicaster> queryUnicaster;
    private final ScheduledExecutorService backgroundExecutor;
    private final ConnectionServices connectionServices;
    private final MessageFactory messageFactory;
    private final PingRequestFactory pingRequestFactory;
    private final NetworkInstanceUtils networkInstanceUtils;
    @InspectionPoint(value="udp sent messages")
    private final Message.MessageCounter sentMessageCounter = new Message.MessageCounter(50);
    @InspectionPoint(value="fwt capable")
    private final Inspectable fwtCapable = new Inspectable(){

        public Object inspect() {
            return UDPService.this.canDoFWT();
        }
    };

    void resetLastConnectBackTime() {
        this._lastConnectBackTime = System.currentTimeMillis() - ((Acceptor)this.acceptor.get()).getIncomingExpireTime();
    }

    @Inject
    public UDPService(NetworkManager networkManager, Provider<MessageDispatcher> provider, @Named(value="hostileFilter") Provider<IPFilter> provider2, Provider<ConnectionManager> provider3, Provider<MessageRouter> provider4, Provider<Acceptor> provider5, Provider<QueryUnicaster> provider6, @Named(value="backgroundExecutor") ScheduledExecutorService scheduledExecutorService, ConnectionServices connectionServices, MessageFactory messageFactory, PingRequestFactory pingRequestFactory, NetworkInstanceUtils networkInstanceUtils) {
        this.networkManager = networkManager;
        this.messageDispatcher = provider;
        this.hostileFilter = provider2;
        this.connectionManager = provider3;
        this.messageRouter = provider4;
        this.acceptor = provider5;
        this.queryUnicaster = provider6;
        this.backgroundExecutor = scheduledExecutorService;
        this.connectionServices = connectionServices;
        this.messageFactory = messageFactory;
        this.pingRequestFactory = pingRequestFactory;
        this.networkInstanceUtils = networkInstanceUtils;
        this.OUTGOING_MSGS = new LinkedList<SendBundle>();
        byte[] byArray = new byte[2048];
        this.BUFFER = ByteBuffer.wrap(byArray);
        this.scheduleServices();
    }

    protected void scheduleServices() {
        this.backgroundExecutor.scheduleWithFixedDelay(new IncomingValidator(), ((Acceptor)this.acceptor.get()).getTimeBetweenValidates(), ((Acceptor)this.acceptor.get()).getTimeBetweenValidates(), TimeUnit.MILLISECONDS);
        this.backgroundExecutor.scheduleWithFixedDelay(new PeriodicPinger(), 0L, 85000L, TimeUnit.MILLISECONDS);
    }

    public GUID getConnectBackGUID() {
        return this.CONNECT_BACK_GUID;
    }

    public GUID getSolicitedGUID() {
        return this.SOLICITED_PING_GUID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        DatagramChannel datagramChannel;
        UDPService uDPService = this;
        synchronized (uDPService) {
            this._started = true;
            datagramChannel = this._channel;
        }
        if (datagramChannel != null) {
            NIODispatcher.instance().registerReadWrite(datagramChannel, this);
        }
    }

    public DatagramSocket newListeningSocket(int n) throws IOException {
        try {
            DatagramChannel datagramChannel = DatagramChannel.open();
            datagramChannel.configureBlocking(false);
            DatagramSocket datagramSocket = datagramChannel.socket();
            datagramSocket.setReceiveBufferSize(65536);
            datagramSocket.setSendBufferSize(65536);
            datagramSocket.bind(new InetSocketAddress(n));
            return datagramSocket;
        }
        catch (SecurityException securityException) {
            throw new IOException("security exception on port: " + n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setListeningSocket(DatagramSocket datagramSocket) {
        if (this._channel != null) {
            try {
                this._channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (datagramSocket != null) {
            boolean bl;
            UDPService uDPService = this;
            synchronized (uDPService) {
                this._channel = datagramSocket.getChannel();
                if (this._channel == null) {
                    throw new IllegalArgumentException("No channel!");
                }
                bl = this._started;
                this._lastReportedPort = this._channel.socket().getLocalPort();
                this._portStable = true;
            }
            if (bl) {
                this.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getListeningPort() {
        UDPService uDPService = this;
        synchronized (uDPService) {
            if (this._channel != null) {
                return this._channel.socket().getLocalPort();
            }
            return -1;
        }
    }

    @Override
    public void shutdown() {
        this.setListeningSocket(null);
    }

    @Override
    public void handleRead() throws IOException {
        block8: while (true) {
            try {
                while (true) {
                    SocketAddress socketAddress;
                    this.BUFFER.clear();
                    try {
                        socketAddress = this._channel.receive(this.BUFFER);
                    }
                    catch (IOException iOException) {
                        break block8;
                    }
                    catch (Error error) {
                        break block8;
                    }
                    if (socketAddress == null) break block8;
                    if (!(socketAddress instanceof InetSocketAddress)) {
                        ErrorService.error(new RuntimeException("non-inet SocketAddress: " + socketAddress));
                        continue;
                    }
                    InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
                    if (!NetworkUtils.isValidAddress(inetSocketAddress.getAddress()) || !NetworkUtils.isValidPort(inetSocketAddress.getPort())) continue;
                    if (!((IPFilter)this.hostileFilter.get()).allow(inetSocketAddress.getAddress().getAddress())) {
                        return;
                    }
                    byte[] byArray = this.BUFFER.array();
                    int n = this.BUFFER.position();
                    try {
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, 0, n);
                        Message message = this.messageFactory.read((InputStream)byteArrayInputStream, Message.Network.UDP, IN_HEADER_BUF, inetSocketAddress);
                        if (message == null) continue;
                        this.processMessage(message, inetSocketAddress);
                        continue block8;
                    }
                    catch (IOException iOException) {
                        continue;
                    }
                    catch (BadPacketException badPacketException) {
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                ErrorService.error(throwable);
                break;
            }
        }
    }

    @Override
    public void handleIOException(IOException iOException) {
        if (!(iOException instanceof ClosedChannelException)) {
            ErrorService.error(iOException, "UDP Error.");
        } else {
            LOG.trace((Object)"Swallowing a UDPService ClosedChannelException", (Throwable)iOException);
        }
    }

    protected void processMessage(Message message, InetSocketAddress inetSocketAddress) {
        if (!((IPFilter)this.hostileFilter.get()).allow(message)) {
            return;
        }
        if (message instanceof PingReply) {
            UDPService.mutateGUID(message.getGUID(), inetSocketAddress.getAddress(), inetSocketAddress.getPort());
        }
        this.updateState(message, inetSocketAddress);
        ((MessageDispatcher)this.messageDispatcher.get()).dispatchUDP(message, inetSocketAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateState(Message message, InetSocketAddress inetSocketAddress) {
        this._lastReceivedAny = System.currentTimeMillis();
        if (this.isValidForIncoming(inetSocketAddress)) {
            this._acceptedSolicitedIncoming = true;
        }
        if (!this.isGUESSCapable()) {
            if (message instanceof PingRequest) {
                GUID gUID = new GUID(message.getGUID());
                if (this.CONNECT_BACK_GUID.equals(gUID) && this.isValidForIncoming(inetSocketAddress)) {
                    this._acceptedUnsolicitedIncoming = true;
                }
                this._lastUnsolicitedIncomingTime = this._lastReceivedAny;
            } else if (message instanceof PingReply) {
                GUID gUID = new GUID(message.getGUID());
                if (!this.SOLICITED_PING_GUID.equals(gUID) || !this.isValidForIncoming(inetSocketAddress)) {
                    return;
                }
                PingReply pingReply = (PingReply)message;
                if (pingReply.getMyPort() != 0) {
                    UDPService uDPService = this;
                    synchronized (uDPService) {
                        ++this._numReceivedIPPongs;
                        if (this._numReceivedIPPongs == 1) {
                            this._lastReportedPort = pingReply.getMyPort();
                        } else if (this._lastReportedPort != pingReply.getMyPort()) {
                            this._portStable = false;
                            this._lastReportedPort = pingReply.getMyPort();
                        }
                    }
                    this.updateFWTState();
                }
            }
        }
        if (message instanceof ReplyNumberVendorMessage) {
            this._lastUnsolicitedIncomingTime = this._lastReceivedAny;
        }
    }

    public static void mutateGUID(byte[] byArray, InetAddress inetAddress, int n) {
        byte[] byArray2 = PING_GENERATOR.getMACBytes(new AddressSecurityToken.AddressTokenData(inetAddress, n));
        for (int i = 0; i < byArray2.length; ++i) {
            byArray[i] = (byte)(byArray[i] ^ byArray2[i]);
        }
    }

    private boolean isValidForIncoming(InetSocketAddress inetSocketAddress) {
        String string = inetSocketAddress.getAddress().getHostAddress();
        return !((ConnectionManager)this.connectionManager.get()).isConnectedTo(string) && !this.networkInstanceUtils.isPrivateAddress(inetSocketAddress.getAddress());
    }

    public void send(Message message, IpPort ipPort) {
        this.send(message, ipPort.getInetSocketAddress());
    }

    public void send(Message message, InetAddress inetAddress, int n) {
        this.send(message, new InetSocketAddress(inetAddress, n));
    }

    public void send(Message message, InetSocketAddress inetSocketAddress) {
        if (message == null) {
            throw new IllegalArgumentException("Null Message");
        }
        if (!NetworkUtils.isValidSocketAddress(inetSocketAddress)) {
            throw new IllegalArgumentException("Invalid addr: " + inetSocketAddress);
        }
        if (this._channel == null || this._channel.socket().isClosed()) {
            return;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Sending message: " + message + "to " + inetSocketAddress));
        }
        int n = message.getTotalLength();
        ByteBuffer byteBuffer = NIODispatcher.instance().getBufferCache().getHeap(n);
        if (byteBuffer.remaining() != n) {
            throw new IllegalStateException("retrieved a buffer with wrong remaining! wanted: " + n + ", had: " + byteBuffer.remaining() + ", position: " + byteBuffer.position() + ", limit: " + byteBuffer.limit());
        }
        ByteBufferOutputStream byteBufferOutputStream = new ByteBufferOutputStream(byteBuffer);
        try {
            message.writeQuickly(byteBufferOutputStream);
        }
        catch (IOException iOException) {
            ErrorService.error(iOException);
            return;
        }
        byteBuffer.flip();
        if (message instanceof PingRequest) {
            UDPService.mutateGUID(byteBuffer.array(), inetSocketAddress.getAddress(), inetSocketAddress.getPort());
        }
        this.sentMessageCounter.countMessage(message);
        this.send(byteBuffer, inetSocketAddress, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(ByteBuffer byteBuffer, InetSocketAddress inetSocketAddress, boolean bl) {
        List<SendBundle> list = this.OUTGOING_MSGS;
        synchronized (list) {
            this.OUTGOING_MSGS.add(new SendBundle(byteBuffer, inetSocketAddress, bl));
            if (this._channel != null) {
                NIODispatcher.instance().interestWrite(this._channel, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean handleWrite() throws IOException {
        try {
            var1_1 = this.OUTGOING_MSGS;
            synchronized (var1_1) {
                while (true) lbl-1000:
                // 5 sources

                {
                    if (this.OUTGOING_MSGS.isEmpty()) {
                        NIODispatcher.instance().interestWrite(this._channel, false);
                        return false;
                    }
                    var2_3 = true;
                    var3_4 = this.OUTGOING_MSGS.remove(0);
                    try {
                        if (this._channel.send(SendBundle.access$100(var3_4), SendBundle.access$200(var3_4)) != 0) ** GOTO lbl-1000
                        this.OUTGOING_MSGS.add(0, var3_4);
                        var2_3 = false;
                        var4_6 = true;
                        return var4_6;
                    }
                    catch (IOException var4_5) {
                        UDPService.LOG.warn((Object)"Ignoring exception on socket", (Throwable)var4_5);
                    }
                    finally {
                        if (SendBundle.access$300(var3_4)) {
                            SendBundle.access$100(var3_4).rewind();
                            var2_3 = false;
                        }
                        if (!var2_3) ** GOTO lbl-1000
                        NIODispatcher.instance().getBufferCache().release(SendBundle.access$100(var3_4));
                        continue;
                    }
                    break;
                }
            }
        }
        catch (Throwable var1_2) {
            ErrorService.error(var1_2);
            return true;
        }
        ** GOTO lbl-1000
    }

    public boolean isGUESSCapable() {
        return this.canReceiveUnsolicited() && this.canReceiveSolicited();
    }

    public boolean canReceiveUnsolicited() {
        return this._acceptedUnsolicitedIncoming;
    }

    public boolean canReceiveSolicited() {
        return this._acceptedSolicitedIncoming;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canDoFWT() {
        boolean bl;
        if (!this.canReceiveSolicited()) {
            return false;
        }
        boolean bl2 = bl = !ConnectionSettings.LAST_FWT_STATE.getValue();
        if (!this.connectionServices.isConnected()) {
            return bl;
        }
        UDPService uDPService = this;
        synchronized (uDPService) {
            if (this._numReceivedIPPongs < 1) {
                return bl;
            }
        }
        this.updateFWTState();
        return !ConnectionSettings.LAST_FWT_STATE.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFWTState() {
        boolean bl = true;
        UDPService uDPService = this;
        synchronized (uDPService) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("stable " + this._portStable + " last reported port " + this._lastReportedPort + " our external port " + this.networkManager.getPort() + " our non-forced port " + ((Acceptor)this.acceptor.get()).getPort(false) + " number of received IP pongs " + this._numReceivedIPPongs + " valid external addr " + NetworkUtils.isValidAddress(this.networkManager.getExternalAddress())));
            }
            boolean bl2 = bl = NetworkUtils.isValidAddress(this.networkManager.getExternalAddress()) && this._portStable;
            if (this._numReceivedIPPongs == 1) {
                bl = bl && (this._lastReportedPort == ((Acceptor)this.acceptor.get()).getPort(false) || this._lastReportedPort == this.networkManager.getPort());
            }
        }
        ConnectionSettings.LAST_FWT_STATE.setValue(!bl);
    }

    public boolean portStable() {
        return this._portStable;
    }

    public int receivedIpPong() {
        return this._numReceivedIPPongs;
    }

    public int lastReportedPort() {
        return this._lastReportedPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStableUDPPort() {
        int n = ((Acceptor)this.acceptor.get()).getPort(false);
        int n2 = this.networkManager.getPort();
        UDPService uDPService = this;
        synchronized (uDPService) {
            if (this._portStable && this._numReceivedIPPongs > 1) {
                return this._lastReportedPort;
            }
            if (this._numReceivedIPPongs == 1 && (n == this._lastReportedPort || n2 == this._lastReportedPort)) {
                return this._lastReportedPort;
            }
        }
        return n2;
    }

    public void setReceiveSolicited(boolean bl) {
        this._acceptedSolicitedIncoming = bl;
    }

    public long getLastReceivedTime() {
        return this._lastReceivedAny;
    }

    public boolean isListening() {
        if (this._channel == null) {
            return false;
        }
        return this._channel.socket().getLocalPort() != -1;
    }

    public String toString() {
        return "UDPService::channel: " + this._channel;
    }

    private class PeriodicPinger
    implements Runnable {
        private PeriodicPinger() {
        }

        public void run() {
            GUESSEndpoint gUESSEndpoint = ((QueryUnicaster)UDPService.this.queryUnicaster.get()).getUnicastEndpoint();
            if (gUESSEndpoint == null) {
                return;
            }
            if (!UDPService.this.canReceiveSolicited() && !UDPService.this.canReceiveUnsolicited()) {
                return;
            }
            PingRequest pingRequest = UDPService.this.pingRequestFactory.createPingRequest(UDPService.this.getSolicitedGUID().bytes(), (byte)1, (byte)0);
            pingRequest.addIPRequest();
            UDPService.this.send(pingRequest, gUESSEndpoint.getInetAddress(), gUESSEndpoint.getPort());
        }
    }

    private class IncomingValidator
    implements Runnable {
        public void run() {
            final long l = System.currentTimeMillis();
            if (UDPService.this._acceptedUnsolicitedIncoming && l - UDPService.this._lastUnsolicitedIncomingTime > ((Acceptor)UDPService.this.acceptor.get()).getIncomingExpireTime() || !UDPService.this._acceptedUnsolicitedIncoming && l - UDPService.this._lastConnectBackTime > ((Acceptor)UDPService.this.acceptor.get()).getIncomingExpireTime()) {
                final GUID gUID = new GUID(GUID.makeGuid());
                final MLImpl mLImpl = new MLImpl();
                ((MessageRouter)UDPService.this.messageRouter.get()).registerMessageListener(gUID.bytes(), mLImpl);
                if (((ConnectionManager)UDPService.this.connectionManager.get()).sendUDPConnectBackRequests(gUID)) {
                    UDPService.this._lastConnectBackTime = System.currentTimeMillis();
                    Runnable runnable = new Runnable(){

                        public void run() {
                            if (UDPService.this._acceptedUnsolicitedIncoming && UDPService.this._lastUnsolicitedIncomingTime < l || !UDPService.this._acceptedUnsolicitedIncoming) {
                                UDPService.this._acceptedUnsolicitedIncoming = mLImpl._gotIncoming;
                            }
                            ((MessageRouter)UDPService.this.messageRouter.get()).unregisterMessageListener(gUID.bytes(), mLImpl);
                        }
                    };
                    UDPService.this.backgroundExecutor.schedule(runnable, ((Acceptor)UDPService.this.acceptor.get()).getWaitTimeAfterRequests(), TimeUnit.MILLISECONDS);
                } else {
                    ((MessageRouter)UDPService.this.messageRouter.get()).unregisterMessageListener(gUID.bytes(), mLImpl);
                }
            }
        }
    }

    private static class MLImpl
    implements MessageListener {
        public boolean _gotIncoming = false;

        private MLImpl() {
        }

        public void processMessage(Message message, ReplyHandler replyHandler) {
            if (message instanceof PingRequest) {
                this._gotIncoming = true;
            }
        }

        public void registered(byte[] byArray) {
        }

        public void unregistered(byte[] byArray) {
        }
    }

    private static class SendBundle {
        private final ByteBuffer buffer;
        private final SocketAddress addr;
        private final boolean custom;

        SendBundle(ByteBuffer byteBuffer, InetSocketAddress inetSocketAddress, boolean bl) {
            this.buffer = byteBuffer;
            this.addr = inetSocketAddress;
            this.custom = bl;
        }

        static /* synthetic */ ByteBuffer access$100(SendBundle sendBundle) {
            return sendBundle.buffer;
        }

        static /* synthetic */ SocketAddress access$200(SendBundle sendBundle) {
            return sendBundle.addr;
        }

        static /* synthetic */ boolean access$300(SendBundle sendBundle) {
            return sendBundle.custom;
        }
    }
}

