/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.UDPReplyHandler;
import com.limegroup.gnutella.UDPReplyHandlerCache;
import com.limegroup.gnutella.UDPReplyHandlerFactory;
import com.limegroup.gnutella.filters.SpamFilter;
import com.limegroup.gnutella.filters.SpamFilterFactory;
import java.net.InetSocketAddress;
import org.limewire.collection.FixedsizeForgetfulHashMap;
import org.limewire.concurrent.AbstractLazySingletonProvider;
import org.limewire.inject.Providers;

@Singleton
public class UDPReplyHandlerCacheImpl
implements UDPReplyHandlerCache {
    private final UDPReplyHandlerFactory udpReplyHandlerFactory;
    private volatile Provider<SpamFilter> personalFilter;
    private final FixedsizeForgetfulHashMap<InetSocketAddress, UDPReplyHandler> udpReplyHandlerCache = new FixedsizeForgetfulHashMap(500);

    @Inject
    public UDPReplyHandlerCacheImpl(UDPReplyHandlerFactory uDPReplyHandlerFactory, final SpamFilterFactory spamFilterFactory) {
        this.udpReplyHandlerFactory = uDPReplyHandlerFactory;
        this.personalFilter = new AbstractLazySingletonProvider<SpamFilter>(){

            @Override
            protected SpamFilter createObject() {
                return spamFilterFactory.createPersonalFilter();
            }
        };
    }

    public synchronized UDPReplyHandler getUDPReplyHandler(InetSocketAddress inetSocketAddress) {
        UDPReplyHandler uDPReplyHandler = (UDPReplyHandler)this.udpReplyHandlerCache.get(inetSocketAddress);
        if (uDPReplyHandler == null) {
            uDPReplyHandler = this.udpReplyHandlerFactory.createUDPReplyHandler(inetSocketAddress, (SpamFilter)this.personalFilter.get());
            this.udpReplyHandlerCache.put(inetSocketAddress, uDPReplyHandler);
        }
        return uDPReplyHandler;
    }

    public synchronized void setPersonalFilter(SpamFilter spamFilter) {
        if (spamFilter == null) {
            throw new NullPointerException("personalFiter must not be null");
        }
        this.personalFilter = Providers.of(spamFilter);
        this.clear();
    }

    public SpamFilter getPersonalFilter() {
        return (SpamFilter)this.personalFilter.get();
    }

    public synchronized void clear() {
        this.udpReplyHandlerCache.clear();
    }
}

