/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import com.limegroup.gnutella.MessageListener;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.UDPPinger;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingRequestFactory;
import java.net.InetAddress;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.Cancellable;
import org.limewire.concurrent.ExecutorsHelper;
import org.limewire.io.IpPort;
import org.limewire.io.NetworkUtils;
import org.limewire.service.ErrorService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UDPPingerImpl
implements UDPPinger {
    private static final Log LOG = LogFactory.getLog(UDPPingerImpl.class);
    protected static final ExecutorService QUEUE = ExecutorsHelper.newProcessingQueue("UDPHostRanker");
    public static int DEFAULT_LISTEN_EXPIRE_TIME = 20000;
    private static final long SEND_INTERVAL = 500L;
    private static final int MAX_SENDS = 15;
    private static int _sentAmount;
    private static long _lastSentTime;
    private final Provider<MessageRouter> messageRouter;
    private final ScheduledExecutorService backgroundExecutor;
    private final Provider<UDPService> udpService;
    private final PingRequestFactory pingRequestFactory;

    @Inject
    public UDPPingerImpl(Provider<MessageRouter> provider, @Named(value="backgroundExecutor") ScheduledExecutorService scheduledExecutorService, Provider<UDPService> provider2, PingRequestFactory pingRequestFactory) {
        this.messageRouter = provider;
        this.backgroundExecutor = scheduledExecutorService;
        this.udpService = provider2;
        this.pingRequestFactory = pingRequestFactory;
    }

    @Override
    public void rank(Collection<? extends IpPort> collection) {
        this.rank(collection, null, null, null);
    }

    @Override
    public void rank(Collection<? extends IpPort> collection, Message message) {
        this.rank(collection, null, null, message);
    }

    @Override
    public void rank(Collection<? extends IpPort> collection, Cancellable cancellable) {
        this.rank(collection, null, cancellable, null);
    }

    @Override
    public void rank(Collection<? extends IpPort> collection, MessageListener messageListener) {
        this.rank(collection, messageListener, null, null);
    }

    @Override
    public void rank(Collection<? extends IpPort> collection, MessageListener messageListener, Cancellable cancellable) {
        this.rank(collection, messageListener, cancellable, null);
    }

    @Override
    public void rank(Collection<? extends IpPort> collection, MessageListener messageListener, Cancellable cancellable, Message message) {
        this.rank(collection, messageListener, cancellable, message, -1);
    }

    @Override
    public void rank(Collection<? extends IpPort> collection, MessageListener messageListener, Cancellable cancellable, Message message, int n) {
        if (collection == null) {
            throw new NullPointerException("null hosts not allowed");
        }
        if (cancellable == null) {
            cancellable = new Cancellable(){

                public boolean isCancelled() {
                    return false;
                }
            };
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Adding hosts " + collection + " with message: " + message + " to processing queue"));
        }
        SenderBundle senderBundle = n > 0 ? new SenderBundle(collection, messageListener, cancellable, message, n) : new SenderBundle(collection, messageListener, cancellable, message, DEFAULT_LISTEN_EXPIRE_TIME);
        senderBundle.validateHosts();
        QUEUE.execute(senderBundle);
    }

    private boolean waitForListening(Cancellable cancellable) {
        int n;
        for (n = 0; !((UDPService)this.udpService.get()).isListening() && n < 10 && !cancellable.isCancelled(); ++n) {
            try {
                Thread.sleep(600L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                ErrorService.error(interruptedException);
            }
        }
        return n < 10;
    }

    protected void send(Collection<? extends IpPort> collection, final MessageListener messageListener, Cancellable cancellable, Message message, int n) {
        if (!this.waitForListening(cancellable)) {
            return;
        }
        if (message == null) {
            message = this.pingRequestFactory.createUDPPing();
        }
        final byte[] byArray = message.getGUID();
        if (messageListener != null) {
            ((MessageRouter)this.messageRouter.get()).registerMessageListener(byArray, messageListener);
        }
        for (IpPort ipPort : collection) {
            if (cancellable.isCancelled()) break;
            this.sendSingleMessage(ipPort, message);
        }
        if (messageListener != null) {
            Runnable runnable = new Runnable(){

                public void run() {
                    ((MessageRouter)UDPPingerImpl.this.messageRouter.get()).unregisterMessageListener(byArray, messageListener);
                }
            };
            this.backgroundExecutor.schedule(runnable, (long)n, TimeUnit.MILLISECONDS);
        }
    }

    protected void sendSingleMessage(IpPort ipPort, Message message) {
        long l = System.currentTimeMillis();
        if (l > _lastSentTime + 500L) {
            _sentAmount = 0;
        } else if (_sentAmount == 15) {
            try {
                Thread.sleep(500L);
                l = System.currentTimeMillis();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            _sentAmount = 0;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Sending to " + ipPort + ": " + message.getClass() + " " + message));
        }
        ((UDPService)this.udpService.get()).send(message, ipPort);
        ++_sentAmount;
        _lastSentTime = l;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SenderBundle
    implements Runnable {
        private final Collection<? extends IpPort> hosts;
        private final MessageListener listener;
        private final Cancellable canceller;
        private final Message message;
        private final int expireTime;

        public SenderBundle(Collection<? extends IpPort> collection, MessageListener messageListener, Cancellable cancellable, Message message, int n) {
            this.hosts = collection;
            this.listener = messageListener;
            this.canceller = cancellable;
            this.message = message;
            this.expireTime = n;
        }

        @Override
        public void run() {
            UDPPingerImpl.this.send(this.hosts, this.listener, this.canceller, this.message, this.expireTime);
        }

        void validateHosts() {
            for (IpPort ipPort : this.hosts) {
                InetAddress inetAddress = ipPort.getInetAddress();
                if (!(inetAddress != null ? !NetworkUtils.isValidAddressAndPort(inetAddress.getAddress(), ipPort.getPort()) : !NetworkUtils.isValidIpPort(ipPort))) continue;
                throw new IllegalArgumentException("invalid host: " + ipPort);
            }
        }
    }
}

