/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.AbstractPushEndpoint;
import com.limegroup.gnutella.ApplicationServices;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.PushEndpoint;
import com.limegroup.gnutella.PushEndpointCache;
import com.limegroup.gnutella.PushEndpointImpl;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Set;
import org.limewire.io.IpPort;
import org.limewire.io.IpPortImpl;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.io.NetworkUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class SelfEndpoint
extends AbstractPushEndpoint {
    private final NetworkManager networkManager;
    private final Provider<ConnectionManager> connectionManager;
    private final ApplicationServices applicationServices;
    private final PushEndpointCache pushEndpointCache;
    private final NetworkInstanceUtils networkInstanceUtils;

    @Inject
    SelfEndpoint(NetworkManager networkManager, ApplicationServices applicationServices, Provider<ConnectionManager> provider, PushEndpointCache pushEndpointCache, NetworkInstanceUtils networkInstanceUtils) {
        this.networkManager = networkManager;
        this.applicationServices = applicationServices;
        this.connectionManager = provider;
        this.pushEndpointCache = pushEndpointCache;
        this.networkInstanceUtils = networkInstanceUtils;
    }

    @Override
    public Set<? extends IpPort> getProxies() {
        return ((ConnectionManager)this.connectionManager.get()).getPushProxies();
    }

    @Override
    public byte getFeatures() {
        return 0;
    }

    @Override
    public int getFWTVersion() {
        return this.networkManager.supportsFWTVersion();
    }

    @Override
    public String getAddress() {
        byte[] byArray = this.networkManager.getExternalAddress();
        if (NetworkUtils.isValidAddress(byArray) && !this.networkInstanceUtils.isPrivateAddress(byArray)) {
            return NetworkUtils.ip2string(byArray);
        }
        return "1.1.1.1";
    }

    @Override
    public InetAddress getInetAddress() {
        try {
            return InetAddress.getByName(this.getAddress());
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    @Override
    public int getPort() {
        if (this.networkManager.canDoFWT() && !this.networkManager.acceptedIncomingConnection()) {
            return this.networkManager.getStableUDPPort();
        }
        return this.networkManager.getPort();
    }

    @Override
    public IpPort getValidExternalAddress() {
        try {
            String string = this.getAddress();
            int n = this.getPort();
            if (string.equals("1.1.1.1") || !NetworkUtils.isValidPort(n)) {
                return null;
            }
            return new IpPortImpl(string, this.getPort());
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public PushEndpoint createClone() {
        return new PushEndpointImpl(this.getClientGUID(), this.getProxies(), this.getFeatures(), this.getFWTVersion(), this.getValidExternalAddress(), this.pushEndpointCache, this.networkInstanceUtils);
    }

    @Override
    public byte[] getClientGUID() {
        return this.applicationServices.getMyGUID();
    }

    @Override
    public void updateProxies(boolean bl) {
    }

    @Override
    public InetSocketAddress getInetSocketAddress() {
        IpPort ipPort = this.getValidExternalAddress();
        if (ipPort != null) {
            return ipPort.getInetSocketAddress();
        }
        return null;
    }
}

