/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.BrowseHostHandler;
import com.limegroup.gnutella.BrowseHostHandlerManager;
import com.limegroup.gnutella.ConnectionServices;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.QueryUnicaster;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.ResponseVerifier;
import com.limegroup.gnutella.SearchServices;
import com.limegroup.gnutella.filters.MutableGUIDFilter;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.messages.QueryRequestFactory;
import com.limegroup.gnutella.search.QueryDispatcher;
import com.limegroup.gnutella.search.SearchResultHandler;
import com.limegroup.gnutella.settings.FilterSettings;
import com.limegroup.gnutella.settings.MessageSettings;
import com.limegroup.gnutella.statistics.OutOfBandStatistics;
import com.limegroup.gnutella.statistics.QueryStats;
import java.util.Set;
import org.limewire.concurrent.ThreadExecutor;
import org.limewire.io.Connectable;
import org.limewire.io.IpPort;
import org.limewire.util.DebugRunnable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class SearchServicesImpl
implements SearchServices {
    private final Provider<ResponseVerifier> responseVerifier;
    private final Provider<QueryUnicaster> queryUnicaster;
    private final Provider<SearchResultHandler> searchResultHandler;
    private final Provider<MessageRouter> messageRouter;
    private final Provider<ConnectionServices> connectionServices;
    private final Provider<QueryDispatcher> queryDispatcher;
    private final Provider<MutableGUIDFilter> mutableGUIDFilter;
    private final Provider<QueryStats> queryStats;
    private final Provider<NetworkManager> networkManager;
    private final Provider<QueryRequestFactory> queryRequestFactory;
    private final BrowseHostHandlerManager browseHostHandlerManager;
    private final OutOfBandStatistics outOfBandStatistics;

    @Inject
    public SearchServicesImpl(Provider<ResponseVerifier> provider, Provider<QueryUnicaster> provider2, Provider<SearchResultHandler> provider3, Provider<MessageRouter> provider4, Provider<ConnectionServices> provider5, Provider<QueryDispatcher> provider6, Provider<MutableGUIDFilter> provider7, Provider<QueryStats> provider8, Provider<NetworkManager> provider9, Provider<QueryRequestFactory> provider10, BrowseHostHandlerManager browseHostHandlerManager, OutOfBandStatistics outOfBandStatistics) {
        this.responseVerifier = provider;
        this.queryUnicaster = provider2;
        this.searchResultHandler = provider3;
        this.messageRouter = provider4;
        this.connectionServices = provider5;
        this.queryDispatcher = provider6;
        this.mutableGUIDFilter = provider7;
        this.queryStats = provider8;
        this.networkManager = provider9;
        this.queryRequestFactory = provider10;
        this.browseHostHandlerManager = browseHostHandlerManager;
        this.outOfBandStatistics = outOfBandStatistics;
    }

    @Override
    public BrowseHostHandler doAsynchronousBrowseHost(final Connectable connectable, GUID gUID, GUID gUID2, final Set<? extends IpPort> set, final boolean bl) {
        final BrowseHostHandler browseHostHandler = this.browseHostHandlerManager.createBrowseHostHandler(gUID, gUID2);
        ThreadExecutor.startThread(new DebugRunnable(new Runnable(){

            public void run() {
                browseHostHandler.browseHost(connectable, set, bl);
            }
        }), "BrowseHoster");
        return browseHostHandler;
    }

    @Override
    public boolean isMandragoreWorm(byte[] byArray, Response response) {
        return ((ResponseVerifier)this.responseVerifier.get()).isMandragoreWorm(byArray, response);
    }

    @Override
    public boolean matchesQuery(byte[] byArray, Response response) {
        return ((ResponseVerifier)this.responseVerifier.get()).matchesQuery(byArray, response);
    }

    @Override
    public boolean matchesType(byte[] byArray, Response response) {
        return ((ResponseVerifier)this.responseVerifier.get()).matchesType(byArray, response);
    }

    @Override
    public void stopQuery(GUID gUID) {
        ((QueryUnicaster)this.queryUnicaster.get()).purgeQuery(gUID);
        ((SearchResultHandler)this.searchResultHandler.get()).removeQuery(gUID);
        ((MessageRouter)this.messageRouter.get()).queryKilled(gUID);
        if (((ConnectionServices)this.connectionServices.get()).isSupernode()) {
            ((QueryDispatcher)this.queryDispatcher.get()).addToRemove(gUID);
        }
        ((MutableGUIDFilter)this.mutableGUIDFilter.get()).removeGUID(gUID.bytes());
    }

    @Override
    public long getLastQueryTime() {
        return ((QueryStats)this.queryStats.get()).getLastQueryTime();
    }

    private void recordAndSendQuery(QueryRequest queryRequest, MediaType mediaType) {
        ((QueryStats)this.queryStats.get()).recordQuery();
        ((ResponseVerifier)this.responseVerifier.get()).record(queryRequest, mediaType);
        ((SearchResultHandler)this.searchResultHandler.get()).addQuery(queryRequest);
        ((MessageRouter)this.messageRouter.get()).sendDynamicQuery(queryRequest);
    }

    @Override
    public void queryWhatIsNew(byte[] byArray, MediaType mediaType) {
        QueryRequest queryRequest = null;
        if (GUID.addressesMatch(byArray, ((NetworkManager)this.networkManager.get()).getAddress(), ((NetworkManager)this.networkManager.get()).getPort())) {
            queryRequest = ((QueryRequestFactory)this.queryRequestFactory.get()).createWhatIsNewOOBQuery(byArray, (byte)2, mediaType);
            this.outOfBandStatistics.addSentQuery();
        } else {
            queryRequest = ((QueryRequestFactory)this.queryRequestFactory.get()).createWhatIsNewQuery(byArray, (byte)2, mediaType);
        }
        if (FilterSettings.FILTER_WHATS_NEW_ADULT.getValue()) {
            ((MutableGUIDFilter)this.mutableGUIDFilter.get()).addGUID(byArray);
        }
        this.recordAndSendQuery(queryRequest, mediaType);
    }

    @Override
    public void query(byte[] byArray, String string, String string2, MediaType mediaType) {
        QueryRequest queryRequest = null;
        if (((NetworkManager)this.networkManager.get()).isIpPortValid() && new GUID(byArray).addressesMatch(((NetworkManager)this.networkManager.get()).getAddress(), ((NetworkManager)this.networkManager.get()).getPort())) {
            queryRequest = ((QueryRequestFactory)this.queryRequestFactory.get()).createOutOfBandQuery(byArray, string, string2, mediaType);
            this.outOfBandStatistics.addSentQuery();
        } else {
            queryRequest = ((QueryRequestFactory)this.queryRequestFactory.get()).createQuery(byArray, string, string2, mediaType);
        }
        this.recordAndSendQuery(queryRequest, mediaType);
    }

    @Override
    public void query(byte[] byArray, String string) {
        this.query(byArray, string, null);
    }

    @Override
    public void query(byte[] byArray, String string, MediaType mediaType) {
        this.query(byArray, string, "", mediaType);
    }

    @Override
    public byte[] newQueryGUID() {
        byte[] byArray = ((NetworkManager)this.networkManager.get()).isOOBCapable() && this.outOfBandStatistics.isOOBEffectiveForMe() ? GUID.makeAddressEncodedGuid(((NetworkManager)this.networkManager.get()).getAddress(), ((NetworkManager)this.networkManager.get()).getPort()) : GUID.makeGuid();
        if (MessageSettings.STAMP_QUERIES.getValue()) {
            GUID.timeStampGuid(byArray);
        }
        return byArray;
    }
}

