/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.UrnCache;
import com.limegroup.gnutella.UrnCallback;
import com.limegroup.gnutella.settings.SharingSettings;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.Comparators;
import org.limewire.concurrent.ExecutorsHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public final class SavedFileManager
implements Runnable {
    private static final Log LOG = LogFactory.getLog(SavedFileManager.class);
    private static final ExecutorService QUEUE = ExecutorsHelper.newProcessingQueue("SavedFileLoader");
    private final UrnCache urnCache;
    private Set<URN> _urns = new HashSet<URN>();
    private Set<String> _names = new TreeSet<String>(Comparators.caseInsensitiveStringComparator());

    @Inject
    SavedFileManager(UrnCache urnCache, @Named(value="backgroundExecutor") ScheduledExecutorService scheduledExecutorService) {
        this.urnCache = urnCache;
        scheduledExecutorService.scheduleWithFixedDelay(this, 10000L, 180000L, TimeUnit.MILLISECONDS);
    }

    public synchronized void addSavedFile(File file, Set<? extends URN> set) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Adding: " + file + " with: " + set));
        }
        this._names.add(file.getName());
        for (URN uRN : set) {
            this._urns.add(uRN);
        }
    }

    public synchronized boolean isSaved(URN uRN, String string) {
        return uRN != null && this._urns.contains(uRN) || this._names.contains(string);
    }

    @Override
    public void run() {
        QUEUE.execute(new Runnable(){

            public void run() {
                SavedFileManager.this.load();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        LOG.trace((Object)"Loading Saved Files");
        HashSet hashSet = new HashSet();
        TreeSet<String> treeSet = new TreeSet<String>(Comparators.caseInsensitiveStringComparator());
        UrnCallback urnCallback = new UrnCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void urnsCalculated(File file, Set<? extends URN> set) {
                SavedFileManager savedFileManager = SavedFileManager.this;
                synchronized (savedFileManager) {
                    SavedFileManager.this._urns.addAll(set);
                }
            }

            @Override
            public boolean isOwner(Object object) {
                return object == SavedFileManager.this;
            }
        };
        Set<File> set = SharingSettings.getAllSaveDirectories();
        for (File file : set) {
            this.loadDirectory(file, hashSet, treeSet, urnCallback);
        }
        SavedFileManager savedFileManager = this;
        synchronized (savedFileManager) {
            this._urns.addAll(hashSet);
            this._names.addAll(treeSet);
        }
    }

    private void loadDirectory(File file, Set<? super URN> set, Set<String> set2, UrnCallback urnCallback) {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (!file2.isFile() || !file2.exists()) continue;
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Loading: " + file2));
            }
            set2.add(file2.getName());
            Set<URN> set3 = this.urnCache.getUrns(file2);
            if (set3.isEmpty()) {
                this.urnCache.calculateAndCacheUrns(file2, urnCallback);
                continue;
            }
            set.addAll(set3);
        }
    }
}

