/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.CreationTimeCache;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.IncompleteFileDesc;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.ResponseFactory;
import com.limegroup.gnutella.ResponseImpl;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.altlocs.AltLocManager;
import com.limegroup.gnutella.altlocs.AlternateLocationCollection;
import com.limegroup.gnutella.altlocs.DirectAltLoc;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.messages.HUGEExtension;
import com.limegroup.gnutella.messages.IntervalEncoder;
import com.limegroup.gnutella.settings.MessageSettings;
import com.limegroup.gnutella.uploader.HTTPHeaderUtils;
import com.limegroup.gnutella.util.DataUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLDocumentFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import org.limewire.collection.BitNumbers;
import org.limewire.collection.IntervalSet;
import org.limewire.io.BadGGEPPropertyException;
import org.limewire.io.ConnectableImpl;
import org.limewire.io.GGEP;
import org.limewire.io.InvalidDataException;
import org.limewire.io.IpPort;
import org.limewire.io.IpPortSet;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.io.NetworkUtils;
import org.limewire.service.ErrorService;
import org.limewire.util.ByteUtils;
import org.limewire.util.NameValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class ResponseFactoryImpl
implements ResponseFactory {
    private static final int MAX_LOCATIONS = 10;
    private static final byte EXT_SEPARATOR = 28;
    private static final String KBPS = "kbps";
    private static final String KHZ = "kHz";
    private final AltLocManager altLocManager;
    private final Provider<CreationTimeCache> creationTimeCache;
    private final IPFilter ipFilter;
    private final NetworkInstanceUtils networkInstanceUtils;
    private final LimeXMLDocumentFactory limeXMLDocumentFactory;

    @Inject
    public ResponseFactoryImpl(AltLocManager altLocManager, Provider<CreationTimeCache> provider, IPFilter iPFilter, LimeXMLDocumentFactory limeXMLDocumentFactory, NetworkInstanceUtils networkInstanceUtils) {
        this.altLocManager = altLocManager;
        this.creationTimeCache = provider;
        this.ipFilter = iPFilter;
        this.limeXMLDocumentFactory = limeXMLDocumentFactory;
        this.networkInstanceUtils = networkInstanceUtils;
    }

    @Override
    public Response createResponse(long l, long l2, String string) {
        return this.createResponse(l, l2, string, -1, null, null, null, null);
    }

    @Override
    public Response createResponse(long l, long l2, String string, LimeXMLDocument limeXMLDocument) {
        return this.createResponse(l, l2, string, -1, null, limeXMLDocument, null, null);
    }

    @Override
    public Response createResponse(FileDesc fileDesc) {
        Object object;
        IntervalSet intervalSet = null;
        boolean bl = false;
        if (fileDesc instanceof IncompleteFileDesc) {
            object = (IncompleteFileDesc)fileDesc;
            intervalSet = new IntervalSet();
            bl = ((IncompleteFileDesc)object).loadResponseRanges(intervalSet);
        }
        object = new GGEPContainer(this.getAsIpPorts(this.altLocManager.getDirect(fileDesc.getSHA1Urn())), ((CreationTimeCache)this.creationTimeCache.get()).getCreationTimeAsLong(fileDesc.getSHA1Urn()), fileDesc.getFileSize(), intervalSet, bl, fileDesc.getTTROOTUrn());
        return this.createResponse(fileDesc.getIndex(), fileDesc.getFileSize(), fileDesc.getFileName(), -1, fileDesc.getUrns(), null, (GGEPContainer)object, null);
    }

    @Override
    public Response createFromStream(InputStream inputStream) throws IOException {
        String string;
        int n;
        long l = ByteUtils.uint2long(ByteUtils.leb2int(inputStream));
        long l2 = ByteUtils.uint2long(ByteUtils.leb2int(inputStream));
        if ((l & 0xFFFFFFFF00000000L) != 0L) {
            throw new IOException("invalid index: " + l);
        }
        if (l2 < 0L) {
            throw new IOException("invalid size: " + l2);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = inputStream.read()) != 0) {
            if (n == -1) {
                throw new IOException("EOF before null termination");
            }
            byteArrayOutputStream.write(n);
        }
        int n2 = byteArrayOutputStream.size();
        String string2 = new String(byteArrayOutputStream.toByteArray(), "UTF-8");
        this.checkFilename(string2);
        byteArrayOutputStream.reset();
        while ((n = inputStream.read()) != 0) {
            if (n == -1) {
                throw new IOException("EOF before null termination");
            }
            byteArrayOutputStream.write(n);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        if (byArray.length == 0) {
            if (inputStream.available() < 16) {
                throw new IOException("not enough room for the GUID");
            }
            return this.createResponse(l, l2, string2, n2, null, null, null, null);
        }
        HUGEExtension hUGEExtension = new HUGEExtension(byArray);
        Set<URN> set = hUGEExtension.getURNS();
        LimeXMLDocument limeXMLDocument = null;
        Object object = hUGEExtension.getMiscBlocks().iterator();
        while (object.hasNext() && (limeXMLDocument = this.createXmlDocument(string2, string = object.next())) == null) {
        }
        object = this.getGGEP(hUGEExtension.getGGEP(), l2);
        if (((GGEPContainer)object).size64 > 0xFFFFFFFFFFL) {
            throw new IOException(" file too large " + ((GGEPContainer)object).size64);
        }
        if (((GGEPContainer)object).size64 > Integer.MAX_VALUE) {
            l2 = ((GGEPContainer)object).size64;
        }
        return this.createResponse(l, l2, string2, n2, set, limeXMLDocument, (GGEPContainer)object, byArray);
    }

    public Response createResponse(long l, long l2, String string, int n, Set<? extends URN> set, LimeXMLDocument limeXMLDocument, GGEPContainer gGEPContainer, byte[] byArray) {
        if (gGEPContainer == null) {
            gGEPContainer = l2 <= Integer.MAX_VALUE ? GGEPContainer.EMPTY : new GGEPContainer(null, -1L, l2, null, false, null);
        }
        if (byArray == null) {
            byArray = this.createExtBytes(set, gGEPContainer, l2);
        }
        return new ResponseImpl(l, l2, string, n, set, limeXMLDocument, gGEPContainer.locations, gGEPContainer.createTime, byArray, gGEPContainer.ranges, gGEPContainer.verified);
    }

    private void checkFilename(String string) throws IOException {
        if (string.length() == 0) {
            throw new IOException("empty name in response");
        }
        if (string.indexOf(47) != -1 || string.indexOf(10) != -1 || string.indexOf(13) != -1) {
            throw new IOException("Illegal filename " + string + "contains one of [/\\n\\r]");
        }
    }

    private LimeXMLDocument createXmlDocument(String string, String string2) {
        int n;
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        if (stringTokenizer.countTokens() < 2) {
            return null;
        }
        String string3 = stringTokenizer.nextToken();
        String string4 = stringTokenizer.nextToken();
        assert (string3 != null);
        assert (string4 != null);
        string3 = string3.toLowerCase(Locale.US);
        string4 = string4.toLowerCase(Locale.US);
        String string5 = "";
        String string6 = "";
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (string4.startsWith(KBPS)) {
            bl = true;
        } else if (string3.endsWith(KBPS)) {
            bl2 = true;
        }
        if (bl) {
            string6 = string3;
        } else if (bl2) {
            n = string3.indexOf(KBPS);
            string6 = string3.substring(0, n);
        }
        if (bl || bl2) {
            while (stringTokenizer.hasMoreTokens()) {
                string5 = stringTokenizer.nextToken();
            }
        } else if (string2.endsWith(KHZ)) {
            bl3 = true;
            string5 = string3;
            n = string4.indexOf(KBPS);
            if (n > -1) {
                string6 = string4.substring(0, n);
            } else {
                bl3 = false;
            }
        }
        try {
            Integer.parseInt(string6);
            Integer.parseInt(string5);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        if (bl || bl2 || bl3) {
            ArrayList<NameValue<String>> arrayList = new ArrayList<NameValue<String>>(3);
            arrayList.add(new NameValue<String>("audios__audio__title__", string));
            arrayList.add(new NameValue<String>("audios__audio__bitrate__", string6));
            arrayList.add(new NameValue<String>("audios__audio__seconds__", string5));
            return this.limeXMLDocumentFactory.createLimeXMLDocument(arrayList, "http://www.limewire.com/schemas/audio.xsd");
        }
        return null;
    }

    private byte[] createExtBytes(Set<? extends URN> set, GGEPContainer gGEPContainer, long l) {
        try {
            if (this.isEmpty(set) && gGEPContainer.isEmpty()) {
                return DataUtils.EMPTY_BYTE_ARRAY;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            if (!this.isEmpty(set)) {
                Iterator<? extends URN> iterator = set.iterator();
                while (iterator.hasNext()) {
                    URN uRN = iterator.next();
                    assert (uRN != null) : "Null URN";
                    if (!uRN.isSHA1() && MessageSettings.TTROOT_IN_GGEP.getValue()) continue;
                    byteArrayOutputStream.write(uRN.toString().getBytes());
                    if (!iterator.hasNext()) continue;
                    byteArrayOutputStream.write(28);
                }
                assert (!gGEPContainer.isEmpty() || set.size() <= 1);
                if (!gGEPContainer.isEmpty()) {
                    byteArrayOutputStream.write(28);
                }
            }
            if (!gGEPContainer.isEmpty()) {
                this.addGGEP(byteArrayOutputStream, gGEPContainer, l);
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            ErrorService.error(iOException);
            return DataUtils.EMPTY_BYTE_ARRAY;
        }
    }

    private boolean isEmpty(Set<?> set) {
        return set == null || set.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<? extends IpPort> getAsIpPorts(AlternateLocationCollection<DirectAltLoc> alternateLocationCollection) {
        if (alternateLocationCollection == null || !alternateLocationCollection.hasAlternateLocations()) {
            return Collections.emptySet();
        }
        long l = System.currentTimeMillis();
        AlternateLocationCollection<DirectAltLoc> alternateLocationCollection2 = alternateLocationCollection;
        synchronized (alternateLocationCollection2) {
            Set set = null;
            int n = 0;
            Iterator<DirectAltLoc> iterator = alternateLocationCollection.iterator();
            while (iterator.hasNext() && n < 10) {
                DirectAltLoc directAltLoc = iterator.next();
                if (directAltLoc.canBeSent(2)) {
                    IpPort ipPort = directAltLoc.getHost();
                    if (this.networkInstanceUtils.isMe(ipPort)) continue;
                    if (set == null) {
                        set = new IpPortSet();
                    }
                    set.add(ipPort);
                    ++n;
                    directAltLoc.send(l, 2);
                    continue;
                }
                if (directAltLoc.canBeSentAny()) continue;
                iterator.remove();
            }
            if (set == null) {
                return Collections.emptySet();
            }
            return set;
        }
    }

    private void addGGEP(OutputStream outputStream, GGEPContainer gGEPContainer, long l) throws IOException {
        if (gGEPContainer == null || gGEPContainer.locations.size() == 0 && gGEPContainer.createTime <= 0L && gGEPContainer.size64 <= Integer.MAX_VALUE && gGEPContainer.ranges == null && gGEPContainer.ttroot == null) {
            throw new IllegalArgumentException("null or empty locations and small size");
        }
        GGEP gGEP = new GGEP(true);
        if (gGEPContainer.locations.size() > 0) {
            byte[] byArray = NetworkUtils.packIpPorts(gGEPContainer.locations);
            gGEP.put("ALT", byArray);
            BitNumbers bitNumbers = HTTPHeaderUtils.getTLSIndices(gGEPContainer.locations);
            if (!bitNumbers.isEmpty()) {
                gGEP.put("ALT_TLS", bitNumbers.toByteArray());
            }
        }
        if (gGEPContainer.createTime > 0L) {
            gGEP.put("CT", gGEPContainer.createTime / 1000L);
        }
        if (gGEPContainer.size64 > Integer.MAX_VALUE && gGEPContainer.size64 <= 0xFFFFFFFFFFL) {
            gGEP.put("LF", gGEPContainer.size64);
        }
        if (gGEPContainer.ranges != null) {
            IntervalEncoder.encode(l, gGEP, gGEPContainer.ranges);
            if (!gGEPContainer.verified) {
                gGEP.put("PRU");
            }
        }
        if (gGEPContainer.ttroot != null && MessageSettings.TTROOT_IN_GGEP.getValue()) {
            gGEP.put("TT", gGEPContainer.ttroot.getBytes());
        }
        gGEP.write(outputStream);
    }

    GGEPContainer getGGEP(GGEP gGEP, long l) {
        Object object;
        byte[] byArray;
        if (gGEP == null) {
            return GGEPContainer.EMPTY;
        }
        Set<? extends IpPort> set = null;
        long l2 = -1L;
        long l3 = l;
        URN uRN = null;
        if (gGEP.hasKey("ALT")) {
            byArray = null;
            if (gGEP.hasKey("ALT_TLS")) {
                try {
                    byArray = gGEP.getBytes("ALT_TLS");
                }
                catch (BadGGEPPropertyException badGGEPPropertyException) {
                    // empty catch block
                }
            }
            object = byArray == null ? null : new BitNumbers(byArray);
            try {
                set = this.parseLocations((BitNumbers)object, gGEP.getBytes("ALT"));
            }
            catch (BadGGEPPropertyException badGGEPPropertyException) {
                // empty catch block
            }
        }
        if (gGEP.hasKey("CT")) {
            try {
                l2 = gGEP.getLong("CT") * 1000L;
            }
            catch (BadGGEPPropertyException badGGEPPropertyException) {
                // empty catch block
            }
        }
        if (gGEP.hasKey("LF")) {
            try {
                l3 = gGEP.getLong("LF");
            }
            catch (BadGGEPPropertyException badGGEPPropertyException) {
                // empty catch block
            }
        }
        if (gGEP.hasKey("TT")) {
            try {
                byArray = gGEP.get("TT");
                if (byArray != null) {
                    uRN = URN.createTTRootFromBytes(byArray);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        boolean bl = false;
        object = null;
        try {
            object = IntervalEncoder.decode(l3, gGEP);
            bl = !gGEP.hasKey("PRU");
        }
        catch (BadGGEPPropertyException badGGEPPropertyException) {
            // empty catch block
        }
        if (set == null && l2 == -1L && l3 <= Integer.MAX_VALUE && object == null & uRN == null) {
            return GGEPContainer.EMPTY;
        }
        return new GGEPContainer(set, l2, l3, (IntervalSet)object, bl, uRN);
    }

    private Set<? extends IpPort> parseLocations(BitNumbers bitNumbers, byte[] byArray) {
        IpPortSet ipPortSet = null;
        if (byArray.length % 6 != 0) {
            return null;
        }
        int n = byArray.length / 6;
        byte[] byArray2 = new byte[6];
        for (int i = 0; i < n; ++i) {
            IpPort ipPort;
            System.arraycopy(byArray, i * 6, byArray2, 0, 6);
            try {
                ipPort = NetworkUtils.getIpPort(byArray2, ByteOrder.LITTLE_ENDIAN);
            }
            catch (InvalidDataException invalidDataException) {
                bitNumbers = null;
                continue;
            }
            if (!this.ipFilter.allow(ipPort.getAddress()) || this.networkInstanceUtils.isMe(ipPort)) continue;
            if (ipPortSet == null) {
                ipPortSet = new IpPortSet();
            }
            if (bitNumbers != null && bitNumbers.isSet(i)) {
                ipPort = new ConnectableImpl(ipPort, true);
            }
            ipPortSet.add(ipPort);
        }
        return ipPortSet;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class GGEPContainer {
        final Set<? extends IpPort> locations;
        final long createTime;
        final long size64;
        static final GGEPContainer EMPTY = new GGEPContainer();
        final IntervalSet ranges;
        final boolean verified;
        final URN ttroot;

        private GGEPContainer() {
            this(null, -1L, 0L, null, false, null);
        }

        GGEPContainer(Set<? extends IpPort> set, long l, long l2, IntervalSet intervalSet, boolean bl, URN uRN) {
            this.locations = set == null ? Collections.emptySet() : Collections.unmodifiableSet(set);
            this.createTime = l;
            this.size64 = l2;
            this.ranges = intervalSet;
            this.verified = bl;
            this.ttroot = uRN;
            assert (uRN == null || uRN.isTTRoot());
        }

        boolean isEmpty() {
            return this.locations.isEmpty() && this.createTime <= 0L && this.size64 <= Integer.MAX_VALUE && this.ranges == null && this.ttroot == null;
        }
    }
}

