/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.HTTPAcceptor;
import com.limegroup.gnutella.http.HTTPConnectionData;
import com.limegroup.gnutella.settings.SSLSettings;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.NetworkUtils;
import org.limewire.net.SocketsManager;
import org.limewire.nio.AbstractNBSocket;
import org.limewire.nio.NBSocket;
import org.limewire.nio.channel.ChannelWriter;
import org.limewire.nio.channel.InterestWritableByteChannel;
import org.limewire.nio.channel.NIOMultiplexor;
import org.limewire.nio.observer.ConnectObserver;
import org.limewire.rudp.UDPSelectorProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public final class PushManager {
    private static final Log LOG = LogFactory.getLog(PushManager.class);
    private static final int CONNECT_TIMEOUT = 10000;
    private final Provider<FileManager> fileManager;
    private final Provider<SocketsManager> socketsManager;
    private final Provider<HTTPAcceptor> httpAcceptor;
    private final Provider<UDPSelectorProvider> udpSelectorProvider;

    @Inject
    public PushManager(Provider<FileManager> provider, Provider<SocketsManager> provider2, Provider<HTTPAcceptor> provider3, Provider<UDPSelectorProvider> provider4) {
        this.fileManager = provider;
        this.socketsManager = provider2;
        this.httpAcceptor = provider3;
        this.udpSelectorProvider = provider4;
    }

    public void acceptPushUpload(String string, int n, String string2, boolean bl, boolean bl2, boolean bl3) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Accepting Push Upload from ip:" + string + " port:" + n + " FW:" + bl2));
        }
        if (string == null) {
            throw new NullPointerException("null host");
        }
        if (!NetworkUtils.isValidPort(n)) {
            throw new IllegalArgumentException("invalid port: " + n);
        }
        if (string2 == null) {
            throw new NullPointerException("null guid");
        }
        if (((FileManager)this.fileManager.get()).getNumFiles() < 1 && ((FileManager)this.fileManager.get()).getNumIncompleteFiles() < 1) {
            return;
        }
        PushData pushData = new PushData(string, n, string2, bl);
        if (bl2) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Adding push observer FW-FW to host: " + string + ":" + n));
            }
            AbstractNBSocket abstractNBSocket = ((UDPSelectorProvider)this.udpSelectorProvider.get()).openSocketChannel().socket();
            ((NBSocket)abstractNBSocket).connect(new InetSocketAddress(string, n), 20000, new PushObserver(pushData, true, (HTTPAcceptor)this.httpAcceptor.get()));
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Adding push observer to host: " + string + ":" + n));
            }
            try {
                SocketsManager.ConnectType connectType = bl3 && SSLSettings.isOutgoingTLSEnabled() ? SocketsManager.ConnectType.TLS : SocketsManager.ConnectType.PLAIN;
                ((SocketsManager)this.socketsManager.get()).connect(new InetSocketAddress(string, n), 10000, new PushObserver(pushData, false, (HTTPAcceptor)this.httpAcceptor.get()), connectType);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static class PushConnector
    implements ChannelWriter {
        private InterestWritableByteChannel channel;
        private final ByteBuffer buffer;
        private final Socket socket;
        private HTTPConnectionData data;
        private HTTPAcceptor httpAcceptor;

        public PushConnector(Socket socket, PushData pushData, boolean bl, HTTPAcceptor hTTPAcceptor) throws IOException {
            this.socket = socket;
            this.data = new HTTPConnectionData();
            this.data.setPush(true);
            this.data.setLocal(pushData.isLan());
            this.data.setFirewalled(bl);
            this.httpAcceptor = hTTPAcceptor;
            socket.setSoTimeout(30000);
            String string = "GIV 0:" + pushData.getGuid() + "/file\n\n";
            this.buffer = ByteBuffer.wrap(string.getBytes());
        }

        public boolean handleWrite() throws IOException {
            if (!this.buffer.hasRemaining()) {
                return false;
            }
            while (this.buffer.hasRemaining()) {
                int n = this.channel.write(this.buffer);
                if (n != 0) continue;
                return true;
            }
            this.httpAcceptor.acceptConnection(this.socket, this.data);
            return false;
        }

        public void handleIOException(IOException iOException) {
            throw new RuntimeException();
        }

        public void shutdown() {
        }

        public InterestWritableByteChannel getWriteChannel() {
            return this.channel;
        }

        public void setWriteChannel(InterestWritableByteChannel interestWritableByteChannel) {
            this.channel = interestWritableByteChannel;
            if (interestWritableByteChannel != null) {
                interestWritableByteChannel.interestWrite(this, true);
            }
        }
    }

    private static class PushObserver
    implements ConnectObserver {
        private final PushData data;
        private final boolean fwt;
        private final HTTPAcceptor httpAcceptor;

        PushObserver(PushData pushData, boolean bl, HTTPAcceptor hTTPAcceptor) {
            this.data = pushData;
            this.fwt = bl;
            this.httpAcceptor = hTTPAcceptor;
        }

        public void handleIOException(IOException iOException) {
        }

        public void shutdown() {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Push (fwt: " + this.fwt + ") connect to: " + this.data.getHost() + ":" + this.data.getPort() + " failed"));
            }
        }

        public void handleConnect(Socket socket) throws IOException {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Push (fwt: " + this.fwt + ") connect to: " + this.data.getHost() + ":" + this.data.getPort() + " succeeded"));
            }
            ((NIOMultiplexor)((Object)socket)).setWriteObserver(new PushConnector(socket, this.data, this.fwt, this.httpAcceptor));
        }
    }

    private static class PushData {
        private final String host;
        private final int port;
        private final String guid;
        private final boolean lan;

        PushData(String string, int n, String string2, boolean bl) {
            this.host = string;
            this.port = n;
            this.guid = string2;
            this.lan = bl;
        }

        public boolean isLan() {
            return this.lan;
        }

        public String getGuid() {
            return this.guid;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }
    }
}

