/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.AbstractPushEndpoint;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.PushEndpoint;
import com.limegroup.gnutella.PushEndpointCache;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.limewire.io.IpPort;
import org.limewire.io.IpPortSet;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.service.ErrorService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PushEndpointImpl
extends AbstractPushEndpoint {
    private final byte[] _clientGUID;
    private GUID _guid;
    private final int _features;
    private final int _fwtVersion;
    private Set<? extends IpPort> _proxies;
    private final IpPort _externalAddr;
    private final PushEndpointCache pushEndpointCache;
    private final NetworkInstanceUtils networkInstanceUtils;

    public PushEndpointImpl(byte[] byArray, Set<? extends IpPort> set, byte by, int n, IpPort ipPort, PushEndpointCache pushEndpointCache, NetworkInstanceUtils networkInstanceUtils) {
        this.pushEndpointCache = pushEndpointCache;
        this.networkInstanceUtils = networkInstanceUtils;
        this._features = by & 0xFFFFFFE0 | n << 3;
        this._fwtVersion = n;
        this._clientGUID = byArray;
        this._guid = new GUID(this._clientGUID);
        this._proxies = set != null ? (set instanceof IpPortSet ? Collections.unmodifiableSet(set) : Collections.unmodifiableSet(new IpPortSet((Collection<? extends IpPort>)set))) : Collections.emptySet();
        this._externalAddr = ipPort;
        if (ipPort != null && ipPort.getAddress().equals("1.1.1.1")) {
            ErrorService.error(new IllegalStateException("constructing PEI w/ bogus IP!"));
        }
    }

    @Override
    public IpPort getValidExternalAddress() {
        IpPort ipPort = this.getIpPort();
        if (ipPort == null || !this.networkInstanceUtils.isValidExternalIpPort(ipPort)) {
            return null;
        }
        if (ipPort.getAddress().equals("1.1.1.1")) {
            return null;
        }
        return ipPort;
    }

    @Override
    public byte[] getClientGUID() {
        return this._clientGUID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<? extends IpPort> getProxies() {
        PushEndpoint pushEndpoint = this;
        synchronized (pushEndpoint) {
            if (this._proxies != null) {
                return this._proxies;
            }
        }
        pushEndpoint = this.pushEndpointCache.getCached(this._guid);
        if (pushEndpoint == null) {
            return Collections.emptySet();
        }
        return pushEndpoint.getProxies();
    }

    @Override
    public int getFWTVersion() {
        PushEndpoint pushEndpoint = this.pushEndpointCache.getCached(this._guid);
        int n = pushEndpoint == null ? this._fwtVersion : pushEndpoint.getFWTVersion();
        return n;
    }

    @Override
    public byte getFeatures() {
        PushEndpoint pushEndpoint = this.pushEndpointCache.getCached(this._guid);
        int n = pushEndpoint == null ? this._features : (int)pushEndpoint.getFeatures();
        return (byte)(n & 0xFFFFFFE0);
    }

    private IpPort getIpPort() {
        PushEndpoint pushEndpoint = this.pushEndpointCache.getCached(this._guid);
        return pushEndpoint == null || pushEndpoint.getValidExternalAddress() == null ? this._externalAddr : pushEndpoint.getValidExternalAddress();
    }

    @Override
    public String getAddress() {
        IpPort ipPort = this.getIpPort();
        return ipPort != null ? ipPort.getAddress() : "1.1.1.1";
    }

    @Override
    public InetAddress getInetAddress() {
        IpPort ipPort = this.getIpPort();
        return ipPort != null ? ipPort.getInetAddress() : null;
    }

    @Override
    public int getPort() {
        IpPort ipPort = this.getIpPort();
        return ipPort != null ? ipPort.getPort() : 6346;
    }

    @Override
    public InetSocketAddress getInetSocketAddress() {
        IpPort ipPort = this.getIpPort();
        return ipPort != null ? ipPort.getInetSocketAddress() : null;
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    @Override
    public synchronized void updateProxies(boolean bl) {
        this._guid = this.pushEndpointCache.updateProxiesFor(this._guid, this, bl);
        this._proxies = null;
    }

    @Override
    public PushEndpoint createClone() {
        return new PushEndpointImpl(this._guid.bytes(), this.getProxies(), this.getFeatures(), this.getFWTVersion(), this.getIpPort(), this.pushEndpointCache, this.networkInstanceUtils);
    }
}

