/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.gnutella.AbstractPushEndpoint;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.PushEndpoint;
import com.limegroup.gnutella.PushEndpointCache;
import com.limegroup.gnutella.PushEndpointImpl;
import com.limegroup.gnutella.dht.db.SearchListener;
import com.limegroup.gnutella.uploader.HTTPHeaderUtils;
import java.lang.ref.WeakReference;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.Connectable;
import org.limewire.io.IpPort;
import org.limewire.io.IpPortSet;
import org.limewire.io.NetworkInstanceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
class PushEndpointCacheImpl
implements PushEndpointCache {
    private static final Log LOG = LogFactory.getLog(PushEndpointCacheImpl.class);
    private final Map<GUID, CachedPushEndpoint> GUID_PROXY_MAP = Collections.synchronizedMap(new WeakHashMap());
    private final HTTPHeaderUtils httpHeaderUtils;
    private final NetworkInstanceUtils networkInstanceUtils;

    @Inject
    PushEndpointCacheImpl(@Named(value="backgroundExecutor") ScheduledExecutorService scheduledExecutorService, HTTPHeaderUtils hTTPHeaderUtils, NetworkInstanceUtils networkInstanceUtils) {
        this.httpHeaderUtils = hTTPHeaderUtils;
        this.networkInstanceUtils = networkInstanceUtils;
        scheduledExecutorService.scheduleWithFixedDelay(new WeakCleaner(), 30000L, 30000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void overwriteProxies(byte[] byArray, String string) {
        Set<Connectable> set = this.httpHeaderUtils.decodePushProxies(string, ",");
        this.overwriteProxies(byArray, set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void overwriteProxies(byte[] byArray, Set<? extends IpPort> set) {
        GUID gUID = new GUID(byArray);
        Map<GUID, CachedPushEndpoint> map = this.GUID_PROXY_MAP;
        synchronized (map) {
            CachedPushEndpoint cachedPushEndpoint = this.GUID_PROXY_MAP.get(gUID);
            if (cachedPushEndpoint == null) {
                cachedPushEndpoint = new CachedPushEndpoint(gUID, set);
                this.GUID_PROXY_MAP.put(gUID, cachedPushEndpoint);
            } else {
                cachedPushEndpoint.overwriteProxies(set);
            }
        }
    }

    @Override
    public void removePushProxy(byte[] byArray, IpPort ipPort) {
        GUID gUID;
        CachedPushEndpoint cachedPushEndpoint;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Removing push proxy: " + ipPort + " for " + new GUID(byArray)));
        }
        if ((cachedPushEndpoint = this.GUID_PROXY_MAP.get(gUID = new GUID(byArray))) != null) {
            cachedPushEndpoint.removePushProxy(ipPort);
        }
    }

    @Override
    public void setAddr(byte[] byArray, IpPort ipPort) {
        GUID gUID = new GUID(byArray);
        CachedPushEndpoint cachedPushEndpoint = this.getCached(gUID);
        if (cachedPushEndpoint != null) {
            cachedPushEndpoint.setIpPort(ipPort);
        }
    }

    @Override
    public void setFWTVersionSupported(byte[] byArray, int n) {
        GUID gUID = new GUID(byArray);
        CachedPushEndpoint cachedPushEndpoint = this.getCached(gUID);
        if (cachedPushEndpoint != null) {
            cachedPushEndpoint.setFWTVersion(n);
        }
    }

    @Override
    public CachedPushEndpoint getCached(GUID gUID) {
        return this.GUID_PROXY_MAP.get(gUID);
    }

    @Override
    public PushEndpoint getPushEndpoint(GUID gUID) {
        CachedPushEndpoint cachedPushEndpoint = this.GUID_PROXY_MAP.get(gUID);
        return cachedPushEndpoint != null ? cachedPushEndpoint.createClone() : null;
    }

    @Override
    public void findPushEndpoint(GUID gUID, SearchListener<PushEndpoint> searchListener) {
        PushEndpoint pushEndpoint = this.getPushEndpoint(gUID);
        if (pushEndpoint != null) {
            searchListener.handleResult(pushEndpoint);
        } else {
            searchListener.searchFailed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GUID updateProxiesFor(GUID gUID, PushEndpoint pushEndpoint, boolean bl) {
        CachedPushEndpoint cachedPushEndpoint;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Updating proxies for: " + gUID + " with: " + pushEndpoint + ", valid: " + bl));
        }
        GUID gUID2 = null;
        Map<GUID, CachedPushEndpoint> map = this.GUID_PROXY_MAP;
        synchronized (map) {
            cachedPushEndpoint = this.GUID_PROXY_MAP.get(gUID);
            if (cachedPushEndpoint != null) {
                gUID2 = cachedPushEndpoint.getGuid();
            }
            if (cachedPushEndpoint == null || gUID2 == null) {
                cachedPushEndpoint = new CachedPushEndpoint(gUID, pushEndpoint.getFeatures(), pushEndpoint.getFWTVersion(), bl ? pushEndpoint.getProxies() : IpPort.EMPTY_SET);
                this.GUID_PROXY_MAP.put(gUID, cachedPushEndpoint);
                return gUID;
            }
        }
        cachedPushEndpoint.updateProxies(pushEndpoint.getProxies(), bl);
        return gUID2;
    }

    @Override
    public void clear() {
        this.GUID_PROXY_MAP.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CachedPushEndpoint
    extends AbstractPushEndpoint {
        private final WeakReference<GUID> _guidRef;
        private Set<IpPort> _proxies;
        private byte _features;
        private int _fwtVersion;
        private IpPort _externalAddr;
        private final byte[] guid;

        CachedPushEndpoint(GUID gUID, Set<? extends IpPort> set) {
            this(gUID, 0, 0, set);
        }

        CachedPushEndpoint(GUID gUID, byte by, int n, Set<? extends IpPort> set) {
            this.guid = gUID.bytes();
            this._guidRef = new WeakReference<GUID>(gUID);
            this._features = by;
            this._fwtVersion = n;
            this.overwriteProxies(set);
        }

        public synchronized void removePushProxy(IpPort ipPort) {
            this.updateProxies(new IpPortSet(ipPort), false);
        }

        public synchronized void updateProxies(Set<? extends IpPort> set, boolean bl) {
            IpPortSet ipPortSet = new IpPortSet((Collection<? extends IpPort>)this._proxies);
            if (bl) {
                ipPortSet.addAll(set);
            } else {
                ipPortSet.removeAll(set);
            }
            this._proxies = Collections.unmodifiableSet(ipPortSet);
        }

        public synchronized void overwriteProxies(Set<? extends IpPort> set) {
            this._proxies = Collections.unmodifiableSet(new IpPortSet((Collection<? extends IpPort>)set));
        }

        public synchronized Set<IpPort> getProxies() {
            return this._proxies;
        }

        @Override
        public synchronized byte getFeatures() {
            return this._features;
        }

        @Override
        public synchronized int getFWTVersion() {
            return this._fwtVersion;
        }

        public synchronized void setFeatures(byte by) {
            this._features = by;
        }

        public synchronized void setFWTVersion(int n) {
            this._fwtVersion = n;
        }

        public synchronized void setIpPort(IpPort ipPort) {
            this._externalAddr = ipPort;
        }

        public synchronized IpPort getIpPort() {
            return this._externalAddr;
        }

        public GUID getGuid() {
            return (GUID)this._guidRef.get();
        }

        @Override
        public synchronized PushEndpoint createClone() {
            return new PushEndpointImpl(this.guid, this.getProxies(), this.getFeatures(), this.getFWTVersion(), this.getValidExternalAddress(), PushEndpointCacheImpl.this, PushEndpointCacheImpl.this.networkInstanceUtils);
        }

        @Override
        public byte[] getClientGUID() {
            return this.guid;
        }

        @Override
        public synchronized int getPort() {
            IpPort ipPort = this._externalAddr;
            return ipPort != null ? ipPort.getPort() : 6346;
        }

        @Override
        public synchronized IpPort getValidExternalAddress() {
            return this._externalAddr;
        }

        @Override
        public boolean isLocal() {
            return false;
        }

        @Override
        public synchronized void updateProxies(boolean bl) {
            if (!bl) {
                this._proxies = Collections.emptySet();
            }
        }

        @Override
        public synchronized String getAddress() {
            IpPort ipPort = this._externalAddr;
            return ipPort != null ? this._externalAddr.getAddress() : "1.1.1.1";
        }

        @Override
        public InetAddress getInetAddress() {
            return null;
        }

        @Override
        public InetSocketAddress getInetSocketAddress() {
            return null;
        }
    }

    private final class WeakCleaner
    implements Runnable {
        private WeakCleaner() {
        }

        public void run() {
            PushEndpointCacheImpl.this.GUID_PROXY_MAP.size();
        }
    }
}

