/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.gnutella.statistics.OutOfBandStatistics;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Singleton
public class OutOfBandThroughputMeasurer {
    private static final Log LOG = LogFactory.getLog(OutOfBandThroughputMeasurer.class);
    private final ScheduledExecutorService backgroundExecutor;
    private final OutOfBandStatistics outOfBandStatistics;

    @Inject
    public OutOfBandThroughputMeasurer(@Named(value="backgroundExecutor") ScheduledExecutorService scheduledExecutorService, OutOfBandStatistics outOfBandStatistics) {
        this.backgroundExecutor = scheduledExecutorService;
        this.outOfBandStatistics = outOfBandStatistics;
    }

    void initialize() {
        Runnable runnable = new Runnable(){

            public void run() {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("current success rate " + OutOfBandThroughputMeasurer.this.outOfBandStatistics.getSuccessRate() + " based on " + OutOfBandThroughputMeasurer.this.outOfBandStatistics.getRequestedResponses() + " measurements with a min sample size " + OutOfBandThroughputMeasurer.this.outOfBandStatistics.getSampleSize()));
                }
                if (!OutOfBandThroughputMeasurer.this.outOfBandStatistics.isSuccessRateGreat() && !OutOfBandThroughputMeasurer.this.outOfBandStatistics.isSuccessRateTerrible()) {
                    LOG.debug((Object)"boosting sample size");
                    OutOfBandThroughputMeasurer.this.outOfBandStatistics.increaseSampleSize();
                }
            }
        };
        int n = 1800000;
        this.backgroundExecutor.scheduleWithFixedDelay(runnable, n, n, TimeUnit.MILLISECONDS);
    }
}

