/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.ReplyHandler;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.IP;
import org.limewire.nio.observer.Shutdownable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class NetworkUpdateSanityChecker {
    private static final Set<RequestType> allTypes = EnumSet.allOf(RequestType.class);
    private static final Log LOG = LogFactory.getLog(NetworkUpdateSanityChecker.class);
    private static final int MAXIMUM_FAILURES = 20;
    private static final String MASK = "/255.255.0.0";
    private final Map<RequestType, Map<ReplyHandler, Boolean>> requests = new HashMap<RequestType, Map<ReplyHandler, Boolean>>(RequestType.values().length);
    private final List<IP> failures = new ArrayList<IP>(20);
    private boolean finished = false;
    private final Set<RequestType> successes = EnumSet.noneOf(RequestType.class);
    private final Provider<ActivityCallback> activityCallback;

    @Inject
    public NetworkUpdateSanityChecker(Provider<ActivityCallback> provider) {
        this.activityCallback = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNewRequest(ReplyHandler replyHandler, RequestType requestType) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Adding request to handler: " + replyHandler));
        }
        Map<RequestType, Map<ReplyHandler, Boolean>> map = this.requests;
        synchronized (map) {
            if (this.finished) {
                LOG.debug((Object)"Already reached maximum failure point, ignoring.");
                return;
            }
            this.addRequest(replyHandler, requestType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleValidResponse(ReplyHandler replyHandler, RequestType requestType) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Received valid response from handler: " + replyHandler + "of type: " + (Object)((Object)requestType)));
        }
        Map<RequestType, Map<ReplyHandler, Boolean>> map = this.requests;
        synchronized (map) {
            if (!this.finished) {
                this.successes.add(requestType);
                if (this.successes.containsAll(allTypes)) {
                    LOG.debug((Object)"Received every kind of success!");
                    this.finished = true;
                    this.requests.clear();
                    this.failures.clear();
                } else {
                    this.removeRequest(replyHandler, requestType);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleInvalidResponse(ReplyHandler replyHandler, RequestType requestType) {
        Map<RequestType, Map<ReplyHandler, Boolean>> map = this.requests;
        synchronized (map) {
            if (!this.finished && this.removeRequest(replyHandler, requestType)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Had a request from handler, adding as failure... " + replyHandler));
                }
                IP iP = new IP(replyHandler.getAddress() + MASK);
                boolean bl = false;
                for (IP iP2 : this.failures) {
                    if (!iP2.contains(iP)) continue;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Already had a failure from range: " + iP2 + ", ignoring handler ip: " + iP));
                    }
                    bl = true;
                    break;
                }
                if (!bl) {
                    this.failures.add(iP);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Current failure size: " + this.failures.size()));
                    }
                    if (this.failures.size() == 20) {
                        LOG.debug((Object)"Reached failure threshold!");
                        this.finished = true;
                        this.requests.clear();
                        this.failures.clear();
                        ((ActivityCallback)this.activityCallback.get()).installationCorrupted();
                    }
                }
            }
        }
        if (replyHandler instanceof Shutdownable) {
            ((Shutdownable)((Object)replyHandler)).shutdown();
        }
    }

    private void addRequest(ReplyHandler replyHandler, RequestType requestType) {
        Map<ReplyHandler, Boolean> map = this.requests.get((Object)requestType);
        if (map == null) {
            map = new WeakHashMap<ReplyHandler, Boolean>();
            this.requests.put(requestType, map);
        }
        map.put(replyHandler, Boolean.TRUE);
    }

    private boolean removeRequest(ReplyHandler replyHandler, RequestType requestType) {
        Map<ReplyHandler, Boolean> map = this.requests.get((Object)requestType);
        if (map == null) {
            return false;
        }
        return map.remove(replyHandler) != null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RequestType {
        SIMPP,
        VERSION;

    }
}

