/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.Acceptor;
import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.NetworkManagerEvent;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.connection.RoutedConnection;
import com.limegroup.gnutella.dht.DHTManager;
import com.limegroup.gnutella.messages.vendor.CapabilitiesVMFactory;
import com.limegroup.gnutella.messages.vendor.HeaderUpdateVendorMessage;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.SearchSettings;
import com.limegroup.gnutella.statistics.OutOfBandStatistics;
import java.io.IOException;
import java.util.Properties;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.io.NetworkUtils;
import org.limewire.listener.EventListener;
import org.limewire.listener.EventListenerList;
import org.limewire.setting.evt.SettingEvent;
import org.limewire.setting.evt.SettingListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class NetworkManagerImpl
implements NetworkManager {
    private final Provider<UDPService> udpService;
    private final Provider<Acceptor> acceptor;
    private final Provider<DHTManager> dhtManager;
    private final Provider<ConnectionManager> connectionManager;
    private final Provider<ActivityCallback> activityCallback;
    private final OutOfBandStatistics outOfBandStatistics;
    private final NetworkInstanceUtils networkInstanceUtils;
    private final Provider<CapabilitiesVMFactory> capabilitiesVMFactory;
    private final SettingListener fwtListener = new FWTChangeListener();
    private final EventListenerList<NetworkManagerEvent> listeners = new EventListenerList();

    @Inject
    public NetworkManagerImpl(Provider<UDPService> provider, Provider<Acceptor> provider2, Provider<DHTManager> provider3, Provider<ConnectionManager> provider4, Provider<ActivityCallback> provider5, OutOfBandStatistics outOfBandStatistics, NetworkInstanceUtils networkInstanceUtils, Provider<CapabilitiesVMFactory> provider6) {
        this.udpService = provider;
        this.acceptor = provider2;
        this.dhtManager = provider3;
        this.connectionManager = provider4;
        this.activityCallback = provider5;
        this.outOfBandStatistics = outOfBandStatistics;
        this.networkInstanceUtils = networkInstanceUtils;
        this.capabilitiesVMFactory = provider6;
    }

    @Override
    public void start() {
        ConnectionSettings.LAST_FWT_STATE.addSettingListener(this.fwtListener);
    }

    @Override
    public void stop() {
        ConnectionSettings.LAST_FWT_STATE.removeSettingListener(this.fwtListener);
    }

    @Override
    public void initialize() {
    }

    @Override
    public boolean isIpPortValid() {
        return NetworkUtils.isValidAddress(this.getAddress()) && NetworkUtils.isValidPort(this.getPort());
    }

    @Override
    public GUID getUDPConnectBackGUID() {
        return ((UDPService)this.udpService.get()).getConnectBackGUID();
    }

    @Override
    public boolean isOOBCapable() {
        return this.isGUESSCapable() && this.outOfBandStatistics.isSuccessRateGood() && !this.networkInstanceUtils.isPrivate() && SearchSettings.OOB_ENABLED.getValue() && ((Acceptor)this.acceptor.get()).isAddressExternal() && this.isIpPortValid();
    }

    @Override
    public boolean isGUESSCapable() {
        return ((UDPService)this.udpService.get()).isGUESSCapable();
    }

    @Override
    public int getNonForcedPort() {
        return ((Acceptor)this.acceptor.get()).getPort(false);
    }

    @Override
    public int getPort() {
        return ((Acceptor)this.acceptor.get()).getPort(true);
    }

    @Override
    public byte[] getNonForcedAddress() {
        return ((Acceptor)this.acceptor.get()).getAddress(false);
    }

    @Override
    public byte[] getAddress() {
        return ((Acceptor)this.acceptor.get()).getAddress(true);
    }

    @Override
    public byte[] getExternalAddress() {
        return ((Acceptor)this.acceptor.get()).getExternalAddress();
    }

    @Override
    public boolean incomingStatusChanged() {
        this.updateCapabilities();
        ((ActivityCallback)this.activityCallback.get()).handleAddressStateChanged();
        byte[] byArray = this.getAddress();
        int n = this.getPort();
        if (!NetworkUtils.isValidAddress(byArray)) {
            return false;
        }
        if (this.networkInstanceUtils.isPrivateAddress(byArray)) {
            return false;
        }
        return NetworkUtils.isValidPort(n);
    }

    private void updateCapabilities() {
        ((CapabilitiesVMFactory)this.capabilitiesVMFactory.get()).updateCapabilities();
        if (((ConnectionManager)this.connectionManager.get()).isShieldedLeaf()) {
            ((ConnectionManager)this.connectionManager.get()).sendUpdatedCapabilities();
        }
    }

    @Override
    public boolean addressChanged() {
        ((ActivityCallback)this.activityCallback.get()).handleAddressStateChanged();
        byte[] byArray = this.getAddress();
        int n = this.getPort();
        if (!NetworkUtils.isValidAddress(byArray)) {
            return false;
        }
        if (this.networkInstanceUtils.isPrivateAddress(byArray)) {
            return false;
        }
        if (!NetworkUtils.isValidPort(n)) {
            return false;
        }
        ((Acceptor)this.acceptor.get()).resetLastConnectBackTime();
        ((DHTManager)this.dhtManager.get()).addressChanged();
        Properties properties = new Properties();
        properties.put("Listen-IP", NetworkUtils.ip2string(byArray) + ":" + n);
        HeaderUpdateVendorMessage headerUpdateVendorMessage = new HeaderUpdateVendorMessage(properties);
        for (RoutedConnection routedConnection : ((ConnectionManager)this.connectionManager.get()).getInitializedConnections()) {
            if (routedConnection.getConnectionCapabilities().remoteHostSupportsHeaderUpdate() < 1) continue;
            routedConnection.send(headerUpdateVendorMessage);
        }
        for (RoutedConnection routedConnection : ((ConnectionManager)this.connectionManager.get()).getInitializedClientConnections()) {
            if (routedConnection.getConnectionCapabilities().remoteHostSupportsHeaderUpdate() < 1) continue;
            routedConnection.send(headerUpdateVendorMessage);
        }
        this.fireEvent(new NetworkManagerEvent(this, NetworkManager.EventType.ADDRESS_CHANGE));
        return true;
    }

    @Override
    public boolean acceptedIncomingConnection() {
        return ((Acceptor)this.acceptor.get()).acceptedIncoming();
    }

    @Override
    public void setListeningPort(int n) throws IOException {
        ((Acceptor)this.acceptor.get()).setListeningPort(n);
    }

    @Override
    public boolean canReceiveUnsolicited() {
        return ((UDPService)this.udpService.get()).canReceiveUnsolicited();
    }

    @Override
    public boolean canReceiveSolicited() {
        return ((UDPService)this.udpService.get()).canReceiveSolicited();
    }

    @Override
    public boolean canDoFWT() {
        return ((UDPService)this.udpService.get()).canDoFWT();
    }

    @Override
    public int getStableUDPPort() {
        return ((UDPService)this.udpService.get()).getStableUDPPort();
    }

    @Override
    public GUID getSolicitedGUID() {
        return ((UDPService)this.udpService.get()).getSolicitedGUID();
    }

    @Override
    public int supportsFWTVersion() {
        return ((UDPService)this.udpService.get()).canDoFWT() ? 1 : 0;
    }

    @Override
    public boolean isPrivateAddress(byte[] byArray) {
        return this.networkInstanceUtils.isPrivateAddress(byArray);
    }

    @Override
    public void addListener(EventListener<NetworkManagerEvent> eventListener) {
        this.listeners.addListener(eventListener);
    }

    @Override
    public boolean removeListener(EventListener<NetworkManagerEvent> eventListener) {
        return this.listeners.removeListener(eventListener);
    }

    private void fireEvent(NetworkManagerEvent networkManagerEvent) {
        this.listeners.broadcast(networkManagerEvent);
    }

    private class FWTChangeListener
    implements SettingListener {
        private FWTChangeListener() {
        }

        public void settingChanged(SettingEvent settingEvent) {
            if (settingEvent.getEventType() == SettingEvent.EventType.VALUE_CHANGED) {
                NetworkManagerImpl.this.updateCapabilities();
            }
        }
    }
}

