/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.messages.QueryRequest;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.limewire.collection.Comparators;
import org.limewire.i18n.I18nMarker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaType
implements Serializable {
    private static final long serialVersionUID = 3999062781289258389L;
    public static final String SCHEMA_ANY_TYPE = "*";
    public static final String SCHEMA_CUSTOM = "custom";
    public static final String SCHEMA_DOCUMENTS = "document";
    public static final String SCHEMA_PROGRAMS = "application";
    public static final String SCHEMA_AUDIO = "audio";
    public static final String SCHEMA_VIDEO = "video";
    public static final String SCHEMA_IMAGES = "image";
    public static final String SCHEMA_OTHER = "other";
    public static final String ANY_TYPE = I18nMarker.marktr("All Types");
    public static final String DOCUMENTS = I18nMarker.marktr("Documents");
    public static final String PROGRAMS = I18nMarker.marktr("Programs");
    public static final String AUDIO = I18nMarker.marktr("Audio");
    public static final String VIDEO = I18nMarker.marktr("Video");
    public static final String IMAGES = I18nMarker.marktr("Images");
    private static final MediaType TYPE_ANY = new MediaType("*", ANY_TYPE, null){
        private static final long serialVersionUID = 8621997774686329539L;

        public boolean matches(String string) {
            return true;
        }
    };
    private static final MediaType TYPE_DOCUMENTS = new MediaType("document", DOCUMENTS, new String[]{"html", "htm", "xhtml", "mht", "mhtml", "xml", "txt", "ans", "asc", "diz", "eml", "pdf", "ps", "eps", "epsf", "dvi", "rtf", "wri", "doc", "mcw", "wps", "xls", "wk1", "dif", "csv", "ppt", "tsv", "hlp", "chm", "lit", "tex", "texi", "latex", "info", "man", "wp", "wpd", "wp5", "wk3", "wk4", "shw", "sdd", "sdw", "sdp", "sdc", "sxd", "sxw", "sxp", "sxc", "abw", "kwd"});
    private static final MediaType TYPE_LINUX_OSX_PROGRAMS = new MediaType("application", PROGRAMS, new String[]{"bin", "mdb", "sh", "csh", "awk", "pl", "rpm", "deb", "gz", "gzip", "z", "bz2", "zoo", "tar", "tgz", "taz", "shar", "hqx", "sit", "dmg", "7z", "jar", "zip", "nrg", "cue", "iso", "jnlp", "rar", "sh"});
    private static final MediaType TYPE_WINDOWS_PROGRAMS = new MediaType("application", PROGRAMS, new String[]{"exe", "zip", "jar", "cab", "msi", "msp", "arj", "rar", "ace", "lzh", "lha", "bin", "nrg", "cue", "iso", "jnlp"});
    private static final MediaType TYPE_PROGRAMS = new MediaType("application", PROGRAMS, MediaType.makeArray(MediaType.TYPE_LINUX_OSX_PROGRAMS.exts, MediaType.TYPE_WINDOWS_PROGRAMS.exts));
    private static final MediaType TYPE_AUDIO = new MediaType("audio", AUDIO, new String[]{"mp3", "mpa", "mp1", "mpga", "mp2", "ra", "rm", "ram", "rmj", "wma", "wav", "m4a", "m4p", "mp4", "lqt", "ogg", "med", "aif", "aiff", "aifc", "au", "snd", "s3m", "aud", "mid", "midi", "rmi", "mod", "kar", "ac3", "shn", "fla", "flac", "cda", "mka"});
    private static final MediaType TYPE_VIDEO = new MediaType("video", VIDEO, new String[]{"mpg", "mpeg", "mpe", "mng", "mpv", "m1v", "vob", "mp2", "mpv2", "mp2v", "m2p", "m2v", "mpgv", "vcd", "mp4", "dv", "dvd", "div", "divx", "dvx", "smi", "smil", "rm", "ram", "rv", "rmm", "rmvb", "avi", "asf", "asx", "wmv", "qt", "mov", "fli", "flc", "flx", "flv", "wml", "vrml", "swf", "dcr", "jve", "nsv", "mkv", "ogm", "cdg", "srt", "sub", "idx", "flv"});
    private static final MediaType TYPE_IMAGES = new MediaType("image", IMAGES, new String[]{"gif", "png", "jpg", "jpeg", "jpe", "jif", "jiff", "jfif", "tif", "tiff", "iff", "lbm", "ilbm", "eps", "mac", "drw", "pct", "img", "bmp", "dib", "rle", "ico", "ani", "icl", "cur", "emf", "wmf", "pcx", "pcd", "tga", "pic", "fig", "psd", "wpg", "dcx", "cpt", "mic", "pbm", "pnm", "ppm", "xbm", "xpm", "xwd", "sgi", "fax", "rgb", "ras"});
    private static final MediaType[] ALL_MEDIA_TYPES = new MediaType[]{TYPE_ANY, TYPE_DOCUMENTS, TYPE_PROGRAMS, TYPE_AUDIO, TYPE_VIDEO, TYPE_IMAGES};
    private final String schema;
    private final String descriptionKey;
    private final Set<String> exts;
    private final boolean isDefault;

    public MediaType(String string) {
        if (string == null) {
            throw new NullPointerException("schema must not be null");
        }
        this.schema = string;
        this.descriptionKey = null;
        this.exts = Collections.emptySet();
        this.isDefault = false;
    }

    public MediaType(String string, String string2, String[] stringArray) {
        if (string == null) {
            throw new NullPointerException("schema must not be null");
        }
        this.schema = string;
        this.descriptionKey = string2;
        this.isDefault = true;
        if (stringArray == null) {
            this.exts = Collections.emptySet();
        } else {
            TreeSet<String> treeSet = new TreeSet<String>(Comparators.caseInsensitiveStringComparator());
            treeSet.addAll(Arrays.asList(stringArray));
            this.exts = treeSet;
        }
    }

    public boolean matches(String string) {
        if (this.exts == null) {
            return true;
        }
        int n = string.lastIndexOf(".");
        if (n == -1 || n == string.length()) {
            return false;
        }
        String string2 = string.substring(n + 1);
        return this.exts.contains(string2);
    }

    public String toString() {
        return this.schema;
    }

    public String getDescriptionKey() {
        return this.descriptionKey;
    }

    public String getMimeType() {
        return this.schema;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public Set<String> getExtensions() {
        return this.exts;
    }

    public static final MediaType[] getDefaultMediaTypes() {
        return ALL_MEDIA_TYPES;
    }

    public static MediaType getMediaTypeForSchema(String string) {
        int n = ALL_MEDIA_TYPES.length;
        while (--n >= 0) {
            if (!string.equals(MediaType.ALL_MEDIA_TYPES[n].schema)) continue;
            return ALL_MEDIA_TYPES[n];
        }
        return null;
    }

    public static MediaType getMediaTypeForExtension(String string) {
        int n = ALL_MEDIA_TYPES.length;
        while (--n >= 0) {
            if (!MediaType.ALL_MEDIA_TYPES[n].exts.contains(string)) continue;
            return ALL_MEDIA_TYPES[n];
        }
        return null;
    }

    public static boolean isDefaultType(String string) {
        int n = ALL_MEDIA_TYPES.length;
        while (--n >= 0) {
            if (!string.equals(MediaType.ALL_MEDIA_TYPES[n].schema)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object instanceof MediaType) {
            MediaType mediaType = (MediaType)object;
            return this.schema.equals(mediaType.schema) && ((Object)this.exts).equals(mediaType.exts) && this.isDefault == mediaType.isDefault;
        }
        return false;
    }

    Object readResolve() throws ObjectStreamException {
        for (MediaType mediaType : ALL_MEDIA_TYPES) {
            if (!this.equals(mediaType)) continue;
            return mediaType;
        }
        return this;
    }

    public static MediaType getAnyTypeMediaType() {
        return TYPE_ANY;
    }

    public static MediaType getAudioMediaType() {
        return TYPE_AUDIO;
    }

    public static MediaType getVideoMediaType() {
        return TYPE_VIDEO;
    }

    public static MediaType getImageMediaType() {
        return TYPE_IMAGES;
    }

    public static MediaType getDocumentMediaType() {
        return TYPE_DOCUMENTS;
    }

    public static MediaType getProgramMediaType() {
        return TYPE_PROGRAMS;
    }

    public static Aggregator getAggregator(QueryRequest queryRequest) {
        if (queryRequest.desiresAll()) {
            return null;
        }
        Aggregator aggregator = new Aggregator();
        if (queryRequest.desiresLinuxOSXPrograms()) {
            aggregator.addFilter(MediaType.TYPE_LINUX_OSX_PROGRAMS);
        }
        if (queryRequest.desiresWindowsPrograms()) {
            aggregator.addFilter(MediaType.TYPE_WINDOWS_PROGRAMS);
        }
        if (queryRequest.desiresDocuments()) {
            aggregator.addFilter(MediaType.TYPE_DOCUMENTS);
        }
        if (queryRequest.desiresAudio()) {
            aggregator.addFilter(MediaType.TYPE_AUDIO);
        }
        if (queryRequest.desiresVideo()) {
            aggregator.addFilter(MediaType.TYPE_VIDEO);
        }
        if (queryRequest.desiresImages()) {
            aggregator.addFilter(MediaType.TYPE_IMAGES);
        }
        return aggregator;
    }

    private static String[] makeArray(Set<String> set, Set<String> set2) {
        HashSet<String> hashSet = new HashSet<String>(set);
        hashSet.addAll(set2);
        return hashSet.toArray(new String[hashSet.size()]);
    }

    public static class Aggregator {
        private List<MediaType> _filters = new LinkedList<MediaType>();

        private Aggregator() {
        }

        private void addFilter(MediaType mediaType) {
            this._filters.add(mediaType);
        }

        public boolean allow(String string) {
            for (MediaType mediaType : this._filters) {
                if (!mediaType.matches(string)) continue;
                return true;
            }
            return false;
        }
    }
}

