/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.ApplicationServices;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileDetails;
import com.limegroup.gnutella.LocalFileDetailsFactory;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Set;

@Singleton
public class LocalFileDetailsFactoryImpl
implements LocalFileDetailsFactory {
    private final NetworkManager networkManager;
    private final ApplicationServices applicationServices;

    @Inject
    public LocalFileDetailsFactoryImpl(NetworkManager networkManager, ApplicationServices applicationServices) {
        this.networkManager = networkManager;
        this.applicationServices = applicationServices;
    }

    public FileDetails create(final FileDesc fileDesc) {
        return new FileDetails(){

            @Override
            public String getFileName() {
                return fileDesc.getFileName();
            }

            @Override
            public long getFileSize() {
                return fileDesc.getFileSize();
            }

            @Override
            public InetSocketAddress getInetSocketAddress() {
                try {
                    return new InetSocketAddress(InetAddress.getByAddress(LocalFileDetailsFactoryImpl.this.networkManager.getAddress()), LocalFileDetailsFactoryImpl.this.networkManager.getPort());
                }
                catch (UnknownHostException unknownHostException) {
                    return null;
                }
            }

            @Override
            public boolean isFirewalled() {
                return !LocalFileDetailsFactoryImpl.this.networkManager.acceptedIncomingConnection();
            }

            @Override
            public URN getSHA1Urn() {
                return fileDesc.getSHA1Urn();
            }

            @Override
            public Set<URN> getUrns() {
                return fileDesc.getUrns();
            }

            @Override
            public LimeXMLDocument getXMLDocument() {
                return fileDesc.getXMLDocument();
            }

            @Override
            public byte[] getClientGUID() {
                return LocalFileDetailsFactoryImpl.this.applicationServices.getMyGUID();
            }
        };
    }
}

