/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.LimeProps;
import com.limegroup.gnutella.settings.SimppSettingsManager;
import com.limegroup.gnutella.simpp.SimppManager;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.limewire.mojito.settings.MojitoProps;
import org.limewire.util.CommonUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class LimeCoreGlue {
    private static AtomicBoolean preinstalled = new AtomicBoolean(false);
    private AtomicBoolean installed = new AtomicBoolean(false);
    private final Provider<SimppManager> simppManager;

    @Inject
    public LimeCoreGlue(Provider<SimppManager> provider) {
        this.simppManager = provider;
    }

    public static void preinstall() throws InstallFailedException {
        LimeCoreGlue.preinstall(null);
    }

    public static void preinstall(File file) throws InstallFailedException {
        if (!preinstalled.compareAndSet(false, true)) {
            return;
        }
        if (file == null) {
            file = LimeWireUtils.getRequestedUserSettingsLocation();
        }
        try {
            CommonUtils.setUserSettingsDir(file);
        }
        catch (IOException iOException) {
            try {
                File file2;
                LimeWireUtils.clearTemporarySettingsDirectories();
                try {
                    file2 = LimeWireUtils.getTemporarySettingsDirectory();
                }
                catch (IOException iOException2) {
                    iOException2.initCause(iOException);
                    throw iOException2;
                }
                file2.deleteOnExit();
                try {
                    CommonUtils.setUserSettingsDir(file2);
                }
                catch (IOException iOException3) {
                    iOException3.initCause(iOException);
                    throw iOException3;
                }
                LimeWireUtils.setTemporaryDirectoryInUse(true);
            }
            catch (IOException iOException4) {
                throw new InstallFailedException("Settings Directory Failure", iOException4);
            }
        }
    }

    public void install() {
        if (!this.installed.compareAndSet(false, true)) {
            return;
        }
        LimeCoreGlue.preinstall();
        SimppSettingsManager simppSettingsManager = new SimppSettingsManager();
        SimppSettingsManager simppSettingsManager2 = new SimppSettingsManager();
        ((SimppManager)this.simppManager.get()).addSimppSettingsManager(simppSettingsManager);
        ((SimppManager)this.simppManager.get()).addSimppSettingsManager(simppSettingsManager2);
        LimeProps.instance().getFactory().setRemoteSettingManager(simppSettingsManager);
        MojitoProps.instance().getFactory().setRemoteSettingManager(simppSettingsManager2);
        simppSettingsManager.updateSimppSettings(((SimppManager)this.simppManager.get()).getPropsString());
        simppSettingsManager2.updateSimppSettings(((SimppManager)this.simppManager.get()).getPropsString());
        if (ApplicationSettings.INITIALIZE_SIMPP.getValue()) {
            ((SimppManager)this.simppManager.get()).initialize();
        }
    }

    public static class InstallFailedException
    extends RuntimeException {
        public InstallFailedException() {
        }

        public InstallFailedException(String string, Throwable throwable) {
            super(string, throwable);
        }

        public InstallFailedException(String string) {
            super(string);
        }

        public InstallFailedException(Throwable throwable) {
            super(throwable);
        }
    }
}

