/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.gnutella.Acceptor;
import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.BrowseHostHandlerManager;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.ConnectionServices;
import com.limegroup.gnutella.ConnectionWatchdog;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.FileEventListener;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.HTTPAcceptor;
import com.limegroup.gnutella.HostCatcher;
import com.limegroup.gnutella.LifecycleManager;
import com.limegroup.gnutella.LimeCoreGlue;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.NodeAssigner;
import com.limegroup.gnutella.OutOfBandThroughputMeasurer;
import com.limegroup.gnutella.Pinger;
import com.limegroup.gnutella.QueryUnicaster;
import com.limegroup.gnutella.SavedFileManager;
import com.limegroup.gnutella.SpamServices;
import com.limegroup.gnutella.Statistics;
import com.limegroup.gnutella.UploadManager;
import com.limegroup.gnutella.altlocs.DownloaderGuidAlternateLocationFinder;
import com.limegroup.gnutella.auth.ContentManager;
import com.limegroup.gnutella.dht.DHTManager;
import com.limegroup.gnutella.dht.db.PushProxiesPublisher;
import com.limegroup.gnutella.downloader.PushDownloadManager;
import com.limegroup.gnutella.downloader.serial.conversion.DownloadUpgradeTask;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.licenses.LicenseFactory;
import com.limegroup.gnutella.messages.StaticMessages;
import com.limegroup.gnutella.rudp.messages.LimeRUDPMessageHandler;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.SSLSettings;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.simpp.SimppListener;
import com.limegroup.gnutella.simpp.SimppManager;
import com.limegroup.gnutella.spam.RatingTable;
import com.limegroup.gnutella.tigertree.HashTreeCache;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.concurrent.ThreadExecutor;
import org.limewire.i18n.I18nMarker;
import org.limewire.inspection.Inspectable;
import org.limewire.inspection.InspectablePrimitive;
import org.limewire.inspection.InspectionPoint;
import org.limewire.net.ConnectionAcceptor;
import org.limewire.net.ConnectionDispatcher;
import org.limewire.nio.ByteBufferCache;
import org.limewire.nio.ssl.SSLEngineTest;
import org.limewire.nio.ssl.SSLUtils;
import org.limewire.rudp.UDPMultiplexor;
import org.limewire.service.ErrorService;
import org.limewire.setting.SettingsGroupManager;
import org.limewire.statistic.StatisticAccumulator;
import org.limewire.util.OSUtils;
import org.limewire.util.SystemUtils;
import org.limewire.util.VersionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class LifecycleManagerImpl
implements LifecycleManager {
    private static final Log LOG = LogFactory.getLog(LifecycleManagerImpl.class);
    private final AtomicBoolean preinitializeBegin = new AtomicBoolean(false);
    private final AtomicBoolean preinitializeDone = new AtomicBoolean(false);
    private final AtomicBoolean backgroundBegin = new AtomicBoolean(false);
    private final AtomicBoolean backgroundDone = new AtomicBoolean(false);
    private final AtomicBoolean startBegin = new AtomicBoolean(false);
    private final AtomicBoolean startDone = new AtomicBoolean(false);
    private final AtomicBoolean shutdownBegin = new AtomicBoolean(false);
    private final AtomicBoolean shutdownDone = new AtomicBoolean(false);
    private final CountDownLatch startLatch = new CountDownLatch(1);
    private final Provider<IPFilter> ipFilter;
    private final Provider<SimppManager> simppManager;
    private final Provider<Acceptor> acceptor;
    private final Provider<ActivityCallback> activityCallback;
    private final Provider<ContentManager> contentManager;
    private final Provider<MessageRouter> messageRouter;
    private final Provider<UploadManager> uploadManager;
    private final Provider<HTTPAcceptor> httpUploadAcceptor;
    private final Provider<StaticMessages> staticMessages;
    private final Provider<ConnectionManager> connectionManager;
    private final Provider<DownloadManager> downloadManager;
    private final Provider<PushDownloadManager> pushDownloadManager;
    private final Provider<NodeAssigner> nodeAssigner;
    private final Provider<HostCatcher> hostCatcher;
    private final Provider<FileManager> fileManager;
    private final Provider<ConnectionDispatcher> connectionDispatcher;
    private final Provider<QueryUnicaster> queryUnicaster;
    private final Provider<Pinger> pinger;
    private final Provider<ConnectionWatchdog> connectionWatchdog;
    private final Provider<SavedFileManager> savedFileManager;
    private final Provider<RatingTable> ratingTable;
    private final Provider<UDPMultiplexor> udpMultiplexor;
    private final Provider<HashTreeCache> tigerTreeCache;
    private final Provider<DHTManager> dhtManager;
    private final Provider<ByteBufferCache> byteBufferCache;
    private final Provider<NetworkManager> networkManager;
    private final Provider<Statistics> statistics;
    private final Provider<ConnectionServices> connectionServices;
    private final Provider<SpamServices> spamServices;
    private final Provider<LimeCoreGlue> limeCoreGlue;
    private final Provider<OutOfBandThroughputMeasurer> outOfBandThroughputMeasurer;
    private final Provider<BrowseHostHandlerManager> browseHostHandlerManager;
    private final Provider<DownloadUpgradeTask> downloadUpgradeTask;
    private final Provider<StatisticAccumulator> statisticAccumulator;
    private final List<Thread> SHUTDOWN_ITEMS = Collections.synchronizedList(new LinkedList());
    @InspectablePrimitive(value="time lifecycle finished starting")
    private long startFinishedTime;
    private final Provider<LicenseFactory> licenseFactory;
    private final Provider<ConnectionDispatcher> localConnectionDispatcher;
    private final Provider<DownloaderGuidAlternateLocationFinder> magnetDownloaderPushEndpointFinder;
    private final Provider<PushProxiesPublisher> pushProxiesPublisher;
    @InspectionPoint(value="ungraceful shutdown details")
    private final Inspectable ungracefulShutdownDetails = new Inspectable(){

        public Object inspect() {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("JVM version", VersionUtils.getJavaVersion());
            hashMap.put("OS", OSUtils.getOS());
            hashMap.put("OS version", OSUtils.getOSVersion());
            hashMap.put("graceful shutdown", ApplicationSettings.PREVIOUS_SHUTDOWN_WAS_GRACEFUL.getValue());
            return hashMap;
        }
    };

    @Inject
    public LifecycleManagerImpl(Provider<IPFilter> provider, Provider<SimppManager> provider2, Provider<Acceptor> provider3, Provider<ActivityCallback> provider4, Provider<ContentManager> provider5, Provider<MessageRouter> provider6, Provider<UploadManager> provider7, Provider<HTTPAcceptor> provider8, Provider<StaticMessages> provider9, Provider<ConnectionManager> provider10, Provider<DownloadManager> provider11, Provider<PushDownloadManager> provider12, Provider<NodeAssigner> provider13, Provider<HostCatcher> provider14, Provider<FileManager> provider15, @Named(value="global") Provider<ConnectionDispatcher> provider16, @Named(value="local") Provider<ConnectionDispatcher> provider17, Provider<QueryUnicaster> provider18, Provider<Pinger> provider19, Provider<ConnectionWatchdog> provider20, Provider<SavedFileManager> provider21, Provider<RatingTable> provider22, Provider<UDPMultiplexor> provider23, Provider<HashTreeCache> provider24, Provider<DHTManager> provider25, Provider<ByteBufferCache> provider26, @Named(value="backgroundExecutor") Provider<ScheduledExecutorService> provider27, Provider<NetworkManager> provider28, Provider<Statistics> provider29, Provider<ConnectionServices> provider30, Provider<SpamServices> provider31, Provider<LicenseFactory> provider32, Provider<LimeCoreGlue> provider33, Provider<OutOfBandThroughputMeasurer> provider34, Provider<BrowseHostHandlerManager> provider35, Provider<DownloadUpgradeTask> provider36, Provider<StatisticAccumulator> provider37, Provider<DownloaderGuidAlternateLocationFinder> provider38, Provider<PushProxiesPublisher> provider39) {
        this.ipFilter = provider;
        this.simppManager = provider2;
        this.acceptor = provider3;
        this.activityCallback = provider4;
        this.contentManager = provider5;
        this.messageRouter = provider6;
        this.uploadManager = provider7;
        this.httpUploadAcceptor = provider8;
        this.staticMessages = provider9;
        this.connectionManager = provider10;
        this.downloadManager = provider11;
        this.pushDownloadManager = provider12;
        this.nodeAssigner = provider13;
        this.hostCatcher = provider14;
        this.fileManager = provider15;
        this.connectionDispatcher = provider16;
        this.localConnectionDispatcher = provider17;
        this.queryUnicaster = provider18;
        this.pinger = provider19;
        this.connectionWatchdog = provider20;
        this.savedFileManager = provider21;
        this.ratingTable = provider22;
        this.udpMultiplexor = provider23;
        this.tigerTreeCache = provider24;
        this.dhtManager = provider25;
        this.byteBufferCache = provider26;
        this.networkManager = provider28;
        this.statistics = provider29;
        this.connectionServices = provider30;
        this.spamServices = provider31;
        this.licenseFactory = provider32;
        this.limeCoreGlue = provider33;
        this.outOfBandThroughputMeasurer = provider34;
        this.browseHostHandlerManager = provider35;
        this.downloadUpgradeTask = provider36;
        this.statisticAccumulator = provider37;
        this.magnetDownloaderPushEndpointFinder = provider38;
        this.pushProxiesPublisher = provider39;
    }

    @Override
    public boolean isLoaded() {
        State state = this.getCurrentState();
        return state == State.STARTED || state == State.STARTING;
    }

    @Override
    public boolean isStarted() {
        State state = this.getCurrentState();
        return state == State.STARTED || state == State.STOPPED;
    }

    @Override
    public boolean isShutdown() {
        return this.getCurrentState() == State.STOPPED;
    }

    @Override
    public void installListeners() {
        if (this.preinitializeBegin.getAndSet(true)) {
            return;
        }
        LimeCoreGlue.preinstall();
        ((FileManager)this.fileManager.get()).addFileEventListener((FileEventListener)this.activityCallback.get());
        LimeRUDPMessageHandler limeRUDPMessageHandler = new LimeRUDPMessageHandler((UDPMultiplexor)this.udpMultiplexor.get());
        limeRUDPMessageHandler.install((MessageRouter)this.messageRouter.get());
        ((ConnectionManager)this.connectionManager.get()).addEventListener((EventListener)this.activityCallback.get());
        ((ConnectionManager)this.connectionManager.get()).addEventListener((EventListener)this.dhtManager.get());
        LOG.debug((Object)"Installing push proxies publisher");
        ((DHTManager)this.dhtManager.get()).addEventListener((EventListener)this.pushProxiesPublisher.get());
        this.preinitializeDone.set(true);
    }

    @Override
    public void loadBackgroundTasks() {
        if (this.backgroundBegin.getAndSet(true)) {
            return;
        }
        this.installListeners();
        ThreadExecutor.startThread(new Runnable(){

            public void run() {
                LifecycleManagerImpl.this.doBackgroundTasks();
            }
        }, "BackgroundTasks");
    }

    private void loadBackgroundTasksBlocking() {
        if (this.backgroundBegin.getAndSet(true)) {
            return;
        }
        this.installListeners();
        this.doBackgroundTasks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        if (this.startBegin.getAndSet(true)) {
            return;
        }
        try {
            this.doStart();
        }
        finally {
            this.startLatch.countDown();
        }
    }

    void doStart() {
        int n;
        if (ApplicationSettings.CURRENTLY_RUNNING.getValue()) {
            ApplicationSettings.PREVIOUS_SHUTDOWN_WAS_GRACEFUL.setValue(false);
        } else {
            ApplicationSettings.PREVIOUS_SHUTDOWN_WAS_GRACEFUL.setValue(true);
        }
        ApplicationSettings.CURRENTLY_RUNNING.setValue(true);
        SettingsGroupManager.instance().save();
        this.loadBackgroundTasksBlocking();
        LOG.trace((Object)"START RouterService");
        ((StatisticAccumulator)this.statisticAccumulator.get()).start();
        if (SSLSettings.isIncomingTLSEnabled() || SSLSettings.isOutgoingTLSEnabled()) {
            LOG.trace((Object)"START SSL Test");
            ((ActivityCallback)this.activityCallback.get()).componentLoading(I18nMarker.marktr("Loading TLS Encryption..."));
            SSLEngineTest sSLEngineTest = new SSLEngineTest(SSLUtils.getTLSContext(), SSLUtils.getTLSCipherSuites(), (ByteBufferCache)this.byteBufferCache.get());
            if (!sSLEngineTest.go()) {
                Throwable throwable = sSLEngineTest.getLastFailureCause();
                SSLSettings.disableTLS(throwable);
                if (!SSLSettings.IGNORE_SSL_EXCEPTIONS.getValue() && !sSLEngineTest.isIgnorable(throwable)) {
                    ErrorService.error(throwable);
                }
            }
            LOG.trace((Object)"END SSL Test");
        }
        LOG.trace((Object)"START ContentManager");
        ((ActivityCallback)this.activityCallback.get()).componentLoading(I18nMarker.marktr("Loading Safe Content Management..."));
        ((ContentManager)this.contentManager.get()).start();
        LOG.trace((Object)"STOP ContentManager");
        LOG.trace((Object)"START MessageRouter");
        ((ActivityCallback)this.activityCallback.get()).componentLoading(I18nMarker.marktr("Loading Message Router..."));
        ((MessageRouter)this.messageRouter.get()).start();
        LOG.trace((Object)"STOPMessageRouter");
        LOG.trace((Object)"START HTTPUploadManager");
        ((ActivityCallback)this.activityCallback.get()).componentLoading(I18nMarker.marktr("Loading Upload Management..."));
        ((UploadManager)this.uploadManager.get()).start();
        LOG.trace((Object)"STOP HTTPUploadManager");
        LOG.trace((Object)"START HTTPUploadAcceptor");
        ((HTTPAcceptor)this.httpUploadAcceptor.get()).start();
        ((ConnectionDispatcher)this.connectionDispatcher.get()).addConnectionAcceptor((ConnectionAcceptor)this.httpUploadAcceptor.get(), false, ((HTTPAcceptor)this.httpUploadAcceptor.get()).getHttpMethods());
        LOG.trace((Object)"STOP HTTPUploadAcceptor");
        LOG.trace((Object)"START NetworkManager");
        ((NetworkManager)this.networkManager.get()).start();
        LOG.trace((Object)"STOP NetworkManager");
        LOG.trace((Object)"START Acceptor");
        ((ActivityCallback)this.activityCallback.get()).componentLoading(I18nMarker.marktr("Loading Connection Listener..."));
        ((Acceptor)this.acceptor.get()).start();
        LOG.trace((Object)"STOP Acceptor");
        LOG.trace((Object)"START loading StaticMessages");
        ((StaticMessages)this.staticMessages.get()).initialize();
        LOG.trace((Object)"END loading StaticMessages");
        LOG.trace((Object)"START ConnectionManager");
        ((ActivityCallback)this.activityCallback.get()).componentLoading(I18nMarker.marktr("Loading Connection Management..."));
        ((ConnectionManager)this.connectionManager.get()).initialize();
        LOG.trace((Object)"STOP ConnectionManager");
        LOG.trace((Object)"Running download upgrade task");
        ((DownloadUpgradeTask)this.downloadUpgradeTask.get()).upgrade();
        LOG.trace((Object)"Download upgrade task run!");
        LOG.trace((Object)"START DownloadManager");
        ((ActivityCallback)this.activityCallback.get()).componentLoading(I18nMarker.marktr("Loading Download Management..."));
        ((DownloadManager)this.downloadManager.get()).initialize();
        ((ConnectionDispatcher)this.connectionDispatcher.get()).addConnectionAcceptor((ConnectionAcceptor)this.pushDownloadManager.get(), false, "GIV");
        LOG.trace((Object)"STOP DownloadManager");
        LOG.trace((Object)"START NodeAssigner");
        ((ActivityCallback)this.activityCallback.get()).componentLoading(I18nMarker.marktr("Loading Ultrapeer/DHT Management..."));
        ((NodeAssigner)this.nodeAssigner.get()).start();
        LOG.trace((Object)"STOP NodeAssigner");
        LOG.trace((Object)"START HostCatcher.initialize");
        ((ActivityCallback)this.activityCallback.get()).componentLoading(I18nMarker.marktr("Locating Peers..."));
        ((HostCatcher)this.hostCatcher.get()).initialize();
        LOG.trace((Object)"STOP HostCatcher.initialize");
        if (ConnectionSettings.CONNECT_ON_STARTUP.getValue() && (n = ConnectionSettings.NUM_CONNECTIONS.getValue()) > 0) {
            LOG.trace((Object)"START connect");
            ((ConnectionServices)this.connectionServices.get()).connect();
            LOG.trace((Object)"STOP connect");
        }
        LOG.trace((Object)"START FileManager");
        ((ActivityCallback)this.activityCallback.get()).componentLoading(I18nMarker.marktr("Loading Shared Files..."));
        ((FileManager)this.fileManager.get()).start();
        LOG.trace((Object)"STOP FileManager");
        ((DownloadManager)this.downloadManager.get()).addListener((org.limewire.listener.EventListener)this.magnetDownloaderPushEndpointFinder.get());
        LOG.trace((Object)"START DownloadManager.postGuiInit");
        ((ActivityCallback)this.activityCallback.get()).componentLoading(I18nMarker.marktr("Loading Old Downloads..."));
        ((DownloadManager)this.downloadManager.get()).loadSavedDownloadsAndScheduleWriting();
        LOG.trace((Object)"STOP DownloadManager.postGuiInit");
        LOG.trace((Object)"START QueryUnicaster");
        ((ActivityCallback)this.activityCallback.get()).componentLoading(I18nMarker.marktr("Loading Directed Querier..."));
        ((QueryUnicaster)this.queryUnicaster.get()).start();
        LOG.trace((Object)"STOP QueryUnicaster");
        LOG.trace((Object)"START Pinger");
        ((ActivityCallback)this.activityCallback.get()).componentLoading(I18nMarker.marktr("Loading Peer Listener..."));
        ((Pinger)this.pinger.get()).start();
        LOG.trace((Object)"STOP Pinger");
        LOG.trace((Object)"START ConnectionWatchdog");
        ((ActivityCallback)this.activityCallback.get()).componentLoading(I18nMarker.marktr("Loading Stale Connection Management..."));
        ((ConnectionWatchdog)this.connectionWatchdog.get()).start();
        LOG.trace((Object)"STOP ConnectionWatchdog");
        LOG.trace((Object)"START SavedFileManager");
        ((ActivityCallback)this.activityCallback.get()).componentLoading(I18nMarker.marktr("Loading Saved Files..."));
        this.savedFileManager.get();
        LOG.trace((Object)"STOP SavedFileManager");
        LOG.trace((Object)"START loading spam data");
        ((ActivityCallback)this.activityCallback.get()).componentLoading(I18nMarker.marktr("Loading Spam Management..."));
        this.ratingTable.get();
        LOG.trace((Object)"START loading spam data");
        LOG.trace((Object)"START register connection dispatchers");
        ((ActivityCallback)this.activityCallback.get()).componentLoading(I18nMarker.marktr("Loading Network Listeners..."));
        this.initializeConnectionDispatcher();
        LOG.trace((Object)"STOP register connection dispatchers");
        LOG.trace((Object)"START Random Initializings");
        ((OutOfBandThroughputMeasurer)this.outOfBandThroughputMeasurer.get()).initialize();
        ((BrowseHostHandlerManager)this.browseHostHandlerManager.get()).initialize();
        LOG.trace((Object)"STOP Random Initializings");
        if (ApplicationSettings.AUTOMATIC_MANUAL_GC.getValue()) {
            this.startManualGCThread();
        }
        LOG.trace((Object)"STOP RouterService.");
        this.startDone.set(true);
        this.startFinishedTime = System.currentTimeMillis();
    }

    private void initializeConnectionDispatcher() {
    }

    private void initializeLocalConnectionDispatcher() {
    }

    @Override
    public void shutdown() {
        try {
            this.doShutdown();
        }
        catch (Throwable throwable) {
            ErrorService.error(throwable);
        }
    }

    private void doShutdown() {
        if (!this.startBegin.get() || this.shutdownBegin.getAndSet(true)) {
            return;
        }
        try {
            this.startLatch.await();
        }
        catch (InterruptedException interruptedException) {
            LOG.error((Object)"Interrupted while waiting to finish starting", (Throwable)interruptedException);
            return;
        }
        ((NodeAssigner)this.nodeAssigner.get()).stop();
        ((DHTManager)this.dhtManager.get()).stop();
        try {
            ((Acceptor)this.acceptor.get()).setListeningPort(0);
        }
        catch (IOException iOException) {
            LOG.error((Object)"Error stopping acceptor", (Throwable)iOException);
        }
        ((Acceptor)this.acceptor.get()).shutdown();
        ((ConnectionManager)this.connectionManager.get()).disconnect(false);
        ((Statistics)this.statistics.get()).shutdown();
        ApplicationSettings.CURRENTLY_RUNNING.setValue(false);
        ConnectionSettings.EVER_ACCEPTED_INCOMING.setValue(((NetworkManager)this.networkManager.get()).acceptedIncomingConnection());
        try {
            ((HostCatcher)this.hostCatcher.get()).write();
        }
        catch (IOException iOException) {
            LOG.error((Object)"Error saving host catcher file", (Throwable)iOException);
        }
        SettingsGroupManager.instance().save();
        ((RatingTable)this.ratingTable.get()).ageAndSave();
        this.cleanupPreviewFiles();
        ((DownloadManager)this.downloadManager.get()).writeSnapshot();
        ((DownloadManager)this.downloadManager.get()).removeListener((org.limewire.listener.EventListener)this.magnetDownloaderPushEndpointFinder.get());
        ((FileManager)this.fileManager.get()).stop();
        ((HashTreeCache)this.tigerTreeCache.get()).persistCache((FileManager)this.fileManager.get(), (DownloadManager)this.downloadManager.get());
        ((LicenseFactory)this.licenseFactory.get()).persistCache();
        ((ContentManager)this.contentManager.get()).stop();
        ((MessageRouter)this.messageRouter.get()).stop();
        ((StatisticAccumulator)this.statisticAccumulator.get()).stop();
        this.runShutdownItems();
        this.shutdownDone.set(true);
    }

    private static String parseCommand(String string) {
        if (string.startsWith("\"")) {
            int n = string.indexOf("\"", 1);
            if (n > -1) {
                return string.substring(0, n + 1);
            }
            return string + "\"";
        }
        int n = string.indexOf(" ");
        if (n > -1) {
            return string.substring(0, n);
        }
        return string;
    }

    @Override
    public void shutdown(String string) {
        this.shutdown();
        if (string != null) {
            try {
                if (OSUtils.isWindowsVista()) {
                    String string2 = LifecycleManagerImpl.parseCommand(string).trim();
                    String string3 = string.substring(string2.length()).trim();
                    SystemUtils.openFile(string2, string3);
                } else {
                    Runtime.getRuntime().exec(string);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public long getStartFinishedTime() {
        return this.startFinishedTime;
    }

    @Override
    public boolean addShutdownItem(Thread thread) {
        if (this.shutdownBegin.get()) {
            return false;
        }
        this.SHUTDOWN_ITEMS.add(thread);
        return true;
    }

    private void runShutdownItems() {
        if (!this.shutdownBegin.get()) {
            return;
        }
        for (Thread thread : this.SHUTDOWN_ITEMS) {
            thread.start();
        }
        for (Thread thread : this.SHUTDOWN_ITEMS) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void doBackgroundTasks() {
        ((LimeCoreGlue)this.limeCoreGlue.get()).install();
        ((IPFilter)this.ipFilter.get()).refreshHosts(new IPFilter.IPFilterCallback(){

            public void ipFiltersLoaded() {
                ((SpamServices)LifecycleManagerImpl.this.spamServices.get()).adjustSpamFilters();
            }
        });
        ((SimppManager)this.simppManager.get()).addListener(new SimppListener(){

            public void simppUpdated(int n) {
                ((SpamServices)LifecycleManagerImpl.this.spamServices.get()).reloadIPFilter();
            }
        });
        ((Acceptor)this.acceptor.get()).init();
        this.backgroundDone.set(true);
    }

    private State getCurrentState() {
        if (this.shutdownBegin.get()) {
            return State.STOPPED;
        }
        if (this.startDone.get()) {
            return State.STARTED;
        }
        if (this.startBegin.get()) {
            return State.STARTING;
        }
        return State.NONE;
    }

    private void startManualGCThread() {
        Thread thread = ThreadExecutor.newManagedThread(new Runnable(){

            public void run() {
                while (true) {
                    try {
                        Thread.sleep(300000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    LOG.trace((Object)"Running GC");
                    System.gc();
                    LOG.trace((Object)"GC finished, running finalizers");
                    System.runFinalization();
                    LOG.trace((Object)"Finalizers finished.");
                }
            }
        }, "ManualGC");
        thread.setDaemon(true);
        thread.start();
        LOG.trace((Object)"Started manual GC thread.");
    }

    private void cleanupPreviewFiles() {
        File file = SharingSettings.INCOMPLETE_DIRECTORY.getValue();
        if (file == null) {
            return;
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            String string = fileArray[i].getName();
            if (!string.startsWith("Preview-")) continue;
            fileArray[i].delete();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        NONE,
        STARTING,
        STARTED,
        STOPPED;

    }
}

