/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.ConnectionServices;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.ExtendedEndpoint;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.MessageListener;
import com.limegroup.gnutella.MulticastService;
import com.limegroup.gnutella.QueryUnicaster;
import com.limegroup.gnutella.UDPPinger;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.UniqueHostPinger;
import com.limegroup.gnutella.bootstrap.TcpBootstrap;
import com.limegroup.gnutella.bootstrap.UDPHostCache;
import com.limegroup.gnutella.bootstrap.UDPHostCacheFactory;
import com.limegroup.gnutella.dht.DHTManager;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingReply;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.messages.PingRequestFactory;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.util.ClassCNetworks;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.BucketQueue;
import org.limewire.collection.Cancellable;
import org.limewire.collection.FixedSizeSortedList;
import org.limewire.collection.IntSet;
import org.limewire.collection.ListPartitioner;
import org.limewire.collection.RandomAccessMap;
import org.limewire.collection.RandomOrderHashMap;
import org.limewire.inspection.Inspectable;
import org.limewire.inspection.InspectableContainer;
import org.limewire.inspection.InspectionPoint;
import org.limewire.io.Connectable;
import org.limewire.io.IpPort;
import org.limewire.io.IpPortSet;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.io.NetworkUtils;
import org.limewire.util.CommonUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class HostCatcher {
    private static final Log LOG = LogFactory.getLog(HostCatcher.class);
    static final int GOOD_SIZE = 1000;
    static final int NORMAL_SIZE = 400;
    static final int PERMANENT_SIZE = 400;
    public static final int GOOD_PRIORITY = 1;
    public static final int NORMAL_PRIORITY = 0;
    public static final int PONG_MASK = -256;
    private static final Comparator<ExtendedEndpoint> DHT_COMPARATOR = new Comparator<ExtendedEndpoint>(){

        @Override
        public int compare(ExtendedEndpoint extendedEndpoint, ExtendedEndpoint extendedEndpoint2) {
            DHTManager.DHTMode dHTMode = extendedEndpoint.getDHTMode();
            DHTManager.DHTMode dHTMode2 = extendedEndpoint2.getDHTMode();
            if (dHTMode.equals((Object)DHTManager.DHTMode.ACTIVE) && !dHTMode2.equals((Object)DHTManager.DHTMode.ACTIVE) || dHTMode.equals((Object)DHTManager.DHTMode.PASSIVE) && dHTMode2.equals((Object)DHTManager.DHTMode.INACTIVE)) {
                return -1;
            }
            if (dHTMode2.equals((Object)DHTManager.DHTMode.ACTIVE) && !dHTMode.equals((Object)DHTManager.DHTMode.ACTIVE) || dHTMode2.equals((Object)DHTManager.DHTMode.PASSIVE) && dHTMode.equals((Object)DHTManager.DHTMode.INACTIVE)) {
                return 1;
            }
            return 0;
        }
    };
    private final BucketQueue<ExtendedEndpoint> ENDPOINT_QUEUE = new BucketQueue(new int[]{400, 1000});
    private final Map<ExtendedEndpoint, ExtendedEndpoint> ENDPOINT_SET = new HashMap<ExtendedEndpoint, ExtendedEndpoint>();
    private final RandomAccessMap<ExtendedEndpoint, ExtendedEndpoint> FREE_ULTRAPEER_SLOTS_SET = new RandomOrderHashMap<ExtendedEndpoint, ExtendedEndpoint>(200);
    private final RandomAccessMap<ExtendedEndpoint, ExtendedEndpoint> FREE_LEAF_SLOTS_SET = new RandomOrderHashMap<ExtendedEndpoint, ExtendedEndpoint>(200);
    private final Map<String, Set<ExtendedEndpoint>> LOCALE_SET_MAP = new HashMap<String, Set<ExtendedEndpoint>>();
    private static final int LOCALE_SET_SIZE = 100;
    private final FixedSizeSortedList<ExtendedEndpoint> permanentHosts = new FixedSizeSortedList<ExtendedEndpoint>(ExtendedEndpoint.priorityComparator(), 400);
    private final Set<ExtendedEndpoint> permanentHostsSet = new HashSet<ExtendedEndpoint>();
    private final List<ExtendedEndpoint> restoredHosts = new FixedSizeSortedList<ExtendedEndpoint>(ExtendedEndpoint.priorityComparator(), 400);
    private final ListPartitioner<ExtendedEndpoint> uptimePartitions = new ListPartitioner<ExtendedEndpoint>(this.restoredHosts, 3);
    private UDPHostCache udpHostCache;
    private int _failures;
    private final Set<Endpoint> EXPIRED_HOSTS = new HashSet<Endpoint>();
    private final Set<Endpoint> PROBATION_HOSTS = new HashSet<Endpoint>();
    private static long PROBATION_RECOVERY_WAIT_TIME = 60000L;
    private static long PROBATION_RECOVERY_TIME = 60000L;
    public static final int PROBATION_HOSTS_SIZE = 500;
    public static final int EXPIRED_HOSTS_SIZE = 500;
    public final Bootstrapper FETCHER = new Bootstrapper();
    private List<EndpointObserver> _catchersWaiting = new LinkedList<EndpointObserver>();
    private long lastAllowedPongRankTime = 0L;
    private final long PONG_RANKING_EXPIRE_TIME = 20000L;
    private static final int MAX_CONNECTIONS = 5;
    private final Random RND = new Random();
    private boolean dirty = false;
    private final ScheduledExecutorService backgroundExecutor;
    private final ConnectionServices connectionServices;
    private final Provider<ConnectionManager> connectionManager;
    private final Provider<UDPService> udpService;
    private final Provider<DHTManager> dhtManager;
    private final Provider<QueryUnicaster> queryUnicaster;
    private final Provider<IPFilter> ipFilter;
    private final Provider<MulticastService> multicastService;
    private final UniqueHostPinger uniqueHostPinger;
    private final NetworkInstanceUtils networkInstanceUtils;
    private final PingRequestFactory pingRequestFactory;
    private final TcpBootstrap tcpBootstrap;
    static boolean DEBUG = false;

    @Inject
    public HostCatcher(@Named(value="backgroundExecutor") ScheduledExecutorService scheduledExecutorService, ConnectionServices connectionServices, Provider<ConnectionManager> provider, Provider<UDPService> provider2, Provider<DHTManager> provider3, Provider<QueryUnicaster> provider4, @Named(value="hostileFilter") Provider<IPFilter> provider5, Provider<MulticastService> provider6, UniqueHostPinger uniqueHostPinger, UDPHostCacheFactory uDPHostCacheFactory, PingRequestFactory pingRequestFactory, NetworkInstanceUtils networkInstanceUtils, TcpBootstrap tcpBootstrap) {
        this.backgroundExecutor = scheduledExecutorService;
        this.connectionServices = connectionServices;
        this.connectionManager = provider;
        this.udpService = provider2;
        this.dhtManager = provider3;
        this.queryUnicaster = provider4;
        this.ipFilter = provider5;
        this.multicastService = provider6;
        this.uniqueHostPinger = uniqueHostPinger;
        this.pingRequestFactory = pingRequestFactory;
        this.networkInstanceUtils = networkInstanceUtils;
        this.tcpBootstrap = tcpBootstrap;
        this.udpHostCache = uDPHostCacheFactory.createUDPHostCache(uniqueHostPinger);
    }

    UDPHostCache getUdpHostCache() {
        return this.udpHostCache;
    }

    public void initialize() {
        LOG.trace((Object)"START scheduling");
        this.scheduleServices();
    }

    protected void scheduleServices() {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ArrayList arrayList;
                LOG.trace((Object)"restoring hosts on probation");
                HostCatcher hostCatcher = HostCatcher.this;
                synchronized (hostCatcher) {
                    arrayList = new ArrayList(HostCatcher.this.PROBATION_HOSTS);
                    HostCatcher.this.PROBATION_HOSTS.clear();
                }
                for (Endpoint endpoint : arrayList) {
                    HostCatcher.this.add(endpoint, false);
                }
            }
        };
        this.backgroundExecutor.scheduleWithFixedDelay(runnable, PROBATION_RECOVERY_WAIT_TIME, PROBATION_RECOVERY_TIME, TimeUnit.MILLISECONDS);
        this.backgroundExecutor.scheduleWithFixedDelay(this.FETCHER, 0L, 2000L, TimeUnit.MILLISECONDS);
        LOG.trace((Object)"STOP scheduling");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendUDPPings() {
        ArrayList<ExtendedEndpoint> arrayList;
        HostCatcher hostCatcher = this;
        synchronized (hostCatcher) {
            arrayList = new ArrayList<ExtendedEndpoint>(this.ENDPOINT_SET.size() + this.restoredHosts.size());
            arrayList.addAll(this.ENDPOINT_SET.keySet());
            arrayList.addAll(this.restoredHosts);
        }
        Collections.shuffle(arrayList);
        this.rank(arrayList);
    }

    private void rank(Collection<? extends IpPort> collection) {
        if (this.needsPongRanking()) {
            this.uniqueHostPinger.rank(collection, new Cancellable(){

                public boolean isCancelled() {
                    return !HostCatcher.this.needsPongRanking();
                }
            });
        }
    }

    public void sendMessageToAllHosts(Message message, MessageListener messageListener, Cancellable cancellable) {
        this.uniqueHostPinger.rank(this.getAllHosts(), messageListener, cancellable, message);
    }

    private synchronized Collection<ExtendedEndpoint> getAllHosts() {
        LinkedHashSet<ExtendedEndpoint> linkedHashSet = new LinkedHashSet<ExtendedEndpoint>(this.getNumHosts());
        linkedHashSet.addAll(this.FREE_ULTRAPEER_SLOTS_SET.keySet());
        linkedHashSet.addAll(this.FREE_LEAF_SLOTS_SET.keySet());
        linkedHashSet.addAll(this.ENDPOINT_SET.keySet());
        linkedHashSet.addAll(this.restoredHosts);
        return linkedHashSet;
    }

    public synchronized List<ExtendedEndpoint> getDHTSupportEndpoint(int n) {
        ArrayList<ExtendedEndpoint> arrayList = new ArrayList<ExtendedEndpoint>();
        IntSet intSet = new IntSet();
        for (ExtendedEndpoint extendedEndpoint : this.getAllHosts()) {
            if (!extendedEndpoint.supportsDHT() || extendedEndpoint.getDHTVersion() < n || ConnectionSettings.FILTER_CLASS_C.getValue() && !intSet.add(NetworkUtils.getMaskedIP(extendedEndpoint.getInetAddress(), -256))) continue;
            arrayList.add(extendedEndpoint);
        }
        Collections.sort(arrayList, DHT_COMPARATOR);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean needsPongRanking() {
        int n;
        HostCatcher hostCatcher;
        if (this.connectionServices.isFullyConnected()) {
            return false;
        }
        int n2 = ((ConnectionManager)this.connectionManager.get()).getInitializedConnections().size();
        if (n2 >= 5) {
            return false;
        }
        long l = System.currentTimeMillis();
        if (l > this.lastAllowedPongRankTime) {
            return false;
        }
        if (this.connectionServices.isSupernode()) {
            hostCatcher = this;
            synchronized (hostCatcher) {
                n = this.FREE_ULTRAPEER_SLOTS_SET.size();
            }
        }
        hostCatcher = this;
        synchronized (hostCatcher) {
            n = this.FREE_LEAF_SLOTS_SET.size();
        }
        int n3 = ((ConnectionManager)this.connectionManager.get()).getPreferredConnectionCount();
        return n < n3 - n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void read(File file) throws FileNotFoundException, IOException {
        LOG.trace((Object)"entered HostCatcher.read(File)");
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            while (true) {
                String string = bufferedReader.readLine();
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("read line: " + string));
                }
                if (string == null) {
                    break;
                }
                try {
                    ExtendedEndpoint extendedEndpoint = ExtendedEndpoint.read(string);
                    if (extendedEndpoint.isUDPHostCache()) {
                        this.addUDPHostCache(extendedEndpoint);
                        continue;
                    }
                    if (!this.isValidHost(extendedEndpoint)) continue;
                    HostCatcher hostCatcher = this;
                    synchronized (hostCatcher) {
                        this.addPermanent(extendedEndpoint);
                        this.restoredHosts.add(extendedEndpoint);
                    }
                    this.endpointAdded();
                }
                catch (ParseException parseException) {}
            }
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {}
        }
        LOG.trace((Object)"left HostCatcher.read(File)");
    }

    synchronized void write() throws IOException {
        this.write(this.getHostsFile());
    }

    synchronized void write(File file) throws IOException {
        this.repOk();
        if (this.dirty || this.udpHostCache.isWriteDirty()) {
            FileWriter fileWriter = new FileWriter(file);
            this.udpHostCache.write(fileWriter);
            for (ExtendedEndpoint extendedEndpoint : this.permanentHosts) {
                extendedEndpoint.write(fileWriter);
            }
            fileWriter.close();
        }
    }

    public boolean add(PingReply pingReply) {
        ExtendedEndpoint extendedEndpoint;
        Object object;
        Object object2;
        Object object3;
        if (pingReply.isUDP() && !((GUID)(object3 = new GUID(pingReply.getGUID()))).equals(PingRequest.UDP_GUID) && !((GUID)object3).equals(((UDPService)this.udpService.get()).getSolicitedGUID())) {
            return false;
        }
        object3 = pingReply.getDailyUptime() != -1 ? new ExtendedEndpoint(pingReply.getAddress(), pingReply.getPort(), pingReply.getDailyUptime()) : new ExtendedEndpoint(pingReply.getAddress(), pingReply.getPort());
        if (!pingReply.getClientLocale().equals("")) {
            ((ExtendedEndpoint)object3).setClientLocale(pingReply.getClientLocale());
        }
        if (pingReply.isUDPHostCache()) {
            ((Endpoint)object3).setHostname(pingReply.getUDPCacheAddress());
            ((ExtendedEndpoint)object3).setUDPHostCache(true);
        }
        if (!this.isValidHost((Endpoint)object3)) {
            return false;
        }
        int n = pingReply.getDHTVersion();
        if (n > -1) {
            object2 = pingReply.getDHTMode();
            ((ExtendedEndpoint)object3).setDHTVersion(n);
            ((ExtendedEndpoint)object3).setDHTMode((DHTManager.DHTMode)((Object)object2));
            if (((DHTManager)this.dhtManager.get()).isRunning()) {
                if (((Enum)object2).equals((Object)DHTManager.DHTMode.ACTIVE)) {
                    object = new InetSocketAddress(((Endpoint)object3).getAddress(), ((Endpoint)object3).getPort());
                    ((DHTManager)this.dhtManager.get()).addActiveDHTNode((SocketAddress)object);
                } else if (((Enum)object2).equals((Object)DHTManager.DHTMode.PASSIVE)) {
                    object = new InetSocketAddress(((Endpoint)object3).getAddress(), ((Endpoint)object3).getPort());
                    ((DHTManager)this.dhtManager.get()).addPassiveDHTNode((SocketAddress)object);
                }
            }
        }
        if (pingReply.supportsUnicast()) {
            ((QueryUnicaster)this.queryUnicaster.get()).addUnicastEndpoint(pingReply.getInetAddress(), pingReply.getPort());
        }
        object2 = ConnectionSettings.FILTER_CLASS_C.getValue() ? NetworkUtils.filterOnePerClassC(pingReply.getPackedIPPorts()) : pingReply.getPackedIPPorts();
        this.rank((Collection<? extends IpPort>)object2);
        object = object2.iterator();
        while (object.hasNext()) {
            IpPort ipPort = (IpPort)object.next();
            if (ipPort instanceof ExtendedEndpoint) {
                extendedEndpoint = (ExtendedEndpoint)ipPort;
            } else {
                extendedEndpoint = new ExtendedEndpoint(ipPort.getAddress(), ipPort.getPort());
                if (ipPort instanceof Connectable) {
                    extendedEndpoint.setTLSCapable(((Connectable)ipPort).isTLSCapable());
                }
            }
            if (!this.isValidHost(extendedEndpoint)) continue;
            this.add(extendedEndpoint, 1);
        }
        for (IpPort ipPort : pingReply.getPackedUDPHostCaches()) {
            extendedEndpoint = new ExtendedEndpoint(ipPort.getAddress(), ipPort.getPort());
            extendedEndpoint.setUDPHostCache(true);
            this.addUDPHostCache(extendedEndpoint);
        }
        if (((ExtendedEndpoint)object3).isUDPHostCache()) {
            return this.addUDPHostCache((ExtendedEndpoint)object3);
        }
        if (pingReply.isTLSCapable()) {
            ((ExtendedEndpoint)object3).setTLSCapable(true);
        }
        if (pingReply.isUltrapeer()) {
            if (pingReply.hasFreeLeafSlots()) {
                this.addToFreeSlotSet((ExtendedEndpoint)object3, this.FREE_LEAF_SLOTS_SET);
                if (!pingReply.hasFreeUltrapeerSlots()) {
                    return true;
                }
            }
            if (pingReply.hasFreeUltrapeerSlots() || ApplicationSettings.LANGUAGE.getValue().equals(pingReply.getClientLocale()) && pingReply.getNumFreeLocaleSlots() > 0) {
                this.addToFreeSlotSet((ExtendedEndpoint)object3, this.FREE_ULTRAPEER_SLOTS_SET);
                return true;
            }
            return this.add((ExtendedEndpoint)object3, 1);
        }
        return this.add((ExtendedEndpoint)object3, 0);
    }

    private boolean addUDPHostCache(ExtendedEndpoint extendedEndpoint) {
        return this.udpHostCache.add(extendedEndpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToFreeSlotSet(ExtendedEndpoint extendedEndpoint, Map<? super ExtendedEndpoint, ? super ExtendedEndpoint> map) {
        HostCatcher hostCatcher = this;
        synchronized (hostCatcher) {
            map.put(extendedEndpoint, extendedEndpoint);
            this.addPermanent(extendedEndpoint);
        }
        this.endpointAdded();
    }

    private synchronized void addToLocaleMap(ExtendedEndpoint extendedEndpoint) {
        String string = extendedEndpoint.getClientLocale();
        if (this.LOCALE_SET_MAP.containsKey(string)) {
            Set<ExtendedEndpoint> set = this.LOCALE_SET_MAP.get(string);
            if (set.add(extendedEndpoint) && set.size() > 100) {
                set.remove(set.iterator().next());
            }
        } else {
            HashSet<ExtendedEndpoint> hashSet = new HashSet<ExtendedEndpoint>();
            hashSet.add(extendedEndpoint);
            this.LOCALE_SET_MAP.put(string, hashSet);
        }
    }

    public int add(Collection<? extends Endpoint> collection) {
        this.rank(collection);
        int n = 0;
        for (Endpoint endpoint : collection) {
            if (!this.add(endpoint, true)) continue;
            ++n;
        }
        return n;
    }

    public boolean add(Endpoint endpoint, boolean bl) {
        if (!this.isValidHost(endpoint)) {
            return false;
        }
        if (bl) {
            return this.add(endpoint, 1);
        }
        return this.add(endpoint, 0);
    }

    public boolean add(Endpoint endpoint, boolean bl, String string) {
        if (!this.isValidHost(endpoint)) {
            return false;
        }
        if (bl) {
            return this.add(new ExtendedEndpoint(endpoint.getAddress(), endpoint.getPort(), string), 1);
        }
        return this.add(new ExtendedEndpoint(endpoint.getAddress(), endpoint.getPort(), string), 0);
    }

    public boolean add(Endpoint endpoint, int n) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("adding host " + endpoint));
        }
        if (endpoint instanceof ExtendedEndpoint) {
            return this.add((ExtendedEndpoint)endpoint, n);
        }
        return this.add(new ExtendedEndpoint(endpoint.getAddress(), endpoint.getPort()), n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean add(ExtendedEndpoint extendedEndpoint, int n) {
        this.repOk();
        if (extendedEndpoint.isUDPHostCache()) {
            return this.addUDPHostCache(extendedEndpoint);
        }
        boolean bl = false;
        HostCatcher hostCatcher = this;
        synchronized (hostCatcher) {
            this.addPermanent(extendedEndpoint);
            if (!this.ENDPOINT_SET.containsKey(extendedEndpoint)) {
                bl = true;
                this.ENDPOINT_SET.put(extendedEndpoint, extendedEndpoint);
                ExtendedEndpoint extendedEndpoint2 = this.ENDPOINT_QUEUE.insert(extendedEndpoint, n);
                if (extendedEndpoint2 != null) {
                    this.ENDPOINT_SET.remove(extendedEndpoint2);
                }
            }
        }
        this.endpointAdded();
        this.repOk();
        return bl;
    }

    private synchronized boolean addPermanent(ExtendedEndpoint extendedEndpoint) {
        if (this.networkInstanceUtils.isPrivateAddress(extendedEndpoint.getInetAddress())) {
            return false;
        }
        if (this.permanentHostsSet.contains(extendedEndpoint)) {
            return false;
        }
        this.addToLocaleMap(extendedEndpoint);
        ExtendedEndpoint extendedEndpoint2 = this.permanentHosts.insert(extendedEndpoint);
        if (extendedEndpoint2 != extendedEndpoint) {
            this.permanentHostsSet.add(extendedEndpoint);
            if (extendedEndpoint2 != null) {
                this.permanentHostsSet.remove(extendedEndpoint2);
            }
            this.dirty = true;
            return true;
        }
        return false;
    }

    private synchronized boolean removePermanent(ExtendedEndpoint extendedEndpoint) {
        boolean bl = this.permanentHosts.remove(extendedEndpoint);
        boolean bl2 = this.permanentHostsSet.remove(extendedEndpoint);
        assert (bl == bl2) : "Queue " + bl + " but set " + bl2;
        if (bl) {
            this.dirty = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isValidHost(Endpoint endpoint) {
        byte[] byArray;
        if (endpoint.isUDPHostCache()) {
            return true;
        }
        try {
            byArray = endpoint.getHostBytes();
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
        if (this.networkInstanceUtils.isPrivateAddress(byArray)) {
            return false;
        }
        if (this.networkInstanceUtils.isMe(byArray, endpoint.getPort())) {
            return false;
        }
        if (!((IPFilter)this.ipFilter.get()).allow(byArray)) {
            return false;
        }
        HostCatcher hostCatcher = this;
        synchronized (hostCatcher) {
            if (this.EXPIRED_HOSTS.contains(endpoint)) {
                return false;
            }
            if (this.PROBATION_HOSTS.contains(endpoint)) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHostTLSCapable(IpPort ipPort) {
        ExtendedEndpoint extendedEndpoint;
        if (ipPort instanceof Connectable) {
            return ((Connectable)ipPort).isTLSCapable();
        }
        Endpoint endpoint = new Endpoint(ipPort.getAddress(), ipPort.getPort());
        HostCatcher hostCatcher = this;
        synchronized (hostCatcher) {
            extendedEndpoint = this.ENDPOINT_SET.get(endpoint);
            if (extendedEndpoint == null) {
                extendedEndpoint = (ExtendedEndpoint)this.FREE_ULTRAPEER_SLOTS_SET.get(endpoint);
            }
            if (extendedEndpoint == null) {
                extendedEndpoint = (ExtendedEndpoint)this.FREE_LEAF_SLOTS_SET.get(endpoint);
            }
        }
        if (extendedEndpoint == null) {
            return false;
        }
        return extendedEndpoint.isTLSCapable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endpointAdded() {
        EndpointObserver endpointObserver;
        ExtendedEndpoint extendedEndpoint;
        HostCatcher hostCatcher = this;
        synchronized (hostCatcher) {
            if (this._catchersWaiting.isEmpty()) {
                return;
            }
            extendedEndpoint = this.getAnEndpointInternal();
            if (extendedEndpoint == null) {
                return;
            }
            endpointObserver = this._catchersWaiting.remove(0);
        }
        endpointObserver.handleEndpoint(extendedEndpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getAnEndpoint(EndpointObserver endpointObserver) {
        ExtendedEndpoint extendedEndpoint;
        HostCatcher hostCatcher = this;
        synchronized (hostCatcher) {
            extendedEndpoint = this.getAnEndpointInternal();
            if (extendedEndpoint == null) {
                this._catchersWaiting.add(endpointObserver);
            }
        }
        if (extendedEndpoint != null) {
            endpointObserver.handleEndpoint(extendedEndpoint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Endpoint getAnEndpointImmediate(EndpointObserver endpointObserver) {
        ExtendedEndpoint extendedEndpoint;
        HostCatcher hostCatcher = this;
        synchronized (hostCatcher) {
            extendedEndpoint = this.getAnEndpointInternal();
            if (extendedEndpoint == null && endpointObserver != null) {
                this._catchersWaiting.add(endpointObserver);
            }
        }
        return extendedEndpoint;
    }

    public synchronized void removeEndpointObserver(EndpointObserver endpointObserver) {
        this._catchersWaiting.remove(endpointObserver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Endpoint getAnEndpoint() throws InterruptedException {
        BlockingObserver blockingObserver = new BlockingObserver();
        this.getAnEndpoint(blockingObserver);
        try {
            BlockingObserver blockingObserver2 = blockingObserver;
            synchronized (blockingObserver2) {
                if (blockingObserver.getEndpoint() == null) {
                    blockingObserver.wait();
                }
                return blockingObserver.getEndpoint();
            }
        }
        catch (InterruptedException interruptedException) {
            HostCatcher hostCatcher = this;
            synchronized (hostCatcher) {
                this._catchersWaiting.remove(blockingObserver);
                throw interruptedException;
            }
        }
    }

    public synchronized void doneWithConnect(Endpoint endpoint, boolean bl) {
        if (!(endpoint instanceof ExtendedEndpoint)) {
            return;
        }
        ExtendedEndpoint extendedEndpoint = (ExtendedEndpoint)endpoint;
        this.removePermanent(extendedEndpoint);
        if (bl) {
            extendedEndpoint.recordConnectionSuccess();
        } else {
            ++this._failures;
            extendedEndpoint.recordConnectionFailure();
        }
        this.addPermanent(extendedEndpoint);
    }

    protected ExtendedEndpoint getAnEndpointInternal() {
        if (this.connectionServices.isSupernode() && !this.FREE_ULTRAPEER_SLOTS_SET.isEmpty()) {
            return this.preferenceWithLocale(this.FREE_ULTRAPEER_SLOTS_SET);
        }
        if (this.connectionServices.isShieldedLeaf() && !this.FREE_LEAF_SLOTS_SET.isEmpty()) {
            return this.preferenceWithLocale(this.FREE_LEAF_SLOTS_SET);
        }
        if (!this.FREE_ULTRAPEER_SLOTS_SET.isEmpty()) {
            return this.preferenceWithLocale(this.FREE_ULTRAPEER_SLOTS_SET);
        }
        if (!this.FREE_LEAF_SLOTS_SET.isEmpty()) {
            Iterator iterator = this.FREE_LEAF_SLOTS_SET.keySet().iterator();
            ExtendedEndpoint extendedEndpoint = (ExtendedEndpoint)iterator.next();
            this.FREE_LEAF_SLOTS_SET.remove(extendedEndpoint);
            return extendedEndpoint;
        }
        if (!this.ENDPOINT_QUEUE.isEmpty()) {
            ExtendedEndpoint extendedEndpoint = this.ENDPOINT_QUEUE.extractMax();
            ExtendedEndpoint extendedEndpoint2 = this.ENDPOINT_SET.remove(extendedEndpoint);
            assert (extendedEndpoint2 == extendedEndpoint) : "Rep. invariant for HostCatcher broken.";
            return extendedEndpoint;
        }
        if (!this.restoredHosts.isEmpty()) {
            List<ExtendedEndpoint> list = this.uptimePartitions.getLastPartition();
            ExtendedEndpoint extendedEndpoint = list.remove((int)(Math.random() * (double)list.size()));
            return extendedEndpoint;
        }
        return null;
    }

    private ExtendedEndpoint preferenceWithLocale(RandomAccessMap<ExtendedEndpoint, ExtendedEndpoint> randomAccessMap) {
        Object object;
        String string = ApplicationSettings.LANGUAGE.getValue();
        ExtendedEndpoint extendedEndpoint = null;
        if (!((ConnectionManager)this.connectionManager.get()).isLocaleMatched() && this.LOCALE_SET_MAP.containsKey(string)) {
            object = this.LOCALE_SET_MAP.get(string);
            for (ExtendedEndpoint extendedEndpoint2 : randomAccessMap.keySet()) {
                if (!object.contains(extendedEndpoint2)) continue;
                object.remove(extendedEndpoint2);
                extendedEndpoint = extendedEndpoint2;
                break;
            }
        }
        if (extendedEndpoint == null) {
            extendedEndpoint = randomAccessMap.getKeyAt(this.RND.nextInt(randomAccessMap.size()));
        }
        object = randomAccessMap.remove(extendedEndpoint);
        assert (extendedEndpoint == object) : "Key: " + extendedEndpoint + ", value: " + object;
        return extendedEndpoint;
    }

    public synchronized int getNumHosts() {
        return this.ENDPOINT_QUEUE.size() + this.FREE_LEAF_SLOTS_SET.size() + this.FREE_ULTRAPEER_SLOTS_SET.size() + this.restoredHosts.size();
    }

    public synchronized int getNumUltrapeerHosts() {
        return this.ENDPOINT_QUEUE.size(1) + this.FREE_LEAF_SLOTS_SET.size() + this.FREE_ULTRAPEER_SLOTS_SET.size();
    }

    Iterator<ExtendedEndpoint> getPermanentHosts() {
        return this.permanentHosts.iterator();
    }

    public synchronized Collection<IpPort> getUltrapeersWithFreeUltrapeerSlots(int n) {
        return this.getPreferencedCollection(this.FREE_ULTRAPEER_SLOTS_SET, ApplicationSettings.LANGUAGE.getValue(), n);
    }

    public synchronized Collection<IpPort> getUltrapeersWithFreeUltrapeerSlots(String string, int n) {
        return this.getPreferencedCollection(this.FREE_ULTRAPEER_SLOTS_SET, string, n);
    }

    public synchronized Collection<IpPort> getUltrapeersWithFreeLeafSlots(int n) {
        return this.getPreferencedCollection(this.FREE_LEAF_SLOTS_SET, ApplicationSettings.LANGUAGE.getValue(), n);
    }

    public synchronized Collection<IpPort> getUltrapeersWithFreeLeafSlots(String string, int n) {
        return this.getPreferencedCollection(this.FREE_LEAF_SLOTS_SET, string, n);
    }

    private Collection<IpPort> getPreferencedCollection(Map<? extends ExtendedEndpoint, ? extends ExtendedEndpoint> map, String string, int n) {
        if (string == null || string.equals("")) {
            string = ApplicationSettings.DEFAULT_LOCALE.getValue();
        }
        HashSet<IpPort> hashSet = new HashSet<IpPort>(n);
        IntSet intSet = new IntSet();
        Set<ExtendedEndpoint> set = this.LOCALE_SET_MAP.get(string);
        boolean bl = ConnectionSettings.FILTER_CLASS_C.getValue();
        if (set != null) {
            for (ExtendedEndpoint extendedEndpoint : set) {
                if (hashSet.size() >= n) break;
                if (!map.containsKey(extendedEndpoint) || bl && !intSet.add(NetworkUtils.getMaskedIP(extendedEndpoint.getInetAddress(), -256))) continue;
                hashSet.add(extendedEndpoint);
            }
        }
        for (ExtendedEndpoint extendedEndpoint : map.keySet()) {
            if (hashSet.size() >= n) break;
            if (bl && !intSet.add(NetworkUtils.getMaskedIP(extendedEndpoint.getInetAddress(), -256))) continue;
            hashSet.add(extendedEndpoint);
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expire() {
        HostCatcher hostCatcher = this;
        synchronized (hostCatcher) {
            long l = System.currentTimeMillis();
            this.lastAllowedPongRankTime = l + 20000L;
        }
        this.recoverHosts();
        this.backgroundExecutor.schedule(new Runnable(){

            public void run() {
                HostCatcher.this.uniqueHostPinger.resetData();
            }
        }, 20000L, TimeUnit.MILLISECONDS);
    }

    public synchronized void clear() {
        this.FREE_LEAF_SLOTS_SET.clear();
        this.FREE_ULTRAPEER_SLOTS_SET.clear();
        this.ENDPOINT_QUEUE.clear();
        this.ENDPOINT_SET.clear();
    }

    public UDPPinger getPinger() {
        return this.uniqueHostPinger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void repOk() {
        if (!DEBUG) {
            return;
        }
        HostCatcher hostCatcher = this;
        synchronized (hostCatcher) {
            block3: for (ExtendedEndpoint extendedEndpoint : this.ENDPOINT_SET.keySet()) {
                Iterator<ExtendedEndpoint> iterator = this.ENDPOINT_QUEUE.iterator();
                while (iterator.hasNext()) {
                    if (!((Object)extendedEndpoint).equals(iterator.next())) continue;
                    continue block3;
                }
                throw new IllegalStateException("Couldn't find " + extendedEndpoint + " in queue");
            }
            for (ExtendedEndpoint extendedEndpoint : this.ENDPOINT_QUEUE) {
                assert (extendedEndpoint instanceof ExtendedEndpoint);
                assert (this.ENDPOINT_SET.containsKey(extendedEndpoint));
            }
            for (ExtendedEndpoint extendedEndpoint : this.permanentHosts) {
                assert (extendedEndpoint instanceof ExtendedEndpoint);
                assert (this.permanentHostsSet.contains(extendedEndpoint));
            }
            for (ExtendedEndpoint extendedEndpoint : this.permanentHostsSet) {
                assert (extendedEndpoint instanceof ExtendedEndpoint);
                assert (this.permanentHosts.contains(extendedEndpoint)) : "Couldn't find " + extendedEndpoint + " from " + this.permanentHostsSet + " in " + this.permanentHosts;
            }
        }
    }

    private void readHostsFile() {
        LOG.trace((Object)"Reading Hosts File");
        try {
            this.read(this.getHostsFile());
        }
        catch (IOException iOException) {
            LOG.debug((Object)this.getHostsFile(), (Throwable)iOException);
        }
    }

    private File getHostsFile() {
        return new File(CommonUtils.getUserSettingsDir(), "gnutella.net");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recoverHosts() {
        LOG.debug((Object)"recovering hosts file");
        HostCatcher hostCatcher = this;
        synchronized (hostCatcher) {
            this.PROBATION_HOSTS.clear();
            this.EXPIRED_HOSTS.clear();
            this._failures = 0;
            this.FETCHER.resetFetchTime();
            this.udpHostCache.resetData();
            this.udpHostCache.loadDefaults();
            this.tcpBootstrap.resetData();
            this.tcpBootstrap.loadDefaults();
            this.restoredHosts.clear();
            this.uniqueHostPinger.resetData();
        }
        this.readHostsFile();
    }

    public synchronized void putHostOnProbation(Endpoint endpoint) {
        this.PROBATION_HOSTS.add(endpoint);
        if (this.PROBATION_HOSTS.size() > 500) {
            this.PROBATION_HOSTS.remove(this.PROBATION_HOSTS.iterator().next());
        }
    }

    public synchronized void expireHost(Endpoint endpoint) {
        this.EXPIRED_HOSTS.add(endpoint);
        if (this.EXPIRED_HOSTS.size() > 500) {
            this.EXPIRED_HOSTS.remove(this.EXPIRED_HOSTS.iterator().next());
        }
    }

    @InspectableContainer
    private class HCInspectables {
        @InspectionPoint(value="known hosts by class C")
        public final Inspectable top10classC = new Inspectable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object inspect() {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("ver", 1);
                ClassCNetworks classCNetworks = new ClassCNetworks();
                ClassCNetworks classCNetworks2 = new ClassCNetworks();
                ClassCNetworks classCNetworks3 = new ClassCNetworks();
                ClassCNetworks classCNetworks4 = new ClassCNetworks();
                ClassCNetworks classCNetworks5 = new ClassCNetworks();
                HostCatcher hostCatcher = HostCatcher.this;
                synchronized (hostCatcher) {
                    IpPortSet ipPortSet = new IpPortSet();
                    ipPortSet.addAll(HostCatcher.this.permanentHostsSet);
                    ipPortSet.addAll(HostCatcher.this.restoredHosts);
                    ipPortSet.addAll(HostCatcher.this.FREE_LEAF_SLOTS_SET.keySet());
                    ipPortSet.addAll(HostCatcher.this.FREE_ULTRAPEER_SLOTS_SET.keySet());
                    ipPortSet.addAll(HostCatcher.this.ENDPOINT_SET.keySet());
                    for (IpPort ipPort : HostCatcher.this.permanentHostsSet) {
                        classCNetworks.add(ipPort.getInetAddress(), 1);
                    }
                    for (IpPort ipPort : HostCatcher.this.restoredHosts) {
                        classCNetworks2.add(ipPort.getInetAddress(), 1);
                    }
                    for (IpPort ipPort : HostCatcher.this.FREE_LEAF_SLOTS_SET.keySet()) {
                        classCNetworks3.add(ipPort.getInetAddress(), 1);
                    }
                    for (IpPort ipPort : HostCatcher.this.FREE_ULTRAPEER_SLOTS_SET.keySet()) {
                        classCNetworks4.add(ipPort.getInetAddress(), 1);
                    }
                    for (IpPort ipPort : ipPortSet) {
                        classCNetworks5.add(ipPort.getInetAddress(), 1);
                    }
                }
                hashMap.put("perm", classCNetworks.getTopInspectable(10));
                hashMap.put("rest", classCNetworks2.getTopInspectable(10));
                hashMap.put("fl", classCNetworks3.getTopInspectable(10));
                hashMap.put("fu", classCNetworks4.getTopInspectable(10));
                hashMap.put("all", classCNetworks5.getTopInspectable(10));
                return hashMap;
            }
        };
        @InspectionPoint(value="tls stats of known hosts")
        public final Inspectable tlsStats = new Inspectable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object inspect() {
                int n;
                int n2;
                int n3;
                int n4;
                int n5;
                int n6;
                int n7;
                int n8;
                HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                hashMap.put("ver", 1);
                HostCatcher hostCatcher = HostCatcher.this;
                synchronized (hostCatcher) {
                    n8 = HostCatcher.this.permanentHostsSet.size();
                    n7 = HostCatcher.this.restoredHosts.size();
                    n6 = HostCatcher.this.FREE_LEAF_SLOTS_SET.size();
                    n5 = HostCatcher.this.FREE_ULTRAPEER_SLOTS_SET.size();
                    n4 = 0;
                    for (ExtendedEndpoint extendedEndpoint : HostCatcher.this.permanentHostsSet) {
                        n4 += extendedEndpoint.isTLSCapable() ? 1 : 0;
                    }
                    n3 = 0;
                    for (ExtendedEndpoint extendedEndpoint : HostCatcher.this.restoredHosts) {
                        n3 += extendedEndpoint.isTLSCapable() ? 1 : 0;
                    }
                    n2 = 0;
                    for (ExtendedEndpoint extendedEndpoint : HostCatcher.this.FREE_LEAF_SLOTS_SET.keySet()) {
                        n2 += extendedEndpoint.isTLSCapable() ? 1 : 0;
                    }
                    n = 0;
                    for (ExtendedEndpoint extendedEndpoint : HostCatcher.this.FREE_ULTRAPEER_SLOTS_SET.keySet()) {
                        n += extendedEndpoint.isTLSCapable() ? 1 : 0;
                    }
                }
                hashMap.put("perm", n8);
                hashMap.put("permtls", n4);
                hashMap.put("rest", n7);
                hashMap.put("resttls", n3);
                hashMap.put("fl", n6);
                hashMap.put("fltls", n2);
                hashMap.put("fu", n5);
                hashMap.put("futls", n);
                return hashMap;
            }
        };
        @InspectionPoint(value="dht stats of known hosts")
        public final Inspectable dhtStats = new Inspectable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object inspect() {
                int n;
                int n2;
                int n3;
                int n4;
                int n5;
                int n6;
                int n7;
                int n8;
                HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                hashMap.put("ver", 1);
                HostCatcher hostCatcher = HostCatcher.this;
                synchronized (hostCatcher) {
                    n8 = HostCatcher.this.permanentHostsSet.size();
                    n7 = HostCatcher.this.restoredHosts.size();
                    n6 = HostCatcher.this.FREE_LEAF_SLOTS_SET.size();
                    n5 = HostCatcher.this.FREE_ULTRAPEER_SLOTS_SET.size();
                    n4 = 0;
                    for (ExtendedEndpoint extendedEndpoint : HostCatcher.this.permanentHostsSet) {
                        n4 += extendedEndpoint.supportsDHT() ? 1 : 0;
                    }
                    n3 = 0;
                    for (ExtendedEndpoint extendedEndpoint : HostCatcher.this.restoredHosts) {
                        n3 += extendedEndpoint.supportsDHT() ? 1 : 0;
                    }
                    n2 = 0;
                    for (ExtendedEndpoint extendedEndpoint : HostCatcher.this.FREE_LEAF_SLOTS_SET.keySet()) {
                        n2 += extendedEndpoint.supportsDHT() ? 1 : 0;
                    }
                    n = 0;
                    for (ExtendedEndpoint extendedEndpoint : HostCatcher.this.FREE_ULTRAPEER_SLOTS_SET.keySet()) {
                        n += extendedEndpoint.supportsDHT() ? 1 : 0;
                    }
                }
                hashMap.put("perm", n8);
                hashMap.put("permdht", n4);
                hashMap.put("rest", n7);
                hashMap.put("restdht", n3);
                hashMap.put("fl", n6);
                hashMap.put("fldht", n2);
                hashMap.put("fu", n5);
                hashMap.put("fudht", n);
                return hashMap;
            }
        };

        private HCInspectables() {
        }
    }

    private static class BlockingObserver
    implements EndpointObserver {
        private Endpoint endpoint;

        private BlockingObserver() {
        }

        public synchronized void handleEndpoint(Endpoint endpoint) {
            this.endpoint = endpoint;
            this.notify();
        }

        public Endpoint getEndpoint() {
            return this.endpoint;
        }
    }

    public static interface EndpointObserver {
        public void handleEndpoint(Endpoint var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BootstrapListener
    implements TcpBootstrap.TcpBootstrapListener {
        private BootstrapListener() {
        }

        @Override
        public int handleHosts(Collection<? extends Endpoint> collection) {
            return HostCatcher.this.add(collection);
        }
    }

    private class Bootstrapper
    implements Runnable {
        private long nextAllowedMulticastTime = 0L;
        private long nextAllowedUdpTime = 0L;
        private long nextAllowedTcpTime = 0L;
        private static final int POST_TCP_DELAY = 300000;
        private static final int POST_UDP_DELAY = 30000;
        private static final int POST_UDP_PRE_TCP_DELAY = 10000;
        private static final int POST_MULTICAST_DELAY = 60000;

        private Bootstrapper() {
        }

        public synchronized void run() {
            if (ConnectionSettings.DO_NOT_BOOTSTRAP.getValue()) {
                return;
            }
            if (HostCatcher.this._catchersWaiting.isEmpty()) {
                return;
            }
            long l = System.currentTimeMillis();
            if (!this.needsHosts(l)) {
                return;
            }
            this.getHosts(l);
        }

        void resetFetchTime() {
            this.nextAllowedUdpTime = 0L;
            this.nextAllowedMulticastTime = 0L;
            this.nextAllowedTcpTime = 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized boolean needsHosts(long l) {
            HostCatcher hostCatcher = HostCatcher.this;
            synchronized (hostCatcher) {
                return HostCatcher.this.getNumHosts() == 0 || !HostCatcher.this.connectionServices.isConnected() && HostCatcher.this._failures > 100;
            }
        }

        synchronized void getHosts(long l) {
            if (this.multicastFetch(l)) {
                return;
            }
            if (this.udpHostCacheFetch(l)) {
                return;
            }
            if (this.tcpHostCacheFetch(l)) {
                return;
            }
        }

        private boolean multicastFetch(long l) {
            if (this.nextAllowedMulticastTime < l && !ConnectionSettings.DO_NOT_MULTICAST_BOOTSTRAP.getValue()) {
                LOG.trace((Object)"Fetching via multicast");
                PingRequest pingRequest = HostCatcher.this.pingRequestFactory.createMulticastPing();
                ((MulticastService)HostCatcher.this.multicastService.get()).send(pingRequest);
                this.nextAllowedMulticastTime = l + 60000L;
                return true;
            }
            return false;
        }

        private boolean udpHostCacheFetch(long l) {
            if (this.nextAllowedUdpTime < l && HostCatcher.this.udpHostCache.fetchHosts()) {
                LOG.trace((Object)"Fetching via UDP");
                this.nextAllowedUdpTime = l + 30000L;
                this.nextAllowedTcpTime = Math.max(this.nextAllowedTcpTime, this.nextAllowedUdpTime + 10000L);
                return true;
            }
            return false;
        }

        private boolean tcpHostCacheFetch(long l) {
            if (this.nextAllowedTcpTime < l && HostCatcher.this.tcpBootstrap.fetchHosts(new BootstrapListener())) {
                LOG.trace((Object)"Fetching via TCP");
                this.nextAllowedTcpTime = l + 300000L;
                return true;
            }
            return false;
        }
    }
}

