/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.http.HTTPConnectionData;
import com.limegroup.gnutella.http.HttpContextParams;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.statistics.TcpBandwidthStatistics;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.io.IOException;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.nio.NHttpConnection;
import org.apache.http.nio.entity.ConsumingNHttpEntity;
import org.apache.http.nio.protocol.NHttpRequestHandler;
import org.apache.http.nio.protocol.SimpleNHttpRequestHandler;
import org.apache.http.protocol.HttpContext;
import org.limewire.http.BasicHttpAcceptor;
import org.limewire.http.HttpAcceptorListener;
import org.limewire.http.reactor.HttpIOSession;
import org.limewire.nio.NIODispatcher;
import org.limewire.statistic.Statistic;

@Singleton
public class HTTPAcceptor
extends BasicHttpAcceptor {
    private static final Log LOG = LogFactory.getLog(HTTPAcceptor.class);
    private static final String[] SUPPORTED_METHODS = new String[]{"GET", "HEAD"};
    private final NHttpRequestHandler notFoundHandler = new SimpleNHttpRequestHandler(){

        public ConsumingNHttpEntity entityRequest(HttpEntityEnclosingRequest httpEntityEnclosingRequest, HttpContext httpContext) throws HttpException, IOException {
            return null;
        }

        public void handle(HttpRequest httpRequest, HttpResponse httpResponse, HttpContext httpContext) throws HttpException, IOException {
            httpResponse.setReasonPhrase("Feature Not Active");
            httpResponse.setStatusCode(404);
        }
    };

    @Inject
    public HTTPAcceptor(TcpBandwidthStatistics tcpBandwidthStatistics) {
        super(HTTPAcceptor.createDefaultParams(LimeWireUtils.getHttpServer(), 8000), SUPPORTED_METHODS);
        this.addAcceptorListener(new ConnectionEventListener());
        if (tcpBandwidthStatistics != null) {
            this.addResponseInterceptor(new HeaderStatisticTracker(tcpBandwidthStatistics));
        } else {
            LOG.warn((Object)"Not tracking TCP header bandwidth!");
        }
        this.inititalizeDefaultHandlers();
    }

    private void inititalizeDefaultHandlers() {
        this.registerHandler("/browser-control", this.notFoundHandler);
        this.registerHandler("/gnutella/file-view*", this.notFoundHandler);
        this.registerHandler("/gnutella/res/*", this.notFoundHandler);
        this.registerHandler("*", (NHttpRequestHandler)new SimpleNHttpRequestHandler(){

            public ConsumingNHttpEntity entityRequest(HttpEntityEnclosingRequest httpEntityEnclosingRequest, HttpContext httpContext) throws HttpException, IOException {
                return null;
            }

            public void handle(HttpRequest httpRequest, HttpResponse httpResponse, HttpContext httpContext) throws HttpException, IOException {
                httpResponse.setStatusCode(400);
            }
        });
    }

    public void acceptConnection(Socket socket, HTTPConnectionData hTTPConnectionData) {
        assert (NIODispatcher.instance().isDispatchThread());
        if (this.getReactor() == null) {
            LOG.warn((Object)"Received upload request before reactor was initialized");
            return;
        }
        NHttpConnection nHttpConnection = this.getReactor().acceptConnection(null, socket);
        if (nHttpConnection != null) {
            HttpContextParams.setConnectionData(nHttpConnection.getContext(), hTTPConnectionData);
        }
    }

    public NHttpRequestHandler getNotFoundHandler() {
        return this.notFoundHandler;
    }

    private class HeaderStatisticTracker
    implements HttpResponseInterceptor {
        private final Statistic headerUpstream;

        HeaderStatisticTracker(TcpBandwidthStatistics tcpBandwidthStatistics) {
            this.headerUpstream = tcpBandwidthStatistics.getStatistic(TcpBandwidthStatistics.StatisticType.HTTP_HEADER_UPSTREAM);
        }

        public void process(HttpResponse httpResponse, HttpContext httpContext) throws HttpException, IOException {
            HeaderIterator headerIterator = httpResponse.headerIterator();
            while (headerIterator.hasNext()) {
                Header header = (Header)headerIterator.next();
                this.headerUpstream.addData(header.getName().length() + 2 + header.getValue().length());
            }
        }
    }

    private class ConnectionEventListener
    implements HttpAcceptorListener {
        private ConnectionEventListener() {
        }

        public void connectionOpen(NHttpConnection nHttpConnection) {
        }

        public void connectionClosed(NHttpConnection nHttpConnection) {
        }

        public void connectionTimeout(NHttpConnection nHttpConnection) {
        }

        public void fatalIOException(IOException iOException, NHttpConnection nHttpConnection) {
        }

        public void fatalProtocolException(HttpException httpException, NHttpConnection nHttpConnection) {
        }

        public void responseSent(NHttpConnection nHttpConnection, HttpResponse httpResponse) {
            HttpIOSession httpIOSession = HttpContextParams.getIOSession(nHttpConnection.getContext());
            httpIOSession.setSocketTimeout(SharingSettings.PERSISTENT_HTTP_CONNECTION_TIMEOUT.getValue());
            httpIOSession.setThrottle(null);
            nHttpConnection.requestInput();
        }
    }
}

