/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import java.util.Random;
import org.limewire.io.NetworkUtils;
import org.limewire.util.ByteUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GUID
implements Comparable<GUID> {
    private static final int SZ = 16;
    private static Random rand = new Random();
    private byte[] bytes;
    public static final Comparator<GUID> GUID_COMPARATOR = new GUIDComparator();
    public static final Comparator<byte[]> GUID_BYTE_COMPARATOR = new GUIDByteComparator();

    public GUID() {
        this(GUID.makeGuid());
    }

    public GUID(byte[] byArray) {
        assert (byArray.length == 16);
        this.bytes = byArray;
    }

    public GUID(String string) {
        this(GUID.fromHexString(string));
    }

    private static void tagGuid(byte[] byArray, int n, int n2, int n3) {
        short s = ByteUtils.leb2short(byArray, n);
        short s2 = ByteUtils.leb2short(byArray, n2);
        short s3 = GUID.tag(s, s2);
        ByteUtils.short2leb(s3, byArray, n3);
    }

    public static byte[] makeGuid() {
        byte[] byArray = new byte[16];
        rand.nextBytes(byArray);
        byArray[15] = 0;
        GUID.tagGuid(byArray, 4, 6, 9);
        return byArray;
    }

    public static byte[] makeGuidRequery() {
        byte[] byArray = GUID.makeGuid();
        GUID.tagGuid(byArray, 0, 11, 13);
        return byArray;
    }

    public static void timeStampGuid(byte[] byArray) {
        int n = (int)(System.currentTimeMillis() / 1000L);
        byArray[4] = (byte)(n >> 24);
        byArray[5] = (byte)(n >> 16);
        byArray[6] = (byte)(n >> 8);
        byArray[15] = (byte)n;
    }

    public static long readTimeStamp(byte[] byArray) {
        return (long)(byArray[4] << 24 | (byArray[5] & 0xFF) << 16 | (byArray[6] & 0xFF) << 8 | byArray[15] & 0xFF) * 1000L;
    }

    public static byte[] makeAddressEncodedGuid(byte[] byArray, int n) throws IllegalArgumentException {
        return GUID.addressEncodeGuid(GUID.makeGuid(), byArray, n);
    }

    public static byte[] addressEncodeGuid(byte[] byArray, byte[] byArray2, int n) throws IllegalArgumentException {
        if (byArray.length != 16) {
            throw new IllegalArgumentException("Input byte array wrong length.");
        }
        if (!NetworkUtils.isValidAddress(byArray2)) {
            throw new IllegalArgumentException("IP is invalid!");
        }
        if (!NetworkUtils.isValidPort(n)) {
            throw new IllegalArgumentException("Port is invalid: " + n);
        }
        for (int i = 0; i < 4; ++i) {
            byArray[i] = byArray2[i];
        }
        ByteUtils.short2leb((short)n, byArray, 13);
        return byArray;
    }

    static short tag(short s, short s2) {
        int n = (s + 2) * (s2 + 3);
        short s3 = (short)(n >> 8);
        return s3;
    }

    public boolean isLimeGUID() {
        return GUID.isLimeGUID(this.bytes);
    }

    public boolean isLimeRequeryGUID(int n) {
        return GUID.isLimeRequeryGUID(this.bytes, n);
    }

    public boolean isLimeRequeryGUID() {
        return GUID.isLimeRequeryGUID(this.bytes);
    }

    public boolean addressesMatch(byte[] byArray, int n) throws IllegalArgumentException {
        return GUID.addressesMatch(this.bytes, byArray, n);
    }

    public String getIP() {
        return GUID.getIP(this.bytes);
    }

    public boolean matchesIP(byte[] byArray) {
        return GUID.matchesIP(byArray, this.bytes);
    }

    public int getPort() {
        return GUID.getPort(this.bytes);
    }

    private static boolean checkMatching(byte[] byArray, int n, int n2, int n3) {
        short s;
        short s2 = ByteUtils.leb2short(byArray, n);
        short s3 = ByteUtils.leb2short(byArray, n2);
        short s4 = ByteUtils.leb2short(byArray, n3);
        return s4 == (s = GUID.tag(s2, s3));
    }

    public static boolean isLimeGUID(byte[] byArray) {
        return GUID.checkMatching(byArray, 4, 6, 9);
    }

    public static boolean isLimeRequeryGUID(byte[] byArray) {
        return GUID.isLimeRequeryGUID(byArray, 0) || GUID.isLimeRequeryGUID(byArray, 1) || GUID.isLimeRequeryGUID(byArray, 2);
    }

    public static boolean isLimeRequeryGUID(byte[] byArray, int n) {
        if (n == 0) {
            return GUID.checkMatching(byArray, 0, 9, 13);
        }
        if (n == 1) {
            return GUID.checkMatching(byArray, 0, 2, 13);
        }
        return GUID.checkMatching(byArray, 0, 11, 13);
    }

    public static boolean addressesMatch(byte[] byArray, byte[] byArray2, int n) throws IllegalArgumentException {
        if (byArray2.length != 4) {
            throw new IllegalArgumentException("IP address too big!");
        }
        if (!NetworkUtils.isValidPort(n)) {
            return false;
        }
        if (!NetworkUtils.isValidAddress(byArray2)) {
            return false;
        }
        byte[] byArray3 = new byte[2];
        ByteUtils.short2leb((short)n, byArray3, 0);
        return byArray[0] == byArray2[0] && byArray[1] == byArray2[1] && byArray[2] == byArray2[2] && byArray[3] == byArray2[3] && byArray[13] == byArray3[0] && byArray[14] == byArray3[1];
    }

    public static String getIP(byte[] byArray) {
        return NetworkUtils.ip2string(byArray);
    }

    public static boolean matchesIP(byte[] byArray, byte[] byArray2) {
        if (byArray.length != 4) {
            throw new IllegalArgumentException("Bad byte[] length = " + byArray.length);
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static int getPort(byte[] byArray) {
        return ByteUtils.ushort2int(ByteUtils.leb2short(byArray, 13));
    }

    @Override
    public int compareTo(GUID gUID) {
        if (this == gUID) {
            return 0;
        }
        return GUID.compare(this.bytes(), gUID.bytes());
    }

    private static final int compare(byte[] byArray, byte[] byArray2) {
        for (int i = 0; i < 16; ++i) {
            int n = byArray[i] - byArray2[i];
            if (n == 0) continue;
            return n;
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof GUID) {
            byte[] byArray = ((GUID)object).bytes();
            return Arrays.equals(this.bytes, byArray);
        }
        return false;
    }

    public int hashCode() {
        byte[] byArray = this.bytes;
        int n = 0xFF & byArray[0] | 0xFF00 & byArray[1] << 8 | 0xFF0000 & byArray[2] << 16 | byArray[3] << 24;
        int n2 = 0xFF & byArray[4] | 0xFF00 & byArray[5] << 8 | 0xFF0000 & byArray[6] << 16 | byArray[7] << 24;
        int n3 = 0xFF & byArray[8] | 0xFF00 & byArray[9] << 8 | 0xFF0000 & byArray[10] << 16 | byArray[11] << 24;
        int n4 = 0xFF & byArray[12] | 0xFF00 & byArray[13] << 8 | 0xFF0000 & byArray[14] << 16 | byArray[15] << 24;
        return n ^ n2 ^ n3 ^ n4;
    }

    public byte[] bytes() {
        return this.bytes;
    }

    public String toString() {
        return this.toHexString();
    }

    public String toHexString() {
        return GUID.toHexString(this.bytes);
    }

    public static String toHexString(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < 16; ++i) {
            int n = ByteUtils.ubyte2int(byArray[i]);
            String string = Integer.toHexString(n);
            while (string.length() < 2) {
                string = "0" + string;
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString().toUpperCase(Locale.US);
    }

    public static byte[] fromHexString(String string) throws IllegalArgumentException {
        byte[] byArray = new byte[16];
        try {
            for (int i = 0; i < 16; ++i) {
                byArray[i] = (byte)Integer.parseInt(string.substring(i * 2, i * 2 + 2), 16);
            }
            return byArray;
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(string);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException(string);
        }
    }

    public static class TimedGUID {
        private final long MAX_LIFE;
        private final GUID _guid;
        private final long _creationTime;

        public GUID getGUID() {
            return this._guid;
        }

        public TimedGUID(GUID gUID) {
            this._guid = gUID;
            this.MAX_LIFE = -1L;
            this._creationTime = -1L;
        }

        public TimedGUID(GUID gUID, long l) {
            this._guid = gUID;
            this.MAX_LIFE = l;
            this._creationTime = System.currentTimeMillis();
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof TimedGUID) {
                return this._guid.equals(((TimedGUID)object)._guid);
            }
            return false;
        }

        public int hashCode() {
            return this._guid.hashCode();
        }

        public boolean shouldExpire(long l) {
            return l - this._creationTime >= this.MAX_LIFE;
        }

        public String toString() {
            return this._guid.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GUIDByteComparator
    implements Comparator<byte[]> {
        @Override
        public int compare(byte[] byArray, byte[] byArray2) {
            return GUID.compare(byArray, byArray2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GUIDComparator
    implements Comparator<GUID> {
        @Override
        public int compare(GUID gUID, GUID gUID2) {
            return GUID.compare(gUID.bytes, gUID2.bytes);
        }
    }
}

