/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.gnutella.Acceptor;
import com.limegroup.gnutella.ApplicationServices;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.ConnectionServices;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.PushManager;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.connection.RoutedConnection;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingReply;
import com.limegroup.gnutella.messages.PushRequest;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.vendor.SimppVM;
import com.limegroup.gnutella.search.SearchResultHandler;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.settings.UploadSettings;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLDocumentHelper;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.FixedsizeForgetfulHashMap;
import org.limewire.io.NetworkUtils;
import org.limewire.security.SecureMessage;
import org.limewire.security.SecureMessageCallback;
import org.limewire.security.SecureMessageVerifier;
import org.limewire.service.ErrorService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public final class ForMeReplyHandler
implements ReplyHandler,
SecureMessageCallback {
    private static final Log LOG = LogFactory.getLog(ForMeReplyHandler.class);
    private final Map<String, AtomicInteger> PUSH_REQUESTS = Collections.synchronizedMap(new FixedsizeForgetfulHashMap(200));
    private final Map<GUID, GUID> GUID_REQUESTS = Collections.synchronizedMap(new FixedsizeForgetfulHashMap(200));
    private final NetworkManager networkManager;
    private final SecureMessageVerifier secureMessageVerifier;
    private final Provider<ConnectionManager> connectionManager;
    private final Provider<SearchResultHandler> searchResultHandler;
    private final Provider<DownloadManager> downloadManager;
    private final Provider<PushManager> pushManager;
    private final ScheduledExecutorService backgroundExecutor;
    private final ApplicationServices applicationServices;
    private final ConnectionServices connectionServices;
    private final LimeXMLDocumentHelper limeXMLDocumentHelper;
    private final Provider<IPFilter> ipFilterProvider;

    @Inject
    ForMeReplyHandler(NetworkManager networkManager, SecureMessageVerifier secureMessageVerifier, Provider<ConnectionManager> provider, Provider<SearchResultHandler> provider2, Provider<DownloadManager> provider3, Provider<Acceptor> provider4, Provider<PushManager> provider5, @Named(value="backgroundExecutor") ScheduledExecutorService scheduledExecutorService, ApplicationServices applicationServices, ConnectionServices connectionServices, LimeXMLDocumentHelper limeXMLDocumentHelper, Provider<IPFilter> provider6) {
        this.networkManager = networkManager;
        this.secureMessageVerifier = secureMessageVerifier;
        this.connectionManager = provider;
        this.searchResultHandler = provider2;
        this.downloadManager = provider3;
        this.pushManager = provider5;
        this.backgroundExecutor = scheduledExecutorService;
        this.applicationServices = applicationServices;
        this.connectionServices = connectionServices;
        this.limeXMLDocumentHelper = limeXMLDocumentHelper;
        this.ipFilterProvider = provider6;
        this.backgroundExecutor.scheduleWithFixedDelay(new Runnable(){

            public void run() {
                ForMeReplyHandler.this.PUSH_REQUESTS.clear();
            }
        }, 30000L, 30000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void handlePingReply(PingReply pingReply, ReplyHandler replyHandler) {
        if (pingReply.getHops() <= 1 && replyHandler.getNumMessagesReceived() <= 2 && !replyHandler.isOutgoing() && replyHandler.isKillable() && pingReply.getFiles() < (long)SharingSettings.FREELOADER_FILES.getValue() && (int)(Math.random() * 100.0) > SharingSettings.FREELOADER_ALLOWED.getValue() && replyHandler instanceof RoutedConnection && replyHandler.isStable()) {
            ((ConnectionManager)this.connectionManager.get()).remove((RoutedConnection)replyHandler);
        }
    }

    @Override
    public void handleQueryReply(QueryReply queryReply, ReplyHandler replyHandler) {
        boolean bl;
        if (queryReply.isFakeMulticast()) {
            return;
        }
        if (queryReply.isReplyToMulticastQuery()) {
            if (queryReply.isTCP()) {
                return;
            }
            if (queryReply.getHops() != 1 || queryReply.getTTL() != 0) {
                return;
            }
        }
        if (!(bl = ForMeReplyHandler.addXMLToResponses(queryReply, this.limeXMLDocumentHelper))) {
            return;
        }
        if (replyHandler != null && replyHandler.isPersonalSpam(queryReply)) {
            return;
        }
        if (queryReply.hasSecureData() && ApplicationSettings.USE_SECURE_RESULTS.getValue()) {
            this.secureMessageVerifier.verify(queryReply, this);
        } else {
            this.routeQueryReplyInternal(queryReply);
        }
    }

    @Override
    public void handleSecureMessage(SecureMessage secureMessage, boolean bl) {
        if (bl) {
            this.routeQueryReplyInternal((QueryReply)secureMessage);
        }
    }

    private void routeQueryReplyInternal(QueryReply queryReply) {
        ((SearchResultHandler)this.searchResultHandler.get()).handleQueryReply(queryReply);
        ((DownloadManager)this.downloadManager.get()).handleQueryReply(queryReply);
    }

    public static boolean addXMLToResponses(QueryReply queryReply, LimeXMLDocumentHelper limeXMLDocumentHelper) {
        int n;
        Object[] objectArray;
        String string = "";
        try {
            LOG.trace((Object)"Trying to do uncompress XML.....");
            objectArray = queryReply.getXMLBytes();
            if (objectArray.length > 1) {
                byte[] byArray = LimeXMLUtils.uncompress(objectArray);
                string = new String(byArray, "UTF-8");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            ErrorService.error(unsupportedEncodingException);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (string.equals("")) {
            return true;
        }
        try {
            objectArray = queryReply.getResultsArray();
            n = objectArray.length;
        }
        catch (BadPacketException badPacketException) {
            LOG.trace((Object)"Unable to get responses", (Throwable)badPacketException);
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("xmlCollectionString = " + string));
        }
        List<LimeXMLDocument[]> list = limeXMLDocumentHelper.getDocuments(string, n);
        block5: for (int i = 0; i < n; ++i) {
            byte by = objectArray[i];
            for (int j = 0; j < list.size(); ++j) {
                LimeXMLDocument[] limeXMLDocumentArray = list.get(j);
                if (limeXMLDocumentArray == null || limeXMLDocumentArray[i] == null) continue;
                by.setDocument(limeXMLDocumentArray[i]);
                continue block5;
            }
        }
        return true;
    }

    @Override
    public void handlePushRequest(PushRequest pushRequest, ReplyHandler replyHandler) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("push: " + pushRequest + "\nfrom: " + replyHandler));
        }
        if (replyHandler.isPersonalSpam(pushRequest)) {
            LOG.debug((Object)"discarded as personal spam");
            return;
        }
        byte[] byArray = pushRequest.getIP();
        String string = NetworkUtils.ip2string(byArray);
        GUID gUID = new GUID(pushRequest.getGUID());
        if (this.GUID_REQUESTS.put(gUID, gUID) != null) {
            LOG.debug((Object)"already serviced");
            return;
        }
        AtomicInteger atomicInteger = this.PUSH_REQUESTS.get(string);
        if (atomicInteger == null) {
            atomicInteger = new AtomicInteger(1);
            this.PUSH_REQUESTS.put(string, atomicInteger);
        } else {
            atomicInteger.addAndGet(1);
            if (atomicInteger.get() > UploadSettings.MAX_PUSHES_PER_HOST.getValue()) {
                LOG.debug((Object)"over max pushes per host");
                return;
            }
        }
        if (!((IPFilter)this.ipFilterProvider.get()).allow(byArray)) {
            LOG.debug((Object)"blocked by ip filter");
            return;
        }
        int n = pushRequest.getPort();
        if (!NetworkUtils.isValidPort(n)) {
            LOG.debug((Object)"invalid port");
            return;
        }
        String string2 = new GUID(pushRequest.getClientGUID()).toString();
        ((PushManager)this.pushManager.get()).acceptPushUpload(string, n, string2, pushRequest.isMulticast(), pushRequest.isFirewallTransferPush(), pushRequest.isTLSCapable());
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public int getNumMessagesReceived() {
        return 0;
    }

    @Override
    public void countDroppedMessage() {
    }

    @Override
    public boolean isSupernodeClientConnection() {
        return false;
    }

    @Override
    public boolean isPersonalSpam(Message message) {
        return false;
    }

    public void updateHorizonStats(PingReply pingReply) {
    }

    @Override
    public boolean isOutgoing() {
        return false;
    }

    @Override
    public boolean isKillable() {
        return false;
    }

    @Override
    public boolean isLeafConnection() {
        return !this.connectionServices.isSupernode();
    }

    @Override
    public boolean isHighDegreeConnection() {
        return false;
    }

    @Override
    public boolean isUltrapeerQueryRoutingConnection() {
        return false;
    }

    @Override
    public boolean isGoodUltrapeer() {
        return false;
    }

    @Override
    public boolean isGoodLeaf() {
        return false;
    }

    @Override
    public boolean supportsPongCaching() {
        return true;
    }

    @Override
    public boolean allowNewPings() {
        return true;
    }

    @Override
    public InetAddress getInetAddress() {
        try {
            return InetAddress.getByName(NetworkUtils.ip2string(this.networkManager.getAddress()));
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    @Override
    public InetSocketAddress getInetSocketAddress() {
        return new InetSocketAddress(this.getInetAddress(), this.getPort());
    }

    @Override
    public int getPort() {
        return this.networkManager.getPort();
    }

    @Override
    public String getAddress() {
        return NetworkUtils.ip2string(this.networkManager.getAddress());
    }

    @Override
    public void handleSimppVM(SimppVM simppVM) {
        throw new IllegalStateException("ForMeReplyHandler asked to send vendor message");
    }

    @Override
    public boolean isStable() {
        return true;
    }

    @Override
    public String getLocalePref() {
        return ApplicationSettings.LANGUAGE.getValue();
    }

    @Override
    public void reply(Message message) {
    }

    @Override
    public byte[] getClientGUID() {
        return this.applicationServices.getMyGUID();
    }
}

