/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import java.io.File;
import java.util.EventObject;

public class FileManagerEvent
extends EventObject {
    private final Type type;
    private final FileDesc[] fds;
    private final File[] files;
    private final int relativeDepth;
    private final File rootShare;

    public FileManagerEvent(FileManager fileManager, Type type) {
        super(fileManager);
        this.type = type;
        this.fds = null;
        this.files = null;
        this.relativeDepth = -1;
        this.rootShare = null;
    }

    public FileManagerEvent(FileManager fileManager, Type type, FileDesc ... fileDescArray) {
        super(fileManager);
        this.type = type;
        this.fds = fileDescArray;
        this.relativeDepth = -1;
        this.rootShare = null;
        this.files = new File[fileDescArray != null ? fileDescArray.length : 0];
        for (int i = 0; fileDescArray != null && i < fileDescArray.length; ++i) {
            this.files[i] = fileDescArray[i].getFile();
        }
    }

    public FileManagerEvent(FileManager fileManager, Type type, File ... fileArray) {
        super(fileManager);
        this.type = type;
        this.files = fileArray;
        this.fds = null;
        this.relativeDepth = 0;
        this.rootShare = null;
    }

    public FileManagerEvent(FileManager fileManager, Type type, File file, int n, File ... fileArray) {
        super(fileManager);
        this.type = type;
        this.files = fileArray;
        this.fds = null;
        this.relativeDepth = n;
        this.rootShare = file;
    }

    public Type getType() {
        return this.type;
    }

    public FileManager getFileManager() {
        return (FileManager)this.getSource();
    }

    public FileDesc[] getFileDescs() {
        return this.fds;
    }

    public File[] getFiles() {
        return this.files;
    }

    public int getRelativeDepth() {
        return this.relativeDepth;
    }

    public File getRootShare() {
        return this.rootShare;
    }

    public boolean isAddEvent() {
        return this.type.equals((Object)Type.ADD_FILE);
    }

    public boolean isAddStoreEvent() {
        return this.type.equals((Object)Type.ADD_STORE_FILE);
    }

    public boolean isRemoveEvent() {
        return this.type.equals((Object)Type.REMOVE_FILE);
    }

    public boolean isRenameEvent() {
        return this.type.equals((Object)Type.RENAME_FILE);
    }

    public boolean isChangeEvent() {
        return this.type.equals((Object)Type.CHANGE_FILE);
    }

    public boolean isFailedEvent() {
        return this.type.equals((Object)Type.ADD_FAILED_FILE);
    }

    public boolean isAlreadySharedEvent() {
        return this.type.equals((Object)Type.ALREADY_SHARED_FILE);
    }

    public boolean isAddFolderEvent() {
        return this.type.equals((Object)Type.ADD_FOLDER);
    }

    public boolean isRemoveFolderEvent() {
        return this.type.equals((Object)Type.REMOVE_FOLDER);
    }

    public boolean isFileManagerLoading() {
        return this.type.equals((Object)Type.FILEMANAGER_LOADING);
    }

    public boolean isFileManagerLoaded() {
        return this.type.equals((Object)Type.FILEMANAGER_LOADED);
    }

    public boolean isFileEvent() {
        return !this.isFolderEvent() && !this.isFileManagerEvent();
    }

    public boolean isFolderEvent() {
        return this.isAddFolderEvent() || this.isRemoveFolderEvent();
    }

    public boolean isFileManagerEvent() {
        return this.isFileManagerLoading() || this.isFileManagerLoaded();
    }

    public String toString() {
        int n;
        StringBuilder stringBuilder = new StringBuilder("FileManagerEvent: [event=").append((Object)this.type);
        if (this.fds != null) {
            stringBuilder.append(", fds=").append(this.fds.length).append("\n");
            for (n = 0; n < this.fds.length; ++n) {
                stringBuilder.append(this.fds[n]);
                if (n == this.fds.length - 1) continue;
                stringBuilder.append(", ");
            }
        } else {
            stringBuilder.append(", fds=null");
        }
        if (this.files != null) {
            stringBuilder.append(", files=").append(this.files.length).append("\n");
            for (n = 0; n < this.files.length; ++n) {
                stringBuilder.append(this.files[n]);
                if (n == this.files.length - 1) continue;
                stringBuilder.append(", ");
            }
        } else {
            stringBuilder.append(", files=null");
        }
        return stringBuilder.append("]").toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        ADD_FILE,
        REMOVE_FILE,
        RENAME_FILE,
        CHANGE_FILE,
        ADD_FAILED_FILE,
        ALREADY_SHARED_FILE,
        ADD_FOLDER,
        REMOVE_FOLDER,
        FILEMANAGER_LOADING,
        FILEMANAGER_LOADED,
        ADD_STORE_FILE,
        ADD_STORE_FAILED_FILE,
        REMOVE_STORE_FILE,
        ADD_STORE_FOLDER,
        REMOVE_STORE_FOLDER;

    }
}

